% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setup_package.R
\name{setup_package}
\alias{setup_package}
\title{Setup Personal Package}
\usage{
setup_package(path, packagename, core = NULL)
}
\arguments{
\item{path}{The path in which the package shall be created.
If it exists, it is used. If it does not exist, it is created, provided
that the parent path exists.}

\item{packagename}{The name of the newly generated package. It will be
checked to make sure it meets R package naming conventions.}

\item{core}{A vector or list containing package names that shall be attached
when the newly generated package is loaded. The packages must be installed
on the current system, otherwise an error will be shown.}
}
\description{
A function to setup a new personal package or update an existing package.
}
\examples{
\donttest{
# create package "mypackage" in temporary directory with
# the core packages dplyr, glue and purrr
withr::with_tempdir({
  install.packages(
    c("dplyr", "glue", "purrr"),
    repos = "http://cran.us.r-project.org"
  )
  setup_package(
    path = tempdir(),
    packagename = "mypackage",
    core = c("dplyr", "glue", "purrr")
  )
})
}
}
