% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.clusterlm.R
\name{summary.clusterlm}
\alias{summary.clusterlm}
\title{Summarize of a \code{clusterlm} object.}
\usage{
\method{summary}{clusterlm}(
  object,
  alternative = "two.sided",
  multcomp = NULL,
  table_type = NULL,
  ...
)
}
\arguments{
\item{object}{A \code{clusterlm} object.}

\item{alternative}{A character string indicating the alternative hypothesis. Choose between \code{"two.sided"}, \code{"greater"}, \code{"less"}. Default is \code{"two.sided"}.}

\item{multcomp}{A character string indicating the multiple comparison procedure to display.}

\item{table_type}{A character string indicating the type of table to display. Choose between \code{"cluster"}, which aggregates test into pseudo-clusters (see details for the interpretations) or \code{"full"} which displays the p-values for all tests. See details for default values.}

\item{...}{Further arguments see details.}
}
\value{
A table for each effect indicating the statistics and p-values of the clusters.
}
\description{
Display the corrected p-values for each effects.
}
\details{
It creates the full table when the number of tests is <=15 and creates a table of pseudo-clusters overwise. Note that for the \code{"troendle"} method is not based on clustering of the data and the table of pseudo-clusters should only be used to facilitate the reading of the results.
}
\seealso{
Other summary: 
\code{\link{print.clusterlm}()}
}
\concept{summary}
