% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_performance.lm.R
\name{model_performance.lm}
\alias{model_performance.lm}
\title{Performance of Regression Models}
\usage{
\method{model_performance}{lm}(model, metrics = "all", verbose = TRUE, ...)
}
\arguments{
\item{model}{A model.}

\item{metrics}{Can be \code{"all"}, \code{"common"} or a character vector of
metrics to be computed (one or more of \code{"AIC"}, \code{"AICc"}, \code{"BIC"}, \code{"R2"},
\code{"R2_adj"}, \code{"RMSE"}, \code{"SIGMA"}, \code{"LOGLOSS"}, \code{"PCP"}, \code{"SCORE"}).
\code{"common"} will compute AIC, BIC, R2 and RMSE.}

\item{verbose}{Toggle off warnings.}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A data frame (with one row) and one column per "index" (see \code{metrics}).
}
\description{
Compute indices of model performance for regression models.
}
\details{
Depending on \code{model}, following indices are computed:
\itemize{
\item{\strong{AIC}} {Akaike's Information Criterion, see \code{?stats::AIC}}
\item{\strong{AICc}} {Second-order (or small sample) AIC with a correction for small sample sizes}
\item{\strong{BIC}} {Bayesian Information Criterion, see \code{?stats::BIC}}
\item{\strong{R2}} {r-squared value, see \code{\link[=r2]{r2()}}}
\item{\strong{R2_adj}} {adjusted r-squared, see \code{\link[=r2]{r2()}}}
\item{\strong{RMSE}} {root mean squared error, see \code{\link[=performance_rmse]{performance_rmse()}}}
\item{\strong{SIGMA}} {residual standard deviation, see \code{\link[insight:get_sigma]{insight::get_sigma()}}}
\item{\strong{LOGLOSS}} {Log-loss, see \code{\link[=performance_logloss]{performance_logloss()}}}
\item{\strong{SCORE_LOG}} {score of logarithmic proper scoring rule, see \code{\link[=performance_score]{performance_score()}}}
\item{\strong{SCORE_SPHERICAL}} {score of spherical proper scoring rule, see \code{\link[=performance_score]{performance_score()}}}
\item{\strong{PCP}} {percentage of correct predictions, see \code{\link[=performance_pcp]{performance_pcp()}}}
}

\code{model_performance()} correctly detects transformed response and
returns the "corrected" AIC and BIC value on the original scale. To get back
to the original scale, the likelihood of the model is multiplied by the
Jacobian/derivative of the transformation.
}
\examples{
model <- lm(mpg ~ wt + cyl, data = mtcars)
model_performance(model)

model <- glm(vs ~ wt + mpg, data = mtcars, family = "binomial")
model_performance(model)
}
