% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dCor_test.R
\name{dCorTest}
\alias{dCorTest}
\title{dCor test for similarity of two matrices}
\usage{
dCorTest(Dx, Dy, nperm)
}
\arguments{
\item{Dx}{A numeric matrix of pairwise distances.}

\item{Dy}{A second numeric matrix of pairwise distances.}

\item{nperm}{The number of times to permute the rows and columns of \code{Dy}.}
}
\value{
A list contains RV coefficient and permutation P value.
}
\description{
This function performs dCor test for association between two distance matrices and computes permutation 
P value. Permutation P value is computed by randomly permuting rows and columns of the 
second distance matrix.
}
\examples{

x <- runif(8)
y <- runif(8)
# Distance matrices
distX = as.matrix(dist(x, upper = TRUE, diag = TRUE))
distY = as.matrix(dist(y, upper = TRUE, diag = TRUE))

dCorTest(Dx = distX, Dy = distY, nperm = 1000)

}
\references{
G. J. Szekely, M. L. Rizzo, and N. K. Bakirov. (2007). Measuring and testing dependence 
             by correlation of distances. The Annals of Statistics, 35(6):2769 - 2794.
}
