% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{penmat}
\alias{penmat}
\title{Extract estimated penalty matrix}
\usage{
penmat(x, type = "full", which = NULL)
}
\arguments{
\item{x}{An object of class \code{\linkS4class{penfa}}, that is, a
fitted penalized factor model.}

\item{type}{Character denoting the type of penalization. Type equal to
\code{"full"} returns the complete penalty matrix; \code{type="shrink"}
returns the penalty matrix for shrinkage; \code{type="diff"}
the penalty matrix for parameter equivalence. The matrix
returned by \code{type="full"} is the sum of all the \code{shrink} and
\code{diff} penalty sub-matrices.}

\item{which}{Character prompting the extraction of the penalty matrix
component corresponding to the specified model matrix. It is only valid
when \code{type="shrink"} or \code{type="diff"}. Possible values are
\code{"lambda"}, \code{"psi"}, \code{"phi"}, \code{"tau"}, \code{"kappa"}
and \code{"none"}.  Only the model matrices penalized during model fitting
(i.e., in the \code{penfa} call) can appear in the \code{which} argument.}
}
\value{
A penalty matrix of class \code{penfaPenMat}. If multiple elements
are specified in the \code{which} argument, a list of penalty matrices (one
for each element, and each of class \code{penfaPenMat}) is returned.
}
\description{
A utility that extracts the estimated penalty matrix from a
fitted object of class \code{penfa}.
}
\seealso{
\code{\link{penfa}}
}
