% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/performance_prc.R
\name{performance_prc}
\alias{performance_prc}
\title{Predictive performance of the PRC-LMM and PRC-MLPMM models}
\usage{
performance_prc(step2, step3, metric = c("tdauc", "c", "brier"),
  times = c(2, 3), n.cores = 1, verbose = TRUE)
}
\arguments{
\item{step2}{the output of either \code{\link{summarize_lmms}} 
or \code{\link{summarize_mlpmms}} (step 2 of the estimation of
PRC)}

\item{step3}{the output of \code{\link{fit_prclmm}} or
\code{\link{fit_prcmlpmm}} (step 3 of PRC)}

\item{metric}{the desired performance measure(s). Options include: 'tdauc',
'c' and 'brier'}

\item{times}{numeric vector with the time points at which
to estimate the time-dependent AUC and time-dependent Brier score}

\item{n.cores}{number of cores to use to parallelize part of
the computations. If \code{ncores = 1} (default), 
no parallelization is done. Pro tip: you can use 
\code{parallel::detectCores()} to check how many 
cores are available on your computer}

\item{verbose}{if \code{TRUE} (default and recommended value), information
on the ongoing computations is printed in the console}
}
\value{
A list containing the following objects:
\itemize{
\item \code{call}: the function call;
\item \code{concordance}: a data frame with the naive and
optimism-corrected estimates of the concordance (C) index;
\item \code{tdAUC}: a data frame with the naive and
optimism-corrected estimates of the time-dependent AUC
at the desired time points;
\item \code{Brier}: a data frame with the naive and
optimism-corrected estimates of the time-dependent Brier score
at the desired time points;
}
}
\description{
This function computes the naive and optimism-corrected
measures of performance (C index, time-dependent AUC and time-dependent 
Brier score) for the PRC models proposed 
in Signorelli et al. (2021). The optimism
correction is computed based on a cluster bootstrap
optimism correction procedure (CBOCP)
}
\examples{
\donttest{
data(fitted_prclmm)

more.cores = FALSE
# IMPORTANT: set more.cores = TRUE to speed computations up!
if (!more.cores) n.cores = 2
if (more.cores) {
   # identify number of available cores on your machine
   n.cores = parallel::detectCores()
   if (is.na(n.cores)) n.cores = 2
}
                   
# compute the time-dependent AUC
perf = performance_prc(fitted_prclmm$step2, fitted_prclmm$step3,
             metric = 'tdauc', times = c(3, 3.5, 4), n.cores = n.cores)
 # use metric = 'brier' for the Brier score and metric = 'c' for the
 # concordance index

# time-dependent AUC estimates:
ls(perf)
perf$tdAUC
}
}
\references{
Signorelli, M. (2023). pencal: an R Package for the Dynamic 
Prediction of Survival with Many Longitudinal Predictors.
arXiv preprint: arXiv:2309.15600

Signorelli, M., Spitali, P., Al-Khalili Szigyarto, C, 
The MARK-MD Consortium, Tsonaka, R. (2021). 
Penalized regression calibration: a method for the prediction 
of survival outcomes using complex longitudinal and 
high-dimensional data. Statistics in Medicine, 40 (27), 6178-6196.
DOI: 10.1002/sim.9178
}
\seealso{
for the PRC-LMM model: \code{\link{fit_lmms}} (step 1),
\code{\link{summarize_lmms}} (step 2) and \code{\link{fit_prclmm}} (step 3);
for the PRC-MLPMM model: \code{\link{fit_mlpmms}} (step 1),
\code{\link{summarize_mlpmms}} (step 2) and \code{\link{fit_prcmlpmm}} (step 3).
}
\author{
Mirko Signorelli
}
