% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PHcure.object.R
\name{PHcure.object}
\alias{PHcure.object}
\title{Standard PH cure model object}
\arguments{
\item{b}{a numeric vector with the estimated regression coefficients in the cure (incidence) component.}

\item{beta}{a numeric vector with the true estimated regression coefficients in the survival (latency) component.}

\item{cumhaz}{a numeric vector with the estimated cumulative baseline hazard function at the unique event times (reported in the \code{"names"} attribute).}

\item{logL}{the value of the log-likelihood for the estimated model.}

\item{converged}{an integer to indicate if the Expectation-Maximization (EM) algorithm converged. The possible values are: \code{1} if it converged, \code{-1} if it exceeded the maximum number of iterations or \code{-2} if it stopped due to non-finite elements in the regression coefficients.}

\item{iter}{the maximum number of iteration before the convergence of the Expectation-Maximization (EM) algorithm.}

\item{N}{the sample size (number of individuals).}

\item{K}{the number of unique failure times.}

\item{isTies}{logical value: \code{TRUE} in case of tied event times.}

\item{censoring}{the proportion of censored individuals.}

\item{which.X}{character string indicating the method used to transform the covariates included in the incidence (cure) component from time-varying to time-invariant. See \code{\link{penPHcure}} for more details.}

\item{survform}{a formula object with all variables involved in the latency (survival) component of the model.}

\item{cureform}{a formula object with all variables involved in the incidence (survival) component of the model.}

\item{inference}{[optional] a list with elements named \code{bs}, \code{betas} and \code{nboot}. The elements \code{bs} and \code{betas} are matrices containing on each row the estimated regression coefficients in the incidence and latency components, respectively, for each of the \code{nboot} bootstrap resamples. This object is returned only if the function \code{\link{penPHcure}} was called with the argument inference = TRUE.}

\item{call}{object of class \code{call}, with all the specified arguments.}
}
\description{
This class of objects is returned by the function \code{\link{penPHcure}} when is called with the argument \code{pen.type = "none"}. Objects of this class have methods for the functions \code{summary} and \code{predict}.
}
\seealso{
\code{\link{penPHcure}}
}
