% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ped.R
\name{ped}
\alias{ped}
\alias{singleton}
\alias{singletons}
\title{Pedigree construction}
\usage{
ped(
  id,
  fid,
  mid,
  sex,
  famid = "",
  reorder = TRUE,
  validate = TRUE,
  detectLoops = TRUE,
  isConnected = FALSE,
  verbose = FALSE
)

singleton(id = 1, sex = 1, famid = "")

singletons(id, sex = 1)
}
\arguments{
\item{id}{A vector (coercible to character) of individual ID labels.}

\item{fid, mid}{Vectors of the same length as \code{id}, naming the father and
mother of each individual, respectively. Missing parents (i.e.,
corresponding to founder individuals) may be entered as "0", "" or NA.}

\item{sex}{A numeric of the same length as \code{id}, describing the genders of
the individuals (in the same order as \code{id}.) Each entry must be either 1
(=male), 2 (=female) or 0 (=unknown).}

\item{famid}{A character string. Default: An empty string.}

\item{reorder}{A logical indicating if the pedigree should be reordered so
that all parents precede their children. Default: TRUE.}

\item{validate}{A logical indicating if a validation of the pedigree
structure should be performed. Default: TRUE.}

\item{detectLoops}{A logical indicating if the presence of loops should be
detected. Setting this to FALSE may speed up the processing of large
pedigrees. Default: TRUE.}

\item{isConnected}{A logical indicating if the input is known to be a
connected pedigree. Setting this to TRUE speeds up the processing. Default:
FALSE.}

\item{verbose}{A logical.}
}
\value{
A \code{ped} object, which is essentially a list with the following
entries:
\itemize{
\item \code{ID} : A character vector of ID labels. Unless the pedigree is reordered
during creation, this equals \code{as.character(id)}
\item \code{FIDX} : An integer vector with paternal indices: For each \eqn{j =
  1,2,...}, the entry \code{FIDX[j]} is 0 if \code{ID[j]} has no father within the
pedigree; otherwise \code{ID[FIDX[j]]} is the father of \code{ID[j]}.
\item \code{MIDX} : An integer vector with maternal indices: For each \eqn{j =
  1,2,...}, the entry \code{MIDX[j]} is 0 if \code{ID[j]} has no mother within the
pedigree; otherwise \code{ID[MIDX[j]]} is the mother of \code{ID[j]}.
\item \code{SEX} : An integer vector with gender codes. Unless the pedigree is
reordered, this equals \code{as.integer(sex)}.
\item \code{FAMID} : The family ID.
\item \code{UNBROKEN_LOOPS} : A logical indicating if the pedigree has unbroken
loops, or NA if the status is currently unknown.
\item \code{LOOP_BREAKERS} : A matrix with loop breaker ID's in the first column and
their duplicates in the second column. All entries refer to the internal
IDs. This is usually set by \code{\link[=breakLoops]{breakLoops()}}.
\item \code{FOUNDER_INBREEDING} : A list of two potential entries, "autosomal" and
"x"; both numeric vectors with the same length as \code{founders(x)}.
\code{FOUNDER_INBREEDING} is always NULL when a new \code{ped} is created. See
\code{\link[=founderInbreeding]{founderInbreeding()}}.
\item \code{MARKERS} : A list of \code{marker} objects, or NULL.
}
}
\description{
This is the basic constructor of \code{ped} objects. Utility functions for
creating many common pedigree structures are described in \link{ped_basic}. See
also \code{\link[=as.ped]{as.ped()}} and \code{\link[=readPed]{readPed()}}, which are more liberal regarding the input
format.
}
\details{
Each individual must have either both parents specified, or no parents.
Missing parents are indicated with entries "0", "" or NA in \code{fid} and \code{mid}.
Note that \code{id},\code{fid},\code{mid} are all converted to character vectors before
matching to establish the parent connections.

If the pedigree is disconnected, it is split into its connected components
and returned as a list of \code{ped} objects.

A singleton is a special \code{ped} object whose pedigree contains 1 individual.
The class attribute of a singleton is \code{c('singleton', 'ped')}.

\code{singletons()} creates a list of singletons with the indicated labels and
sexes.

Selfing, i.e. the presence of pedigree members whose father and mother are
the same individual, is allowed in \code{ped} objects. Any such "self-fertilizing"
parent must have undecided sex (\code{sex = 0}).
}
\examples{
# Trio
x = ped(id = 1:3, fid = c(0,0,1), mid = c(0,0,2), sex = c(1,2,1))

# Female singleton
y = singleton('NN', sex = 2)

# Selfing
z = ped(id = 1:2, fid = 0:1, mid = 0:1, sex = 0:1)
stopifnot(hasSelfing(z))

# Disconnected pedigree: Trio + singleton
ped(id = 1:4, fid = c(2,0,0,0), mid = c(3,0,0,0), sex = c(1,1,2,1))

# List of singletons
singletons(1:2)

}
\seealso{
\code{\link[=newPed]{newPed()}}, \link{ped_basic}, \link{ped_modify}, \link{ped_subgroups}, \code{\link[=relabel]{relabel()}}
}
\author{
Magnus Dehli Vigeland
}
