% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.ped.R
\name{is.ped}
\alias{is.ped}
\alias{is.singleton}
\alias{is.pedList}
\title{Is an object a \code{ped} object?}
\usage{
is.ped(x)

is.singleton(x)

is.pedList(x)
}
\arguments{
\item{x}{Any \code{R} object.}
}
\value{
For \code{is.ped()}: TRUE if \code{x} is a \code{ped} or \code{singleton} object, otherwise FALSE.

For \code{is.singleton()}: TRUE if \code{x} is a \code{singleton} object, otherwise FALSE.

For \code{is.pedList()}: TRUE if \code{x} is a list of \code{ped} and/or \code{singleton}
objects, otherwise FALSE.
}
\description{
Functions for checking whether an object is a \code{\link[=ped]{ped()}} object, a \code{\link[=singleton]{singleton()}}
or a list of such.
}
\details{
Note that the \code{singleton} class inherits from \code{ped}, so if \code{x} is a
singleton, \code{is.ped(x)} returns TRUE.
}
\examples{

x1 = nuclearPed(1)
x2 = singleton(1)
stopifnot(is.ped(x1), !is.singleton(x1),
          is.ped(x2), is.singleton(x2),
          is.pedList(list(x1,x2)))

}
\seealso{
\code{\link[=ped]{ped()}}
}
\author{
Magnus Dehli Vigeland
}
