% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assortative.R
\name{assortative}
\alias{assortative}
\title{Data simulation with assortative/disassortative matings}
\usage{
assortative(
  F0size,
  f.rate = 1,
  m.rate = 1,
  mort.rate = 0,
  littersize = 1,
  ngen,
  overlap.s = 0,
  overlap.d = 0,
  Va0,
  Ve,
  fsel = "P",
  msel = "P",
  negative = FALSE
)
}
\arguments{
\item{F0size}{: Even number of founder animals. No mortality and selection in this generation, and matings are random in this generation.}

\item{f.rate}{: Proportion of females selected as dams, default = 1.}

\item{m.rate}{: Proportion of males (\code{<= f.rate}) selected as sires, default = 1.}

\item{mort.rate}{: Mortality rate per generation, after the availability of phenotype (e.g., birth weight, weaning weight)
and before the age of maturity (i.e., before mating), default = 0. Maximum \code{mort.rate} = 0.5.}

\item{littersize}{: Litter size, default = 1.}

\item{ngen}{: Number of generations to simulate.}

\item{overlap.s}{: Number of generation overlaps for sires, default = 0 for no generation overlap.}

\item{overlap.d}{: Number of generation overlaps for dams, default = 0 for no generation overlap.}

\item{Va0}{: Additive genetic variance in the base generation (i.e., F0).}

\item{Ve}{: Environment (plus residual) variance, set constant across generations.}

\item{fsel}{: If \code{"P"} (default), selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages; redundant if \code{f.rate = 1}.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{msel}{: If \code{"P"} (default), selection on phenotypes or true breeding values if \code{Ve} = 0;
if \code{"PA"}, selection on true parent averages; redundant if \code{m.rate = 1}.
\code{"-P"} and \code{"-PA"} work in opposite direction of \code{"P"} and \code{"PA"}, respectively.}

\item{negative}{: Assortative mating if \code{TRUE} (default) and disassortative mating if \code{false}.
Males are sorted based on \code{msel} and females are sorted based on \code{fsel}.}
}
\value{
ped : The output pedigree \code{data.frame}. Further information provided in \strong{Details}.
}
\description{
Simulate Pedigree, genetic merits and phenotypes with assortative/disassortative mating
followed by non-random selection, differntly for males and females.
}
\details{
The output pedigree \code{data.frame} (\code{ped}) has 9 columns: ID, SIRE, DAM, SEX,
GEN (generation number starting with 0 for the base generation), PA (parent average),
MS (Mendelian Sampling), E (environment and residuals), and P (phenotype).
}
\examples{
ped = assortative(
    F0size = 100,
    f.rate = 0.8,
    m.rate = 0.5,
    mort.rate = 0.05,
    littersize = 2,
    ngen = 4,
    overlap.s = 1,
    overlap.d = 0,
    negative = FALSE,
    Va0 = 9,
    Ve = 36,
    fsel = "P",
    msel = "PA"
)

}
