% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{enpoint}
\alias{enpoint}
\title{Represent pdqr-function as a set of points}
\usage{
enpoint(f, n_points = 1001)
}
\arguments{
\item{f}{A pdqr-function.}

\item{n_points}{Desired number of points in the output. Not used in case of
"discrete" type p-, d-, and q-function \code{f}.}
}
\value{
A data frame with \code{n_points} (or less, for "discrete" type p-, d-, or
q-function \code{f}) rows and two columns with names depending on \code{f}'s class
and type.
}
\description{
Function \code{enpoint()} suggests a reasonable default ways of converting
pdqr-function into a data frame of numerical values (points) with desirable
number of rows. Representation of pdqr-function as a set of numbers helps to
conduct analysis using approaches outside of 'pdqr' package. For example, one
can visually display pdqr-function with some other plotting functionality.
}
\details{
Structure of output depends on \link[=meta_class]{class} and
\link[=meta_type]{type} of input pdqr-function \code{f}:
\itemize{
\item \strong{P-functions} are represented with "x" (for "x" values) and "p" (for
cumulative probability at "x" points) columns:
\itemize{
\item For "continuous" type, "x" is taken as an equidistant grid (with
\code{n_points} elements) on input's \link[=meta_support]{support}.
\item For "discrete" type, "x" is taken directly from \link[=meta_x_tbl]{"x_tbl" metadata} without using \code{n_points} argument.
}
\item \strong{D-functions} are represented with "x" column and one more (for values of
d-function at "x" points):
\itemize{
\item For "continuous" type, second column is named "y" and is computed as
values of \code{f} at elements of "x" column (which is the same grid as in
p-function case).
\item For "discrete" it is named "prob". Both "x" and "prob" columns are
taken from "x_tbl" metadata.
}
\item \strong{Q-functions} are represented almost as p-functions but in inverse
fashion. Output data frame has "p" (probabilities) and "x" (values of
q-function \code{f} at "p" elements) columns.
\itemize{
\item For "continuous" type, "p" is computed as equidistant grid (with
\code{n_points} elements) between 0 and 1.
\item For "discrete" type, "p" is taken from "cumprob" column of "x_tbl"
metadata.
}
\item \strong{R-functions} are represented by generating \code{n_points} elements from
distribution. Output data frame has columns "n" (consecutive point number,
basically a row number) and "x" (generated elements).
}

\strong{Note} that the other way to produce points for p-, d-, and q-functions is
to manually construct them with \code{\link[=form_regrid]{form_regrid()}} and \code{\link[=meta_x_tbl]{meta_x_tbl()}}. However,
this method may slightly change function values due to possible
renormalization inside \code{form_regrid()}.
}
\examples{
d_norm <- as_d(dnorm)
head(enpoint(d_norm))

# Control number of points with `n_points` argument
enpoint(d_norm, n_points = 5)

# Different pdqr classes and types produce different column names in output
colnames(enpoint(new_p(1:2, "discrete")))
colnames(enpoint(new_d(1:2, "discrete")))
colnames(enpoint(new_d(1:2, "continuous")))
colnames(enpoint(new_q(1:2, "continuous")))
colnames(enpoint(new_r(1:2, "continuous")))

# Manual way with different output structure
df <- meta_x_tbl(form_regrid(d_norm, 5))
## Difference in values due to `form_regrid()` renormalization
plot(enpoint(d_norm, 5), type = "l")
lines(df[["x"]], df[["y"]], col = "blue")
}
\seealso{
\code{\link[=pdqr_approx_error]{pdqr_approx_error()}} for diagnostics of pdqr-function approximation
accuracy.

\link[=methods-plot]{Pdqr methods for plot()} for a direct plotting of
pdqr-functions.

\code{\link[=form_regrid]{form_regrid()}} to change underlying grid of pdqr-function.
}
