% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CentSim1D.R
\name{IarcCSint}
\alias{IarcCSint}
\title{The indicator for the presence of an arc from a point to another for
Central Similarity  Proximity Catch Digraphs (CS-PCDs) - one interval case}
\usage{
IarcCSint(p1, p2, int, t, c = 0.5)
}
\arguments{
\item{p1}{A 1D point for which the proximity region is constructed.}

\item{p2}{A 1D point for which it is checked whether it resides in the proximity region
of \eqn{p_1} or not.}

\item{int}{A \code{vector} of two real numbers representing an interval.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \code{int}\eqn{=(a,b)}
with the default \code{c=.5}.
For the interval, \code{int}\eqn{=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}.}
}
\value{
\eqn{I(p_2} in \eqn{N_{CS}(p_1,t,c))} for p2, that is, returns 1 if \eqn{p_2} in \eqn{N_{CS}(p_1,t,c)}, returns 0 otherwise
}
\description{
Returns \eqn{I(p_2} in \eqn{N_{CS}(p_1,t,c))} for points \eqn{p_1} and \eqn{p_2}, that is, returns 1 if \eqn{p_2} is in \eqn{N_{CS}(p_1,t,c)},
returns 0 otherwise, where \eqn{N_{CS}(x,t,c)} is the CS proximity region for point \eqn{x} with expansion parameter \eqn{t>0}
and centrality parameter \eqn{c \in (0,1)}.

CS proximity region is constructed with respect to the
interval \eqn{(a,b)}. This function works whether \eqn{p_1} and \eqn{p_2} are inside or outside the interval \code{int}.

Vertex regions for middle intervals are based on the center associated with the centrality parameter
\eqn{c \in (0,1)}. If \eqn{p_1} and \eqn{p_2} are identical, then it returns 1 regardless of their locations
(i.e., loops are allowed in the digraph).

See also (\insertCite{ceyhan:revstat-2016;textual}{pcds}).
}
\examples{
c<-.4
t<-2
a<-0; b<-10; int<-c(a,b)

IarcCSint(7,5,int,t,c)
IarcCSint(17,17,int,t,c)
IarcCSint(15,17,int,t,c)
IarcCSint(1,3,int,t,c)

IarcCSint(-17,17,int,t,c)

IarcCSint(3,5,int,t,c)
IarcCSint(3,3,int,t,c)
IarcCSint(4,5,int,t,c)
IarcCSint(a,5,int,t,c)

c<-.4
r<-2
a<-0; b<-10; int<-c(a,b)

IarcCSint(7,5,int,t,c)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IarcCSmid.int}}, \code{\link{IarcCSend.int}} and \code{\link{IarcPEint}}
}
\author{
Elvan Ceyhan
}
