% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{re.triCM}
\alias{re.triCM}
\title{The index of the \eqn{CM}-edge region in a triangle that contains the point}
\usage{
re.triCM(p, tri)
}
\arguments{
\item{p}{A 2D point for which \eqn{CM}-edge region it resides in is to be determined in the triangle
\code{tri}.}

\item{tri}{A \eqn{3 \times 2} matrix with each row representing a vertex of the triangle.}
}
\value{
A \code{list} with three elements
\item{re}{Index of the \eqn{CM}-edge region that contains point, \code{p} in the triangle \code{tri}.}
\item{tri}{The vertices of the triangle, where row labels are \eqn{A}, \eqn{B}, and \eqn{C}
with edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.}
\item{desc}{Description of the edge labels}
}
\description{
Returns the index of the edge whose region contains point, \code{p}, in
the triangle \code{tri}\eqn{=T(A,B,C)} with edge regions based on center of mass \eqn{CM=(A+B+C)/3}.

Edges are labeled as 3 for edge \eqn{AB}, 1 for edge \eqn{BC}, and 2 for edge \eqn{AC}.
If the point, \code{p}, is not inside \code{tri}, then the function yields \code{NA} as output.
Edge region 1 is the triangle \eqn{T(B,C,CM)}, edge region 2 is \eqn{T(A,C,CM)}, and
edge region 3 is \eqn{T(A,B,CM)}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012,ceyhan:arc-density-CS;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.5,2);
Tr<-rbind(A,B,C);
P<-c(1.4,1.2)
re.triCM(P,Tr)

P<-c(1.5,1.61)
re.triCM(P,Tr)

CM<-(A+B+C)/3

n<-20  #try also n<-40
Xp<-runif.tri(n,Tr)$g

re<-vector()
for (i in 1:n)
  re<-c(re,re.triCM(Xp[i,],Tr)$re)
re

Xlim<-range(Tr[,1],Xp[,1])
Ylim<-range(Tr[,2],Xp[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(Tr,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(Xp,pch=".")
polygon(Tr)
L<-Tr; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
text(Xp,labels=factor(re))

txt<-rbind(Tr,CM)
xc<-txt[,1]
yc<-txt[,2]
txt.str<-c("A","B","C","CM")
text(xc,yc,txt.str)

p1<-(A+B+CM)/3
p2<-(B+C+CM)/3
p3<-(A+C+CM)/3

plot(Tr,xlab="",ylab="",axes=TRUE,pch=".",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Tr)
L<-Tr; R<-matrix(rep(CM,3),ncol=2,byrow=TRUE)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Tr,CM,p1,p2,p3)
xc<-txt[,1]+c(-.02,.02,.02,.02,.02,.02,.02)
yc<-txt[,2]+c(.02,.02,.04,.05,.02,.02,.02)
txt.str<-c("A","B","C","CM","re=3","re=1","re=2")
text(xc,yc,txt.str)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{re.tri.cent}}, \code{\link{re.bas.triCM}}, \code{\link{re.bas.tri.cent}},
\code{\link{reTeCM}}, and \code{\link{edge.reg.triCM}}
}
\author{
Elvan Ceyhan
}
