% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{angle3pnts}
\alias{angle3pnts}
\title{The angle between two line segments}
\usage{
angle3pnts(a, b, c, radian = TRUE)
}
\arguments{
\item{a, b, c}{Three 2D points which represent the intersecting line segments \eqn{[ba]} and \eqn{[bc]}.
The smaller angle between these line segments is to be computed.}

\item{radian}{A logical argument (default=\code{TRUE}). If \code{TRUE}, the (smaller) angle between the line segments
\eqn{[ba]} and \eqn{[bc]} is provided in radians, else it is provided in degrees.}
}
\value{
angle in radians or degrees between the line segments \eqn{[ba]} and \eqn{[bc]}
}
\description{
Returns the angle in radians or degrees between two vectors or line segments at the point of
intersection. The line segments are \eqn{[ba]} and \eqn{[bc]} when the arguments of the function are given as \code{a,b,c}.
\code{radian} is a logical argument (default=\code{TRUE}) which yields the angle in radians if \code{TRUE}, and in degrees if \code{FALSE}.
The smaller of the angle between the line segments is provided by the function.
}
\examples{
A<-c(.3,.2); B<-c(.6,.3); C<-c(1,1)
pts<-rbind(A,B,C)

angle3pnts(A,B,C)

angle3pnts(A,B,A)
round(angle3pnts(A,B,A),7)

angle3pnts(A,B,C,radian=FALSE)

#plot of the line segments
Xlim<-range(pts[,1])
Ylim<-range(pts[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

ang1<-angle3pnts(A,B,C,radian=FALSE)
ang2<-angle3pnts(B+c(1,0),B,C,radian=FALSE)

sa<-angle.str2end(A,B,C,radian=FALSE)$s #small arc angles
ang1<-sa[1]
ang2<-sa[2]

plot(pts,asp=1,pch=1,xlab="x",ylab="y",
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
L<-rbind(B,B); R<-rbind(A,C)
segments(L[,1], L[,2], R[,1], R[,2], lty=2)
plotrix::draw.arc(B[1],B[2],radius=xd*.1,deg1=ang1,deg2=ang2)
txt<-rbind(A,B,C)
text(txt+cbind(rep(xd*.05,nrow(txt)),rep(-xd*.02,nrow(txt))),c("A","B","C"))

text(rbind(B)+.15*xd*c(cos(pi*(ang2+ang1)/360),sin(pi*(ang2+ang1)/360)),
paste(round(abs(ang1-ang2),2)," degrees"))

}
\seealso{
\code{\link{angle.str2end}}
}
\author{
Elvan Ceyhan
}
