% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxRFuncs4PCDClasses.r
\name{summary.Lines}
\alias{summary.Lines}
\title{Return a summary of a \code{Lines} object}
\usage{
\method{summary}{Lines}(object, ...)
}
\arguments{
\item{object}{Object of class \code{Lines}.}

\item{\dots}{Additional parameters for \code{summary}.}
}
\value{
The \code{call} of the object of class '\code{Lines}',
the defining \code{points}, selected x and y points on the line,
equation of the line, and \code{coefficients} of the line (in the form: y = slope * x + intercept).
}
\description{
Returns the below information about the \code{object}:

\code{call} of the function defining the \code{object}, the defining \code{points}, selected x and y points on the line,
equation of the line, and \code{coefficients} of the line.
}
\examples{
A<-c(-1.22,-2.33); B<-c(2.55,3.75)
xr<-range(A,B);
xf<-(xr[2]-xr[1])*.1 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=100)

lnAB<-Line(A,B,x)
lnAB
summary(lnAB)

}
\seealso{
\code{\link{print.Lines}}, \code{\link{print.summary.Lines}}, and \code{\link{plot.Lines}}
}
