% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{paraline}
\alias{paraline}
\title{The line paralel to the line segment joining two distinct 2D points \code{a} and \code{b}}
\usage{
paraline(p, a, b, x)
}
\arguments{
\item{p}{A 2D point at which the parallel line to line segment joining \code{a} and \code{b} crosses.}

\item{a, b}{2D points that determine the line segment (the line will be parallel to this line segment).}

\item{x}{A scalar or a vector of scalars representing the x-coordinates of the line parallel to
ab and crossing \code{p}.}
}
\value{
A list with the elements
\item{desc}{Description of the line passing through point \code{p} and parallel to line segment joining
\code{a} and \code{b}}
\item{mtitle}{The "main" title for the plot of the line passing through point \code{p} and parallel to
line segment joining \code{a} and \code{b}}
\item{points}{The input points p, a, and b (stacked row-wise,
i.e., point \code{p} is in row 1, point \code{a} is in row 2 and point \code{b} is in row 3).
Line parallel to ab crosses p.}
\item{x}{The input vector. It can be a scalar or a vector of scalars,
which constitute the x-coordinates of the point(s) of interest on the line passing through point
\code{p} and parallel to line segment joining \code{a} and \code{b}.}
\item{y}{The output scalar or vector which constitutes the y-coordinates of the point(s) of interest
on the line passing through point \code{p} and parallel to line segment joining \code{a} and \code{b}.
If \code{x} is a scalar, then \code{y} will be a scalar and if \code{x} is a vector of scalars,
then \code{y} will be a vector of scalars.}
\item{slope}{Slope of the line, Inf is allowed, passing through point \code{p} and parallel to
line segment joining \code{a} and \code{b}}
\item{intercept}{Intercept of the line passing through point \code{p} and parallel to line segment
joining \code{a} and \code{b}}
\item{equation}{Equation of the line passing through point \code{p} and parallel to line segment joining
\code{a} and \code{b}}
}
\description{
An object of class "Lines".
Returns the \code{equation, slope, intercept}, and y-coordinates of the line crossing the
point \code{p} and parallel to the line passing through the points \code{a} and \code{b} with
x-coordinates are provided in vector \code{x}.
}
\examples{
A<-c(1.1,1.2); B<-c(2.3,3.4); p<-c(.51,2.5)

paraline(p,A,B,.45)
paraline(A,A,B,.45)

pts<-rbind(A,B,p)
xr<-range(pts)
xf<-(xr[2]-xr[1])*.25 #how far to go at the lower and upper ends in the x-coordinate
x<-seq(xr[1]-xf,xr[2]+xf,l=20)  #try also l=100

plnAB<-paraline(p,A,B,x)
plnAB
summary(plnAB)
plot(plnAB)

y<-plnAB$y
Xlim<-range(x,pts[,1])
if (!is.na(y[1])) {Ylim<-range(y,pts[,2])} else {Ylim<-range(pts[,2])}
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
pf<-c(xd,-yd)*.025

plot(A,pch=".",xlab="",ylab="",xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
points(pts)
txt.str<-c("A","B","p")
text(pts+rbind(pf,pf,pf),txt.str)

segments(A[1],A[2],B[1],B[2],lty=2)
if (!is.na(y[1])) {lines(x,y,type="l",lty=1,xlim=Xlim,ylim=Ylim)} else {abline(v=p[1])}
tx<-(A[1]+B[1])/2;
if (!is.na(y[1])) {ty<-paraline(p,A,B,tx)$y} else {ty=p[2]}
text(tx,ty,"line parallel to AB\n and crossing p")

}
\seealso{
\code{\link{slope}}, \code{\link{Line}}, and \code{\link{perpline}}, \code{\link[stats]{line}}
in the generic stats package, \code{\link{paraline3D}}
}
