% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/pcadapt.R
\name{outlier}
\alias{outlier}
\title{Analysis of the computed p-values}
\usage{
outlier(y, K = NULL, threshold = 0.1, list_selection = NULL)
}
\arguments{
\item{y}{an object of class \code{pcadapt} generated with \code{pcadapt}.}

\item{K}{an integer specifying the principal component the user is interested in. Default value set to \code{1}. NB : this field can be left empty in the
meta-analysis case.}

\item{threshold}{a real value between \code{0} and \code{1} indicating the proportion of false discoveries to be tolerated.}

\item{list_selection}{a vector of indices containing the list of all the SNPs under selection in the case of
a simulation. When this argument is provided, a list of false discovery rates is calculated for
different thresholds. Default value is set to \code{NULL}.}
}
\description{
\code{outlier} returns an object \code{x} containing a list of indices (\code{x$outliers}) corresponding to the SNPs ranked by the chosen p-values
associated with \code{K}-th principal component or obtained with the meta-analysis (\code{x$pvalues}), as well as a list of false discovery rates
computed for different thresholds (which are set in the built-in function \code{fdrList}) in the case of a simulation.
}
\examples{
x <- read4pcadapt("geno3pops",option="example")
y <- pcadapt(x,K=3)
outlier(y,K=1)
}

