% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deltaCI.R
\name{deltaCI}
\alias{deltaCI}
\alias{deltaCI,ANY-method}
\title{Compute Confidence Interval using Delta Method}
\usage{
deltaCI(cond)

\S4method{deltaCI}{ANY}(cond)
}
\arguments{
\item{cond}{list with the result of the perturbed probability for `mj` and `co` and correspondent CI.}
}
\value{
The Confidence Interval for the conditional probability.

Numeric vector representing the computed probability and confidence intervals using the perturbed copula and delta method.
}
\description{
Internal method to compute the probability using delta method which approximates
the variance of a function of random variables (in this case, the ratio) based on the variance of the original estimates.

`deltaCI` general method.
Internal method to compute the probability using delta method which approximates
the variance of a function of random variables (in this case, the ratio) based on the variance of the original estimates.
}
\examples{
  cond <- list(
  c(P = 0.3597117, `2.5\%` = 0.3074215, `97.5\%` = 0.4075315),
  c(P = 0.5682882, `2.5\%` = 0.4560553, `97.5\%` = 0.6823438))
  deltaCI(cond)
}
