% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/111_control.r
\name{RPC Control Functions}
\alias{RPC Control Functions}
\alias{RPC.CT}
\alias{RPC.LI}
\alias{RPC.RR}
\title{Sets of controls in pbdRPC.}
\usage{
RPC.CT(verbose = FALSE, intern = FALSE, wait = TRUE, check.exec = FALSE,
  use.shell.exec = TRUE, pause = TRUE)

RPC.LI(exec.type = "ssh", args = "", pport = "22", user = "snoweye",
  hostname = "192.168.56.101", priv.key = "~/.ssh/id_rsa",
  priv.key.ppk = "./id_rsa.ppk")

RPC.RR(check = "ps ax|grep '[r]emoter::server'",
  kill = "kill -9 $(ps ax|grep '[r]emoter::server'|awk '{print $1}')",
  start = "nohup Rscript -e 'remoter::server()' > .rrlog 2>&1 < /dev/null &",
  preload = "source ~/work-my/00_set_devel_R; ")
}
\arguments{
\item{verbose, intern, wait, check.exec, use.shell.exec, pause}{RPC control for \code{system}, \code{shell.exec}, and so on.
\code{wait = FALSE} allows asynchronous commands which need more test.
e.g. continuously port forwarding without sending commands to background.}

\item{exec.type, args, pport, user, hostname, priv.key, priv.key.ppk}{RPC login information used by \code{\link{rpc}()}, \code{\link{ssh}()}, or
\code{\link{plink}()}.}

\item{check, kill, start, preload}{RPC remoter commands used by \code{\link{check_rr}()},
\code{\link{kill_rr}()}, or \code{\link{start_rr}()}.
RPC pbdCS commands used by \code{\link{check_cs}()},
\code{\link{kill_cs}()}, or \code{\link{start_cs}()}.}
}
\description{
These sets of controls are used to provide default values in pbdRPC package.
}
\author{
Wei-Chen Chen \email{wccsnow@gmail.com}.

Programming with Big Data in R Website: \url{http://r-pbd.org/}
}
\seealso{
\code{\link{.pbd_env}}.
}
\keyword{global}
\keyword{variables}

