% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddmatrix_qr.r
\docType{methods}
\name{qr}
\alias{qr}
\alias{qr.Q}
\alias{qr.R}
\alias{qr.qty}
\alias{qr.qy}
\alias{qr,ddmatrix-method}
\alias{qr.Q,ANY-method}
\alias{qr.R,ANY-method}
\alias{qr.qy,ANY-method}
\alias{qr.qty,ANY-method}
\alias{lq}
\alias{lq.Q}
\title{QR Decomposition Methods}
\usage{
\S4method{qr}{ddmatrix}(x, tol = 1e-07)

\S4method{qr.Q}{ANY}(x, complete = FALSE, Dvec)

\S4method{qr.R}{ANY}(x, complete = FALSE)

\S4method{qr.qy}{ANY}(x, y)

\S4method{qr.qty}{ANY}(x, y)

lq(x)

lq.Q(x, complete = FALSE)
}
\arguments{
\item{x, y}{numeric distributed matrices for \code{qr()}. Otherwise, \code{x}
is a list, namely the return from \code{qr()}.}

\item{tol}{logical value, determines whether or not columns are zero
centered.}

\item{complete}{logical expression of length 1.  Indicates whether an
arbitrary orthogonal completion of the Q or X matrices is to be made, or
whether the R matrix is to be completed by binding zero-value rows beneath
the square upper triangle.}

\item{Dvec}{Not implemented for objects of class \code{ddmatrix}.  vector
(not matrix) of diagonal values.  Each column of the returned Q will be
multiplied by the corresponding diagonal value.  Defaults to all 1's.}
}
\value{
\code{qr()} returns a list consisting of: \code{qr} - \code{rank} -
calculated numerical rank, \code{tau} - \code{pivot} - \code{"class"} -
attribute "qr".
}
\description{
\code{qr()} takes the QR decomposition.
}
\details{
\code{qr.Q()} recovers Q from the output of \code{qr()}.

\code{qr.R()} recovers R from the output of \code{qr()}.

\code{qr.qy()} multiplies \code{y} by Q.

\code{qr.qty()} multiplies \code{y} by the transpose of Q.

Functions for forming a QR decomposition and for using the outputs of these
numerical QR routines.
}
\keyword{Algebra}
\keyword{Linear}
\keyword{Methods}
