% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{detective}
\alias{detective}
\title{Amazon Detective}
\usage{
detective(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Detective uses machine learning and purpose-built visualizations to help
you to analyze and investigate security issues across your Amazon Web
Services (Amazon Web Services) workloads. Detective automatically
extracts time-based events such as login attempts, API calls, and
network traffic from CloudTrail and Amazon Virtual Private Cloud (Amazon
VPC) flow logs. It also extracts findings detected by Amazon GuardDuty.

The Detective API primarily supports the creation and management of
behavior graphs. A behavior graph contains the extracted data from a set
of member accounts, and is created and managed by an administrator
account.

To add a member account to the behavior graph, the administrator account
sends an invitation to the account. When the account accepts the
invitation, it becomes a member account in the behavior graph.

Detective is also integrated with Organizations. The organization
management account designates the Detective administrator account for
the organization. That account becomes the administrator account for the
organization behavior graph. The Detective administrator account is also
the delegated administrator account for Detective in Organizations.

The Detective administrator account can enable any organization account
as a member account in the organization behavior graph. The organization
accounts do not receive invitations. The Detective administrator account
can also invite other accounts to the organization behavior graph.

Every behavior graph is specific to a Region. You can only use the API
to manage behavior graphs that belong to the Region that is associated
with the currently selected endpoint.

The administrator account for a behavior graph can use the Detective API
to do the following:
\itemize{
\item Enable and disable Detective. Enabling Detective creates a new
behavior graph.
\item View the list of member accounts in a behavior graph.
\item Add member accounts to a behavior graph.
\item Remove member accounts from a behavior graph.
\item Apply tags to a behavior graph.
}

The organization management account can use the Detective API to select
the delegated administrator for Detective.

The Detective administrator account for an organization can use the
Detective API to do the following:
\itemize{
\item Perform all of the functions of an administrator account.
\item Determine whether to automatically enable new organization accounts
as member accounts in the organization behavior graph.
}

An invited member account can use the Detective API to do the following:
\itemize{
\item View the list of behavior graphs that they are invited to.
\item Accept an invitation to contribute to a behavior graph.
\item Decline an invitation to contribute to a behavior graph.
\item Remove their account from a behavior graph.
}

All API actions are logged as CloudTrail events. See \href{https://docs.aws.amazon.com/detective/latest/adminguide/logging-using-cloudtrail.html}{Logging Detective API Calls with CloudTrail}.

We replaced the term "master account" with the term "administrator
account." An administrator account is used to centrally manage multiple
accounts. In the case of Detective, the administrator account manages
the accounts in their behavior graph.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- detective(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.security.identity:detective_accept_invitation]{accept_invitation} \tab Accepts an invitation for the member account to contribute data to a behavior graph\cr
\link[paws.security.identity:detective_batch_get_graph_member_datasources]{batch_get_graph_member_datasources} \tab Gets data source package information for the behavior graph\cr
\link[paws.security.identity:detective_batch_get_membership_datasources]{batch_get_membership_datasources} \tab Gets information on the data source package history for an account\cr
\link[paws.security.identity:detective_create_graph]{create_graph} \tab Creates a new behavior graph for the calling account, and sets that account as the administrator account\cr
\link[paws.security.identity:detective_create_members]{create_members} \tab CreateMembers is used to send invitations to accounts\cr
\link[paws.security.identity:detective_delete_graph]{delete_graph} \tab Disables the specified behavior graph and queues it to be deleted\cr
\link[paws.security.identity:detective_delete_members]{delete_members} \tab Removes the specified member accounts from the behavior graph\cr
\link[paws.security.identity:detective_describe_organization_configuration]{describe_organization_configuration} \tab Returns information about the configuration for the organization behavior graph\cr
\link[paws.security.identity:detective_disable_organization_admin_account]{disable_organization_admin_account} \tab Removes the Detective administrator account in the current Region\cr
\link[paws.security.identity:detective_disassociate_membership]{disassociate_membership} \tab Removes the member account from the specified behavior graph\cr
\link[paws.security.identity:detective_enable_organization_admin_account]{enable_organization_admin_account} \tab Designates the Detective administrator account for the organization in the current Region\cr
\link[paws.security.identity:detective_get_investigation]{get_investigation} \tab Returns the investigation results of an investigation for a behavior graph\cr
\link[paws.security.identity:detective_get_members]{get_members} \tab Returns the membership details for specified member accounts for a behavior graph\cr
\link[paws.security.identity:detective_list_datasource_packages]{list_datasource_packages} \tab Lists data source packages in the behavior graph\cr
\link[paws.security.identity:detective_list_graphs]{list_graphs} \tab Returns the list of behavior graphs that the calling account is an administrator account of\cr
\link[paws.security.identity:detective_list_indicators]{list_indicators} \tab Get the indicators from an investigation\cr
\link[paws.security.identity:detective_list_investigations]{list_investigations} \tab List all Investigations\cr
\link[paws.security.identity:detective_list_invitations]{list_invitations} \tab Retrieves the list of open and accepted behavior graph invitations for the member account\cr
\link[paws.security.identity:detective_list_members]{list_members} \tab Retrieves the list of member accounts for a behavior graph\cr
\link[paws.security.identity:detective_list_organization_admin_accounts]{list_organization_admin_accounts} \tab Returns information about the Detective administrator account for an organization\cr
\link[paws.security.identity:detective_list_tags_for_resource]{list_tags_for_resource} \tab Returns the tag values that are assigned to a behavior graph\cr
\link[paws.security.identity:detective_reject_invitation]{reject_invitation} \tab Rejects an invitation to contribute the account data to a behavior graph\cr
\link[paws.security.identity:detective_start_investigation]{start_investigation} \tab initiate an investigation on an entity in a graph\cr
\link[paws.security.identity:detective_start_monitoring_member]{start_monitoring_member} \tab Sends a request to enable data ingest for a member account that has a status of ACCEPTED_BUT_DISABLED\cr
\link[paws.security.identity:detective_tag_resource]{tag_resource} \tab Applies tag values to a behavior graph\cr
\link[paws.security.identity:detective_untag_resource]{untag_resource} \tab Removes tags from a behavior graph\cr
\link[paws.security.identity:detective_update_datasource_packages]{update_datasource_packages} \tab Starts a data source packages for the behavior graph\cr
\link[paws.security.identity:detective_update_investigation_state]{update_investigation_state} \tab Update the state of an investigation\cr
\link[paws.security.identity:detective_update_organization_configuration]{update_organization_configuration} \tab Updates the configuration for the Organizations integration in the current Region
}
}

\examples{
\dontrun{
svc <- detective()
svc$accept_invitation(
  Foo = 123
)
}

}
