% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{lookoutmetrics}
\alias{lookoutmetrics}
\title{Amazon Lookout for Metrics}
\usage{
lookoutmetrics(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}:} {\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
}}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}:} {Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}:} {\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
}}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
This is the \emph{Amazon Lookout for Metrics API Reference}. For an
introduction to the service with tutorials for getting started, visit
\href{https://docs.aws.amazon.com/lookoutmetrics/latest/dev/}{Amazon Lookout for Metrics Developer Guide}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- lookoutmetrics(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:lookoutmetrics_activate_anomaly_detector]{activate_anomaly_detector} \tab Activates an anomaly detector\cr
\link[paws.machine.learning:lookoutmetrics_back_test_anomaly_detector]{back_test_anomaly_detector} \tab Runs a backtest for anomaly detection for the specified resource\cr
\link[paws.machine.learning:lookoutmetrics_create_alert]{create_alert} \tab Creates an alert for an anomaly detector\cr
\link[paws.machine.learning:lookoutmetrics_create_anomaly_detector]{create_anomaly_detector} \tab Creates an anomaly detector\cr
\link[paws.machine.learning:lookoutmetrics_create_metric_set]{create_metric_set} \tab Creates a dataset\cr
\link[paws.machine.learning:lookoutmetrics_deactivate_anomaly_detector]{deactivate_anomaly_detector} \tab Deactivates an anomaly detector\cr
\link[paws.machine.learning:lookoutmetrics_delete_alert]{delete_alert} \tab Deletes an alert\cr
\link[paws.machine.learning:lookoutmetrics_delete_anomaly_detector]{delete_anomaly_detector} \tab Deletes a detector\cr
\link[paws.machine.learning:lookoutmetrics_describe_alert]{describe_alert} \tab Describes an alert\cr
\link[paws.machine.learning:lookoutmetrics_describe_anomaly_detection_executions]{describe_anomaly_detection_executions} \tab Returns information about the status of the specified anomaly detection jobs\cr
\link[paws.machine.learning:lookoutmetrics_describe_anomaly_detector]{describe_anomaly_detector} \tab Describes a detector\cr
\link[paws.machine.learning:lookoutmetrics_describe_metric_set]{describe_metric_set} \tab Describes a dataset\cr
\link[paws.machine.learning:lookoutmetrics_detect_metric_set_config]{detect_metric_set_config} \tab Detects an Amazon S3 dataset's file format, interval, and offset\cr
\link[paws.machine.learning:lookoutmetrics_get_anomaly_group]{get_anomaly_group} \tab Returns details about a group of anomalous metrics\cr
\link[paws.machine.learning:lookoutmetrics_get_data_quality_metrics]{get_data_quality_metrics} \tab Returns details about the requested data quality metrics\cr
\link[paws.machine.learning:lookoutmetrics_get_feedback]{get_feedback} \tab Get feedback for an anomaly group\cr
\link[paws.machine.learning:lookoutmetrics_get_sample_data]{get_sample_data} \tab Returns a selection of sample records from an Amazon S3 datasource\cr
\link[paws.machine.learning:lookoutmetrics_list_alerts]{list_alerts} \tab Lists the alerts attached to a detector\cr
\link[paws.machine.learning:lookoutmetrics_list_anomaly_detectors]{list_anomaly_detectors} \tab Lists the detectors in the current AWS Region\cr
\link[paws.machine.learning:lookoutmetrics_list_anomaly_group_related_metrics]{list_anomaly_group_related_metrics} \tab Returns a list of measures that are potential causes or effects of an anomaly group\cr
\link[paws.machine.learning:lookoutmetrics_list_anomaly_group_summaries]{list_anomaly_group_summaries} \tab Returns a list of anomaly groups\cr
\link[paws.machine.learning:lookoutmetrics_list_anomaly_group_time_series]{list_anomaly_group_time_series} \tab Gets a list of anomalous metrics for a measure in an anomaly group\cr
\link[paws.machine.learning:lookoutmetrics_list_metric_sets]{list_metric_sets} \tab Lists the datasets in the current AWS Region\cr
\link[paws.machine.learning:lookoutmetrics_list_tags_for_resource]{list_tags_for_resource} \tab Gets a list of tags for a detector, dataset, or alert\cr
\link[paws.machine.learning:lookoutmetrics_put_feedback]{put_feedback} \tab Add feedback for an anomalous metric\cr
\link[paws.machine.learning:lookoutmetrics_tag_resource]{tag_resource} \tab Adds tags to a detector, dataset, or alert\cr
\link[paws.machine.learning:lookoutmetrics_untag_resource]{untag_resource} \tab Removes tags from a detector, dataset, or alert\cr
\link[paws.machine.learning:lookoutmetrics_update_alert]{update_alert} \tab Make changes to an existing alert\cr
\link[paws.machine.learning:lookoutmetrics_update_anomaly_detector]{update_anomaly_detector} \tab Updates a detector\cr
\link[paws.machine.learning:lookoutmetrics_update_metric_set]{update_metric_set} \tab Updates a dataset
}
}

\examples{
\dontrun{
svc <- lookoutmetrics()
svc$activate_anomaly_detector(
  Foo = 123
)
}

}
