% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{costexplorer}
\alias{costexplorer}
\title{AWS Cost Explorer Service}
\usage{
costexplorer()
}
\description{
The Cost Explorer API enables you to programmatically query your cost
and usage data. You can query for aggregated data such as total monthly
costs or total daily usage. You can also query for granular data, such
as the number of daily write operations for Amazon DynamoDB database
tables in your production environment.

Service Endpoint

The Cost Explorer API provides the following endpoint:
\itemize{
\item \code{https://ce.us-east-1.amazonaws.com}
}

For information about costs associated with the Cost Explorer API, see
\href{https://aws.amazon.com/aws-cost-management/pricing/}{AWS Cost Management Pricing}.
}
\section{Operations}{

\tabular{ll}{
\link[=costexplorer_get_cost_and_usage]{get_cost_and_usage} \tab Retrieves cost and usage metrics for your account \cr
\link[=costexplorer_get_cost_forecast]{get_cost_forecast} \tab Retrieves a forecast for how much Amazon Web Services predicts that you will spend over the forecast time period that you select, based on your past costs\cr
\link[=costexplorer_get_dimension_values]{get_dimension_values} \tab Retrieves all available filter values for a specified filter over a period of time \cr
\link[=costexplorer_get_reservation_coverage]{get_reservation_coverage} \tab Retrieves the reservation coverage for your account \cr
\link[=costexplorer_get_reservation_purchase_recommendation]{get_reservation_purchase_recommendation} \tab Gets recommendations for which reservations to purchase \cr
\link[=costexplorer_get_reservation_utilization]{get_reservation_utilization} \tab Retrieves the reservation utilization for your account \cr
\link[=costexplorer_get_tags]{get_tags} \tab Queries for available tag keys and tag values for a specified period
}
}

\examples{
\donttest{svc <- costexplorer()
svc$get_cost_and_usage(
  Foo = 123
)}

}
