% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_lifecycle_configuration}
\alias{s3_get_bucket_lifecycle_configuration}
\title{Returns the lifecycle configuration information set on the bucket}
\usage{
s3_get_bucket_lifecycle_configuration(Bucket, ExpectedBucketOwner = NULL)
}
\arguments{
\item{Bucket}{[required] The name of the bucket for which to get the lifecycle information.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the account ID that you
provide does not match the actual owner of the bucket, the request fails
with the HTTP status code \verb{403 Forbidden} (access denied).

This parameter applies to general purpose buckets only. It is not
supported for directory bucket lifecycle configurations.}
}
\description{
Returns the lifecycle configuration information set on the bucket. For information about lifecycle configuration, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/object-lifecycle-mgmt.html}{Object Lifecycle Management}.

See \url{https://www.paws-r-sdk.com/docs/s3_get_bucket_lifecycle_configuration/} for full documentation.
}
\keyword{internal}
