% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_access_grants_location}
\alias{s3control_create_access_grants_location}
\title{The S3 data location that you would like to register in your S3 Access
Grants instance}
\usage{
s3control_create_access_grants_location(
  AccountId,
  LocationScope,
  IAMRoleArn,
  Tags = NULL
)
}
\arguments{
\item{AccountId}{[required] The ID of the Amazon Web Services account that is making this request.}

\item{LocationScope}{[required] The S3 path to the location that you are registering. The location scope
can be the default S3 location \verb{s3://}, the S3 path to a bucket
\verb{s3://<bucket>}, or the S3 path to a bucket and prefix
\verb{s3://<bucket>/<prefix>}. A prefix in S3 is a string of characters at
the beginning of an object key name used to organize the objects that
you store in your S3 buckets. For example, object key names that start
with the \verb{engineering/} prefix or object key names that start with the
\verb{marketing/campaigns/} prefix.}

\item{IAMRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role for the registered
location. S3 Access Grants assumes this role to manage access to the
registered location.}

\item{Tags}{The Amazon Web Services resource tags that you are adding to the S3
Access Grants location. Each tag is a label consisting of a user-defined
key and value. Tags can help you manage, identify, organize, search for,
and filter resources.}
}
\description{
The S3 data location that you would like to register in your S3 Access Grants instance. Your S3 data must be in the same Region as your S3 Access Grants instance. The location can be one of the following:

See \url{https://www.paws-r-sdk.com/docs/s3control_create_access_grants_location/} for full documentation.
}
\keyword{internal}
