% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_access_grants}
\alias{s3control_list_access_grants}
\title{Returns the list of access grants in your S3 Access Grants instance}
\usage{
s3control_list_access_grants(
  AccountId,
  NextToken = NULL,
  MaxResults = NULL,
  GranteeType = NULL,
  GranteeIdentifier = NULL,
  Permission = NULL,
  GrantScope = NULL,
  ApplicationArn = NULL
)
}
\arguments{
\item{AccountId}{[required] The ID of the Amazon Web Services account that is making this request.}

\item{NextToken}{A pagination token to request the next page of results. Pass this value
into a subsequent \verb{List Access Grants} request in order to retrieve the
next page of results.}

\item{MaxResults}{The maximum number of access grants that you would like returned in the
\verb{List Access Grants} response. If the results include the pagination
token \code{NextToken}, make another call using the \code{NextToken} to determine
if there are more results.}

\item{GranteeType}{The type of the grantee to which access has been granted. It can be one
of the following values:
\itemize{
\item \code{IAM} - An IAM user or role.
\item \code{DIRECTORY_USER} - Your corporate directory user. You can use this
option if you have added your corporate identity directory to IAM
Identity Center and associated the IAM Identity Center instance with
your S3 Access Grants instance.
\item \code{DIRECTORY_GROUP} - Your corporate directory group. You can use this
option if you have added your corporate identity directory to IAM
Identity Center and associated the IAM Identity Center instance with
your S3 Access Grants instance.
}}

\item{GranteeIdentifier}{The unique identifer of the \code{Grantee}. If the grantee type is \code{IAM}, the
identifier is the IAM Amazon Resource Name (ARN) of the user or role. If
the grantee type is a directory user or group, the identifier is 128-bit
universally unique identifier (UUID) in the format
\verb{a1b2c3d4-5678-90ab-cdef-EXAMPLE11111}. You can obtain this UUID from
your Amazon Web Services IAM Identity Center instance.}

\item{Permission}{The type of permission granted to your S3 data, which can be set to one
of the following values:
\itemize{
\item \code{READ} – Grant read-only access to the S3 data.
\item \code{WRITE} – Grant write-only access to the S3 data.
\item \code{READWRITE} – Grant both read and write access to the S3 data.
}}

\item{GrantScope}{The S3 path of the data to which you are granting access. It is the
result of appending the \code{Subprefix} to the location scope.}

\item{ApplicationArn}{The Amazon Resource Name (ARN) of an Amazon Web Services IAM Identity
Center application associated with your Identity Center instance. If the
grant includes an application ARN, the grantee can only access the S3
data through this application.}
}
\description{
Returns the list of access grants in your S3 Access Grants instance.

See \url{https://www.paws-r-sdk.com/docs/s3control_list_access_grants/} for full documentation.
}
\keyword{internal}
