# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include efs_service.R
NULL

#' Creates an EFS access point
#'
#' @description
#' Creates an EFS access point. An access point is an application-specific view into an EFS file system that applies an operating system user and group, and a file system path, to any file system request made through the access point. The operating system user and group override any identity information provided by the NFS client. The file system path is exposed as the access point's root directory. Applications using the access point can only access data in the application's own directory and any subdirectories. To learn more, see [Mounting a file system using EFS access points](https://docs.aws.amazon.com/efs/latest/ug/efs-access-points.html).
#'
#' See [https://www.paws-r-sdk.com/docs/efs_create_access_point/](https://www.paws-r-sdk.com/docs/efs_create_access_point/) for full documentation.
#'
#' @param ClientToken &#91;required&#93; A string of up to 64 ASCII characters that Amazon EFS uses to ensure
#' idempotent creation.
#' @param Tags Creates tags associated with the access point. Each tag is a key-value
#' pair, each key must be unique. For more information, see [Tagging Amazon
#' Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#' @param FileSystemId &#91;required&#93; The ID of the EFS file system that the access point provides access to.
#' @param PosixUser The operating system user and group applied to all file system requests
#' made using the access point.
#' @param RootDirectory Specifies the directory on the Amazon EFS file system that the access
#' point exposes as the root directory of your file system to NFS clients
#' using the access point. The clients using the access point can only
#' access the root directory and below. If the `RootDirectory` \> `Path`
#' specified does not exist, EFS creates it and applies the `CreationInfo`
#' settings when a client connects to an access point. When specifying a
#' `RootDirectory`, you must provide the `Path`, and the `CreationInfo`.
#' 
#' Amazon EFS creates a root directory only if you have provided the
#' CreationInfo: OwnUid, OwnGID, and permissions for the directory. If you
#' do not provide this information, Amazon EFS does not create the root
#' directory. If the root directory does not exist, attempts to mount using
#' the access point will fail.
#'
#' @keywords internal
#'
#' @rdname efs_create_access_point
efs_create_access_point <- function(ClientToken, Tags = NULL, FileSystemId, PosixUser = NULL, RootDirectory = NULL) {
  op <- new_operation(
    name = "CreateAccessPoint",
    http_method = "POST",
    http_path = "/2015-02-01/access-points",
    paginator = list()
  )
  input <- .efs$create_access_point_input(ClientToken = ClientToken, Tags = Tags, FileSystemId = FileSystemId, PosixUser = PosixUser, RootDirectory = RootDirectory)
  output <- .efs$create_access_point_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_access_point <- efs_create_access_point

#' Creates a new, empty file system
#'
#' @description
#' Creates a new, empty file system. The operation requires a creation token in the request that Amazon EFS uses to ensure idempotent creation (calling the operation with same creation token has no effect). If a file system does not currently exist that is owned by the caller's Amazon Web Services account with the specified creation token, this operation does the following:
#'
#' See [https://www.paws-r-sdk.com/docs/efs_create_file_system/](https://www.paws-r-sdk.com/docs/efs_create_file_system/) for full documentation.
#'
#' @param CreationToken &#91;required&#93; A string of up to 64 ASCII characters. Amazon EFS uses this to ensure
#' idempotent creation.
#' @param PerformanceMode The performance mode of the file system. We recommend `generalPurpose`
#' performance mode for most file systems. File systems using the `maxIO`
#' performance mode can scale to higher levels of aggregate throughput and
#' operations per second with a tradeoff of slightly higher latencies for
#' most file operations. The performance mode can't be changed after the
#' file system has been created.
#' 
#' The `maxIO` mode is not supported on file systems using One Zone storage
#' classes.
#' @param Encrypted A Boolean value that, if true, creates an encrypted file system. When
#' creating an encrypted file system, you have the option of specifying an
#' existing Key Management Service key (KMS key). If you don't specify a
#' KMS key, then the default KMS key for Amazon EFS,
#' `/aws/elasticfilesystem`, is used to protect the encrypted file system.
#' @param KmsKeyId The ID of the KMS key that you want to use to protect the encrypted file
#' system. This parameter is required only if you want to use a non-default
#' KMS key. If this parameter is not specified, the default KMS key for
#' Amazon EFS is used. You can specify a KMS key ID using the following
#' formats:
#' 
#' -   Key ID - A unique identifier of the key, for example
#'     `1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' -   ARN - An Amazon Resource Name (ARN) for the key, for example
#'     `arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`.
#' 
#' -   Key alias - A previously created display name for a key, for example
#'     `alias/projectKey1`.
#' 
#' -   Key alias ARN - An ARN for a key alias, for example
#'     `arn:aws:kms:us-west-2:444455556666:alias/projectKey1`.
#' 
#' If you use `KmsKeyId`, you must set the
#' CreateFileSystemRequest$Encrypted parameter to true.
#' 
#' EFS accepts only symmetric KMS keys. You cannot use asymmetric KMS keys
#' with Amazon EFS file systems.
#' @param ThroughputMode Specifies the throughput mode for the file system. The mode can be
#' `bursting`, `provisioned`, or `elastic`. If you set `ThroughputMode` to
#' `provisioned`, you must also set a value for
#' `ProvisionedThroughputInMibps`. After you create the file system, you
#' can decrease your file system's throughput in Provisioned Throughput
#' mode or change between the throughput modes, with certain time
#' restrictions. For more information, see [Specifying throughput with
#' provisioned
#' mode](https://docs.aws.amazon.com/efs/latest/ug/performance.html#provisioned-throughput)
#' in the *Amazon EFS User Guide*.
#' 
#' Default is `bursting`.
#' @param ProvisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for a file
#' system that you're creating. Valid values are 1-1024. Required if
#' `ThroughputMode` is set to `provisioned`. The upper limit for throughput
#' is 1024 MiB/s. To increase this limit, contact Amazon Web Services
#' Support. For more information, see [Amazon EFS quotas that you can
#' increase](https://docs.aws.amazon.com/efs/latest/ug/limits.html#soft-limits)
#' in the *Amazon EFS User Guide*.
#' @param AvailabilityZoneName Used to create a file system that uses One Zone storage classes. It
#' specifies the Amazon Web Services Availability Zone in which to create
#' the file system. Use the format `us-east-1a` to specify the Availability
#' Zone. For more information about One Zone storage classes, see [Using
#' EFS storage
#' classes](https://docs.aws.amazon.com/efs/latest/ug/storage-classes.html)
#' in the *Amazon EFS User Guide*.
#' 
#' One Zone storage classes are not available in all Availability Zones in
#' Amazon Web Services Regions where Amazon EFS is available.
#' @param Backup Specifies whether automatic backups are enabled on the file system that
#' you are creating. Set the value to `true` to enable automatic backups.
#' If you are creating a file system that uses One Zone storage classes,
#' automatic backups are enabled by default. For more information, see
#' [Automatic
#' backups](https://docs.aws.amazon.com/efs/latest/ug/awsbackup.html#automatic-backups)
#' in the *Amazon EFS User Guide*.
#' 
#' Default is `false`. However, if you specify an `AvailabilityZoneName`,
#' the default is `true`.
#' 
#' Backup is not available in all Amazon Web Services Regions where Amazon
#' EFS is available.
#' @param Tags Use to create one or more tags associated with the file system. Each tag
#' is a user-defined key-value pair. Name your file system on creation by
#' including a `"Key":"Name","Value":"{value}"` key-value pair. Each key
#' must be unique. For more information, see [Tagging Amazon Web Services
#' resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' in the *Amazon Web Services General Reference Guide*.
#'
#' @keywords internal
#'
#' @rdname efs_create_file_system
efs_create_file_system <- function(CreationToken, PerformanceMode = NULL, Encrypted = NULL, KmsKeyId = NULL, ThroughputMode = NULL, ProvisionedThroughputInMibps = NULL, AvailabilityZoneName = NULL, Backup = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateFileSystem",
    http_method = "POST",
    http_path = "/2015-02-01/file-systems",
    paginator = list()
  )
  input <- .efs$create_file_system_input(CreationToken = CreationToken, PerformanceMode = PerformanceMode, Encrypted = Encrypted, KmsKeyId = KmsKeyId, ThroughputMode = ThroughputMode, ProvisionedThroughputInMibps = ProvisionedThroughputInMibps, AvailabilityZoneName = AvailabilityZoneName, Backup = Backup, Tags = Tags)
  output <- .efs$create_file_system_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_file_system <- efs_create_file_system

#' Creates a mount target for a file system
#'
#' @description
#' Creates a mount target for a file system. You can then mount the file system on EC2 instances by using the mount target.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_create_mount_target/](https://www.paws-r-sdk.com/docs/efs_create_mount_target/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system for which to create the mount target.
#' @param SubnetId &#91;required&#93; The ID of the subnet to add the mount target in. For file systems that
#' use One Zone storage classes, use the subnet that is associated with the
#' file system's Availability Zone.
#' @param IpAddress Valid IPv4 address within the address range of the specified subnet.
#' @param SecurityGroups Up to five VPC security group IDs, of the form `sg-xxxxxxxx`. These must
#' be for the same VPC as subnet specified.
#'
#' @keywords internal
#'
#' @rdname efs_create_mount_target
efs_create_mount_target <- function(FileSystemId, SubnetId, IpAddress = NULL, SecurityGroups = NULL) {
  op <- new_operation(
    name = "CreateMountTarget",
    http_method = "POST",
    http_path = "/2015-02-01/mount-targets",
    paginator = list()
  )
  input <- .efs$create_mount_target_input(FileSystemId = FileSystemId, SubnetId = SubnetId, IpAddress = IpAddress, SecurityGroups = SecurityGroups)
  output <- .efs$create_mount_target_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_mount_target <- efs_create_mount_target

#' Creates a replication configuration that replicates an existing EFS file
#' system to a new, read-only file system
#'
#' @description
#' Creates a replication configuration that replicates an existing EFS file system to a new, read-only file system. For more information, see [Amazon EFS replication](https://docs.aws.amazon.com/efs/latest/ug/efs-replication.html) in the *Amazon EFS User Guide*. The replication configuration specifies the following:
#'
#' See [https://www.paws-r-sdk.com/docs/efs_create_replication_configuration/](https://www.paws-r-sdk.com/docs/efs_create_replication_configuration/) for full documentation.
#'
#' @param SourceFileSystemId &#91;required&#93; Specifies the Amazon EFS file system that you want to replicate. This
#' file system cannot already be a source or destination file system in
#' another replication configuration.
#' @param Destinations &#91;required&#93; An array of destination configuration objects. Only one destination
#' configuration object is supported.
#'
#' @keywords internal
#'
#' @rdname efs_create_replication_configuration
efs_create_replication_configuration <- function(SourceFileSystemId, Destinations) {
  op <- new_operation(
    name = "CreateReplicationConfiguration",
    http_method = "POST",
    http_path = "/2015-02-01/file-systems/{SourceFileSystemId}/replication-configuration",
    paginator = list()
  )
  input <- .efs$create_replication_configuration_input(SourceFileSystemId = SourceFileSystemId, Destinations = Destinations)
  output <- .efs$create_replication_configuration_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_replication_configuration <- efs_create_replication_configuration

#' DEPRECATED - CreateTags is deprecated and not maintained
#'
#' @description
#' DEPRECATED - [`create_tags`][efs_create_tags] is deprecated and not maintained. To create tags for EFS resources, use the API action.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_create_tags/](https://www.paws-r-sdk.com/docs/efs_create_tags/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tags you want to modify (String). This
#' operation modifies the tags only, not the file system.
#' @param Tags &#91;required&#93; An array of `Tag` objects to add. Each `Tag` object is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname efs_create_tags
efs_create_tags <- function(FileSystemId, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/2015-02-01/create-tags/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$create_tags_input(FileSystemId = FileSystemId, Tags = Tags)
  output <- .efs$create_tags_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$create_tags <- efs_create_tags

#' Deletes the specified access point
#'
#' @description
#' Deletes the specified access point. After deletion is complete, new clients can no longer connect to the access points. Clients connected to the access point at the time of deletion will continue to function until they terminate their connection.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_access_point/](https://www.paws-r-sdk.com/docs/efs_delete_access_point/) for full documentation.
#'
#' @param AccessPointId &#91;required&#93; The ID of the access point that you want to delete.
#'
#' @keywords internal
#'
#' @rdname efs_delete_access_point
efs_delete_access_point <- function(AccessPointId) {
  op <- new_operation(
    name = "DeleteAccessPoint",
    http_method = "DELETE",
    http_path = "/2015-02-01/access-points/{AccessPointId}",
    paginator = list()
  )
  input <- .efs$delete_access_point_input(AccessPointId = AccessPointId)
  output <- .efs$delete_access_point_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_access_point <- efs_delete_access_point

#' Deletes a file system, permanently severing access to its contents
#'
#' @description
#' Deletes a file system, permanently severing access to its contents. Upon return, the file system no longer exists and you can't access any contents of the deleted file system.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_file_system/](https://www.paws-r-sdk.com/docs/efs_delete_file_system/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system you want to delete.
#'
#' @keywords internal
#'
#' @rdname efs_delete_file_system
efs_delete_file_system <- function(FileSystemId) {
  op <- new_operation(
    name = "DeleteFileSystem",
    http_method = "DELETE",
    http_path = "/2015-02-01/file-systems/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$delete_file_system_input(FileSystemId = FileSystemId)
  output <- .efs$delete_file_system_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_file_system <- efs_delete_file_system

#' Deletes the FileSystemPolicy for the specified file system
#'
#' @description
#' Deletes the `FileSystemPolicy` for the specified file system. The default `FileSystemPolicy` goes into effect once the existing policy is deleted. For more information about the default file system policy, see [Using Resource-based Policies with EFS](https://docs.aws.amazon.com/efs/latest/ug/).
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_file_system_policy/](https://www.paws-r-sdk.com/docs/efs_delete_file_system_policy/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; Specifies the EFS file system for which to delete the
#' `FileSystemPolicy`.
#'
#' @keywords internal
#'
#' @rdname efs_delete_file_system_policy
efs_delete_file_system_policy <- function(FileSystemId) {
  op <- new_operation(
    name = "DeleteFileSystemPolicy",
    http_method = "DELETE",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/policy",
    paginator = list()
  )
  input <- .efs$delete_file_system_policy_input(FileSystemId = FileSystemId)
  output <- .efs$delete_file_system_policy_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_file_system_policy <- efs_delete_file_system_policy

#' Deletes the specified mount target
#'
#' @description
#' Deletes the specified mount target.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_mount_target/](https://www.paws-r-sdk.com/docs/efs_delete_mount_target/) for full documentation.
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target to delete (String).
#'
#' @keywords internal
#'
#' @rdname efs_delete_mount_target
efs_delete_mount_target <- function(MountTargetId) {
  op <- new_operation(
    name = "DeleteMountTarget",
    http_method = "DELETE",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}",
    paginator = list()
  )
  input <- .efs$delete_mount_target_input(MountTargetId = MountTargetId)
  output <- .efs$delete_mount_target_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_mount_target <- efs_delete_mount_target

#' Deletes an existing replication configuration
#'
#' @description
#' Deletes an existing replication configuration. To delete a replication configuration, you must make the request from the Amazon Web Services Region in which the destination file system is located. Deleting a replication configuration ends the replication process. After a replication configuration is deleted, the destination file system is no longer read-only. You can write to the destination file system after its status becomes `Writeable`.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_replication_configuration/](https://www.paws-r-sdk.com/docs/efs_delete_replication_configuration/) for full documentation.
#'
#' @param SourceFileSystemId &#91;required&#93; The ID of the source file system in the replication configuration.
#'
#' @keywords internal
#'
#' @rdname efs_delete_replication_configuration
efs_delete_replication_configuration <- function(SourceFileSystemId) {
  op <- new_operation(
    name = "DeleteReplicationConfiguration",
    http_method = "DELETE",
    http_path = "/2015-02-01/file-systems/{SourceFileSystemId}/replication-configuration",
    paginator = list()
  )
  input <- .efs$delete_replication_configuration_input(SourceFileSystemId = SourceFileSystemId)
  output <- .efs$delete_replication_configuration_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_replication_configuration <- efs_delete_replication_configuration

#' DEPRECATED - DeleteTags is deprecated and not maintained
#'
#' @description
#' DEPRECATED - [`delete_tags`][efs_delete_tags] is deprecated and not maintained. To remove tags from EFS resources, use the API action.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_delete_tags/](https://www.paws-r-sdk.com/docs/efs_delete_tags/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tags you want to delete (String).
#' @param TagKeys &#91;required&#93; A list of tag keys to delete.
#'
#' @keywords internal
#'
#' @rdname efs_delete_tags
efs_delete_tags <- function(FileSystemId, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/2015-02-01/delete-tags/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$delete_tags_input(FileSystemId = FileSystemId, TagKeys = TagKeys)
  output <- .efs$delete_tags_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$delete_tags <- efs_delete_tags

#' Returns the description of a specific Amazon EFS access point if the
#' AccessPointId is provided
#'
#' @description
#' Returns the description of a specific Amazon EFS access point if the `AccessPointId` is provided. If you provide an EFS `FileSystemId`, it returns descriptions of all access points for that file system. You can provide either an `AccessPointId` or a `FileSystemId` in the request, but not both.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_access_points/](https://www.paws-r-sdk.com/docs/efs_describe_access_points/) for full documentation.
#'
#' @param MaxResults (Optional) When retrieving all access points for a file system, you can
#' optionally specify the `MaxItems` parameter to limit the number of
#' objects returned in a response. The default value is 100.
#' @param NextToken `NextToken` is present if the response is paginated. You can use
#' `NextMarker` in the subsequent request to fetch the next page of access
#' point descriptions.
#' @param AccessPointId (Optional) Specifies an EFS access point to describe in the response;
#' mutually exclusive with `FileSystemId`.
#' @param FileSystemId (Optional) If you provide a `FileSystemId`, EFS returns all access
#' points for that file system; mutually exclusive with `AccessPointId`.
#'
#' @keywords internal
#'
#' @rdname efs_describe_access_points
efs_describe_access_points <- function(MaxResults = NULL, NextToken = NULL, AccessPointId = NULL, FileSystemId = NULL) {
  op <- new_operation(
    name = "DescribeAccessPoints",
    http_method = "GET",
    http_path = "/2015-02-01/access-points",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .efs$describe_access_points_input(MaxResults = MaxResults, NextToken = NextToken, AccessPointId = AccessPointId, FileSystemId = FileSystemId)
  output <- .efs$describe_access_points_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_access_points <- efs_describe_access_points

#' Returns the account preferences settings for the Amazon Web Services
#' account associated with the user making the request, in the current
#' Amazon Web Services Region
#'
#' @description
#' Returns the account preferences settings for the Amazon Web Services account associated with the user making the request, in the current Amazon Web Services Region. For more information, see [Managing Amazon EFS resource IDs](https://docs.aws.amazon.com/efs/latest/ug/).
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_account_preferences/](https://www.paws-r-sdk.com/docs/efs_describe_account_preferences/) for full documentation.
#'
#' @param NextToken (Optional) You can use `NextToken` in a subsequent request to fetch the
#' next page of Amazon Web Services account preferences if the response
#' payload was paginated.
#' @param MaxResults (Optional) When retrieving account preferences, you can optionally
#' specify the `MaxItems` parameter to limit the number of objects returned
#' in a response. The default value is 100.
#'
#' @keywords internal
#'
#' @rdname efs_describe_account_preferences
efs_describe_account_preferences <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeAccountPreferences",
    http_method = "GET",
    http_path = "/2015-02-01/account-preferences",
    paginator = list()
  )
  input <- .efs$describe_account_preferences_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .efs$describe_account_preferences_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_account_preferences <- efs_describe_account_preferences

#' Returns the backup policy for the specified EFS file system
#'
#' @description
#' Returns the backup policy for the specified EFS file system.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_backup_policy/](https://www.paws-r-sdk.com/docs/efs_describe_backup_policy/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; Specifies which EFS file system to retrieve the `BackupPolicy` for.
#'
#' @keywords internal
#'
#' @rdname efs_describe_backup_policy
efs_describe_backup_policy <- function(FileSystemId) {
  op <- new_operation(
    name = "DescribeBackupPolicy",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
    paginator = list()
  )
  input <- .efs$describe_backup_policy_input(FileSystemId = FileSystemId)
  output <- .efs$describe_backup_policy_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_backup_policy <- efs_describe_backup_policy

#' Returns the FileSystemPolicy for the specified EFS file system
#'
#' @description
#' Returns the `FileSystemPolicy` for the specified EFS file system.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_file_system_policy/](https://www.paws-r-sdk.com/docs/efs_describe_file_system_policy/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; Specifies which EFS file system to retrieve the `FileSystemPolicy` for.
#'
#' @keywords internal
#'
#' @rdname efs_describe_file_system_policy
efs_describe_file_system_policy <- function(FileSystemId) {
  op <- new_operation(
    name = "DescribeFileSystemPolicy",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/policy",
    paginator = list()
  )
  input <- .efs$describe_file_system_policy_input(FileSystemId = FileSystemId)
  output <- .efs$describe_file_system_policy_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_file_system_policy <- efs_describe_file_system_policy

#' Returns the description of a specific Amazon EFS file system if either
#' the file system CreationToken or the FileSystemId is provided
#'
#' @description
#' Returns the description of a specific Amazon EFS file system if either the file system `CreationToken` or the `FileSystemId` is provided. Otherwise, it returns descriptions of all file systems owned by the caller's Amazon Web Services account in the Amazon Web Services Region of the endpoint that you're calling.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_file_systems/](https://www.paws-r-sdk.com/docs/efs_describe_file_systems/) for full documentation.
#'
#' @param MaxItems (Optional) Specifies the maximum number of file systems to return in the
#' response (integer). This number is automatically set to 100. The
#' response is paginated at 100 per page if you have more than 100 file
#' systems.
#' @param Marker (Optional) Opaque pagination token returned from a previous
#' [`describe_file_systems`][efs_describe_file_systems] operation (String).
#' If present, specifies to continue the list from where the returning call
#' had left off.
#' @param CreationToken (Optional) Restricts the list to the file system with this creation
#' token (String). You specify a creation token when you create an Amazon
#' EFS file system.
#' @param FileSystemId (Optional) ID of the file system whose description you want to retrieve
#' (String).
#'
#' @keywords internal
#'
#' @rdname efs_describe_file_systems
efs_describe_file_systems <- function(MaxItems = NULL, Marker = NULL, CreationToken = NULL, FileSystemId = NULL) {
  op <- new_operation(
    name = "DescribeFileSystems",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems",
    paginator = list(input_token = "Marker", output_token = "NextMarker", limit_key = "MaxItems")
  )
  input <- .efs$describe_file_systems_input(MaxItems = MaxItems, Marker = Marker, CreationToken = CreationToken, FileSystemId = FileSystemId)
  output <- .efs$describe_file_systems_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_file_systems <- efs_describe_file_systems

#' Returns the current LifecycleConfiguration object for the specified
#' Amazon EFS file system
#'
#' @description
#' Returns the current `LifecycleConfiguration` object for the specified Amazon EFS file system. EFS lifecycle management uses the `LifecycleConfiguration` object to identify which files to move to the EFS Infrequent Access (IA) storage class. For a file system without a `LifecycleConfiguration` object, the call returns an empty array in the response.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_lifecycle_configuration/](https://www.paws-r-sdk.com/docs/efs_describe_lifecycle_configuration/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system whose `LifecycleConfiguration` object you want
#' to retrieve (String).
#'
#' @keywords internal
#'
#' @rdname efs_describe_lifecycle_configuration
efs_describe_lifecycle_configuration <- function(FileSystemId) {
  op <- new_operation(
    name = "DescribeLifecycleConfiguration",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
    paginator = list()
  )
  input <- .efs$describe_lifecycle_configuration_input(FileSystemId = FileSystemId)
  output <- .efs$describe_lifecycle_configuration_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_lifecycle_configuration <- efs_describe_lifecycle_configuration

#' Returns the security groups currently in effect for a mount target
#'
#' @description
#' Returns the security groups currently in effect for a mount target. This operation requires that the network interface of the mount target has been created and the lifecycle state of the mount target is not `deleted`.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_mount_target_security_groups/](https://www.paws-r-sdk.com/docs/efs_describe_mount_target_security_groups/) for full documentation.
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target whose security groups you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname efs_describe_mount_target_security_groups
efs_describe_mount_target_security_groups <- function(MountTargetId) {
  op <- new_operation(
    name = "DescribeMountTargetSecurityGroups",
    http_method = "GET",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
    paginator = list()
  )
  input <- .efs$describe_mount_target_security_groups_input(MountTargetId = MountTargetId)
  output <- .efs$describe_mount_target_security_groups_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_mount_target_security_groups <- efs_describe_mount_target_security_groups

#' Returns the descriptions of all the current mount targets, or a specific
#' mount target, for a file system
#'
#' @description
#' Returns the descriptions of all the current mount targets, or a specific mount target, for a file system. When requesting all of the current mount targets, the order of mount targets returned in the response is unspecified.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_mount_targets/](https://www.paws-r-sdk.com/docs/efs_describe_mount_targets/) for full documentation.
#'
#' @param MaxItems (Optional) Maximum number of mount targets to return in the response.
#' Currently, this number is automatically set to 10, and other values are
#' ignored. The response is paginated at 100 per page if you have more than
#' 100 mount targets.
#' @param Marker (Optional) Opaque pagination token returned from a previous
#' [`describe_mount_targets`][efs_describe_mount_targets] operation
#' (String). If present, it specifies to continue the list from where the
#' previous returning call left off.
#' @param FileSystemId (Optional) ID of the file system whose mount targets you want to list
#' (String). It must be included in your request if an `AccessPointId` or
#' `MountTargetId` is not included. Accepts either a file system ID or ARN
#' as input.
#' @param MountTargetId (Optional) ID of the mount target that you want to have described
#' (String). It must be included in your request if `FileSystemId` is not
#' included. Accepts either a mount target ID or ARN as input.
#' @param AccessPointId (Optional) The ID of the access point whose mount targets that you want
#' to list. It must be included in your request if a `FileSystemId` or
#' `MountTargetId` is not included in your request. Accepts either an
#' access point ID or ARN as input.
#'
#' @keywords internal
#'
#' @rdname efs_describe_mount_targets
efs_describe_mount_targets <- function(MaxItems = NULL, Marker = NULL, FileSystemId = NULL, MountTargetId = NULL, AccessPointId = NULL) {
  op <- new_operation(
    name = "DescribeMountTargets",
    http_method = "GET",
    http_path = "/2015-02-01/mount-targets",
    paginator = list()
  )
  input <- .efs$describe_mount_targets_input(MaxItems = MaxItems, Marker = Marker, FileSystemId = FileSystemId, MountTargetId = MountTargetId, AccessPointId = AccessPointId)
  output <- .efs$describe_mount_targets_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_mount_targets <- efs_describe_mount_targets

#' Retrieves the replication configuration for a specific file system
#'
#' @description
#' Retrieves the replication configuration for a specific file system. If a file system is not specified, all of the replication configurations for the Amazon Web Services account in an Amazon Web Services Region are retrieved.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_replication_configurations/](https://www.paws-r-sdk.com/docs/efs_describe_replication_configurations/) for full documentation.
#'
#' @param FileSystemId You can retrieve the replication configuration for a specific file
#' system by providing its file system ID.
#' @param NextToken `NextToken` is present if the response is paginated. You can use
#' `NextToken` in a subsequent request to fetch the next page of output.
#' @param MaxResults (Optional) To limit the number of objects returned in a response, you
#' can specify the `MaxItems` parameter. The default value is 100.
#'
#' @keywords internal
#'
#' @rdname efs_describe_replication_configurations
efs_describe_replication_configurations <- function(FileSystemId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeReplicationConfigurations",
    http_method = "GET",
    http_path = "/2015-02-01/file-systems/replication-configurations",
    paginator = list()
  )
  input <- .efs$describe_replication_configurations_input(FileSystemId = FileSystemId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .efs$describe_replication_configurations_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_replication_configurations <- efs_describe_replication_configurations

#' DEPRECATED - The DescribeTags action is deprecated and not maintained
#'
#' @description
#' DEPRECATED - The [`describe_tags`][efs_describe_tags] action is deprecated and not maintained. To view tags associated with EFS resources, use the [`list_tags_for_resource`][efs_list_tags_for_resource] API action.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_describe_tags/](https://www.paws-r-sdk.com/docs/efs_describe_tags/) for full documentation.
#'
#' @param MaxItems (Optional) The maximum number of file system tags to return in the
#' response. Currently, this number is automatically set to 100, and other
#' values are ignored. The response is paginated at 100 per page if you
#' have more than 100 tags.
#' @param Marker (Optional) An opaque pagination token returned from a previous
#' [`describe_tags`][efs_describe_tags] operation (String). If present, it
#' specifies to continue the list from where the previous call left off.
#' @param FileSystemId &#91;required&#93; The ID of the file system whose tag set you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname efs_describe_tags
efs_describe_tags <- function(MaxItems = NULL, Marker = NULL, FileSystemId) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "GET",
    http_path = "/2015-02-01/tags/{FileSystemId}/",
    paginator = list(input_token = "Marker", output_token = "NextMarker", limit_key = "MaxItems")
  )
  input <- .efs$describe_tags_input(MaxItems = MaxItems, Marker = Marker, FileSystemId = FileSystemId)
  output <- .efs$describe_tags_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$describe_tags <- efs_describe_tags

#' Lists all tags for a top-level EFS resource
#'
#' @description
#' Lists all tags for a top-level EFS resource. You must provide the ID of the resource that you want to retrieve the tags for.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/efs_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the EFS resource you want to retrieve tags for. You can
#' retrieve tags for EFS file systems and access points using this API
#' endpoint.
#' @param MaxResults (Optional) Specifies the maximum number of tag objects to return in the
#' response. The default value is 100.
#' @param NextToken (Optional) You can use `NextToken` in a subsequent request to fetch the
#' next page of access point descriptions if the response payload was
#' paginated.
#'
#' @keywords internal
#'
#' @rdname efs_list_tags_for_resource
efs_list_tags_for_resource <- function(ResourceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2015-02-01/resource-tags/{ResourceId}",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .efs$list_tags_for_resource_input(ResourceId = ResourceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .efs$list_tags_for_resource_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$list_tags_for_resource <- efs_list_tags_for_resource

#' Modifies the set of security groups in effect for a mount target
#'
#' @description
#' Modifies the set of security groups in effect for a mount target.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_modify_mount_target_security_groups/](https://www.paws-r-sdk.com/docs/efs_modify_mount_target_security_groups/) for full documentation.
#'
#' @param MountTargetId &#91;required&#93; The ID of the mount target whose security groups you want to modify.
#' @param SecurityGroups An array of up to five VPC security group IDs.
#'
#' @keywords internal
#'
#' @rdname efs_modify_mount_target_security_groups
efs_modify_mount_target_security_groups <- function(MountTargetId, SecurityGroups = NULL) {
  op <- new_operation(
    name = "ModifyMountTargetSecurityGroups",
    http_method = "PUT",
    http_path = "/2015-02-01/mount-targets/{MountTargetId}/security-groups",
    paginator = list()
  )
  input <- .efs$modify_mount_target_security_groups_input(MountTargetId = MountTargetId, SecurityGroups = SecurityGroups)
  output <- .efs$modify_mount_target_security_groups_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$modify_mount_target_security_groups <- efs_modify_mount_target_security_groups

#' Use this operation to set the account preference in the current Amazon
#' Web Services Region to use long 17 character (63 bit) or short 8
#' character (32 bit) resource IDs for new EFS file system and mount target
#' resources
#'
#' @description
#' Use this operation to set the account preference in the current Amazon Web Services Region to use long 17 character (63 bit) or short 8 character (32 bit) resource IDs for new EFS file system and mount target resources. All existing resource IDs are not affected by any changes you make. You can set the ID preference during the opt-in period as EFS transitions to long resource IDs. For more information, see [Managing Amazon EFS resource IDs](https://docs.aws.amazon.com/efs/latest/ug/).
#'
#' See [https://www.paws-r-sdk.com/docs/efs_put_account_preferences/](https://www.paws-r-sdk.com/docs/efs_put_account_preferences/) for full documentation.
#'
#' @param ResourceIdType &#91;required&#93; Specifies the EFS resource ID preference to set for the user's Amazon
#' Web Services account, in the current Amazon Web Services Region, either
#' `LONG_ID` (17 characters), or `SHORT_ID` (8 characters).
#' 
#' Starting in October, 2021, you will receive an error when setting the
#' account preference to `SHORT_ID`. Contact Amazon Web Services support if
#' you receive an error and must use short IDs for file system and mount
#' target resources.
#'
#' @keywords internal
#'
#' @rdname efs_put_account_preferences
efs_put_account_preferences <- function(ResourceIdType) {
  op <- new_operation(
    name = "PutAccountPreferences",
    http_method = "PUT",
    http_path = "/2015-02-01/account-preferences",
    paginator = list()
  )
  input <- .efs$put_account_preferences_input(ResourceIdType = ResourceIdType)
  output <- .efs$put_account_preferences_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$put_account_preferences <- efs_put_account_preferences

#' Updates the file system's backup policy
#'
#' @description
#' Updates the file system's backup policy. Use this action to start or stop automatic backups of the file system.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_put_backup_policy/](https://www.paws-r-sdk.com/docs/efs_put_backup_policy/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; Specifies which EFS file system to update the backup policy for.
#' @param BackupPolicy &#91;required&#93; The backup policy included in the
#' [`put_backup_policy`][efs_put_backup_policy] request.
#'
#' @keywords internal
#'
#' @rdname efs_put_backup_policy
efs_put_backup_policy <- function(FileSystemId, BackupPolicy) {
  op <- new_operation(
    name = "PutBackupPolicy",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/backup-policy",
    paginator = list()
  )
  input <- .efs$put_backup_policy_input(FileSystemId = FileSystemId, BackupPolicy = BackupPolicy)
  output <- .efs$put_backup_policy_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$put_backup_policy <- efs_put_backup_policy

#' Applies an Amazon EFS FileSystemPolicy to an Amazon EFS file system
#'
#' @description
#' Applies an Amazon EFS `FileSystemPolicy` to an Amazon EFS file system. A file system policy is an IAM resource-based policy and can contain multiple policy statements. A file system always has exactly one file system policy, which can be the default policy or an explicit policy set or updated using this API operation. EFS file system policies have a 20,000 character limit. When an explicit policy is set, it overrides the default policy. For more information about the default file system policy, see [Default EFS File System Policy](https://docs.aws.amazon.com/efs/latest/ug/iam-access-control-nfs-efs.html#default-filesystempolicy).
#'
#' See [https://www.paws-r-sdk.com/docs/efs_put_file_system_policy/](https://www.paws-r-sdk.com/docs/efs_put_file_system_policy/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the EFS file system that you want to create or update the
#' `FileSystemPolicy` for.
#' @param Policy &#91;required&#93; The `FileSystemPolicy` that you're creating. Accepts a JSON formatted
#' policy definition. EFS file system policies have a 20,000 character
#' limit. To find out more about the elements that make up a file system
#' policy, see [EFS Resource-based
#' Policies](https://docs.aws.amazon.com/efs/latest/ug/#access-control-manage-access-intro-resource-policies).
#' @param BypassPolicyLockoutSafetyCheck (Optional) A boolean that specifies whether or not to bypass the
#' `FileSystemPolicy` lockout safety check. The lockout safety check
#' determines whether the policy in the request will lock out, or prevent,
#' the IAM principal that is making the request from making future
#' [`put_file_system_policy`][efs_put_file_system_policy] requests on this
#' file system. Set `BypassPolicyLockoutSafetyCheck` to `True` only when
#' you intend to prevent the IAM principal that is making the request from
#' making subsequent [`put_file_system_policy`][efs_put_file_system_policy]
#' requests on this file system. The default value is `False`.
#'
#' @keywords internal
#'
#' @rdname efs_put_file_system_policy
efs_put_file_system_policy <- function(FileSystemId, Policy, BypassPolicyLockoutSafetyCheck = NULL) {
  op <- new_operation(
    name = "PutFileSystemPolicy",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/policy",
    paginator = list()
  )
  input <- .efs$put_file_system_policy_input(FileSystemId = FileSystemId, Policy = Policy, BypassPolicyLockoutSafetyCheck = BypassPolicyLockoutSafetyCheck)
  output <- .efs$put_file_system_policy_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$put_file_system_policy <- efs_put_file_system_policy

#' Use this action to manage EFS lifecycle management and EFS
#' Intelligent-Tiering
#'
#' @description
#' Use this action to manage EFS lifecycle management and EFS Intelligent-Tiering. A `LifecycleConfiguration` consists of one or more `LifecyclePolicy` objects that define the following:
#'
#' See [https://www.paws-r-sdk.com/docs/efs_put_lifecycle_configuration/](https://www.paws-r-sdk.com/docs/efs_put_lifecycle_configuration/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system for which you are creating the
#' `LifecycleConfiguration` object (String).
#' @param LifecyclePolicies &#91;required&#93; An array of `LifecyclePolicy` objects that define the file system's
#' `LifecycleConfiguration` object. A `LifecycleConfiguration` object
#' informs EFS lifecycle management and EFS Intelligent-Tiering of the
#' following:
#' 
#' -   When to move files in the file system from primary storage to the IA
#'     storage class.
#' 
#' -   When to move files that are in IA storage to primary storage.
#' 
#' When using the `put-lifecycle-configuration` CLI command or the
#' [`put_lifecycle_configuration`][efs_put_lifecycle_configuration] API
#' action, Amazon EFS requires that each `LifecyclePolicy` object have only
#' a single transition. This means that in a request body,
#' `LifecyclePolicies` must be structured as an array of `LifecyclePolicy`
#' objects, one object for each transition, `TransitionToIA`,
#' `TransitionToPrimaryStorageClass`. See the example requests in the
#' following section for more information.
#'
#' @keywords internal
#'
#' @rdname efs_put_lifecycle_configuration
efs_put_lifecycle_configuration <- function(FileSystemId, LifecyclePolicies) {
  op <- new_operation(
    name = "PutLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}/lifecycle-configuration",
    paginator = list()
  )
  input <- .efs$put_lifecycle_configuration_input(FileSystemId = FileSystemId, LifecyclePolicies = LifecyclePolicies)
  output <- .efs$put_lifecycle_configuration_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$put_lifecycle_configuration <- efs_put_lifecycle_configuration

#' Creates a tag for an EFS resource
#'
#' @description
#' Creates a tag for an EFS resource. You can create tags for EFS file systems and access points using this API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_tag_resource/](https://www.paws-r-sdk.com/docs/efs_tag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID specifying the EFS resource that you want to create a tag for.
#' @param Tags &#91;required&#93; An array of `Tag` objects to add. Each `Tag` object is a key-value pair.
#'
#' @keywords internal
#'
#' @rdname efs_tag_resource
efs_tag_resource <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2015-02-01/resource-tags/{ResourceId}",
    paginator = list()
  )
  input <- .efs$tag_resource_input(ResourceId = ResourceId, Tags = Tags)
  output <- .efs$tag_resource_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$tag_resource <- efs_tag_resource

#' Removes tags from an EFS resource
#'
#' @description
#' Removes tags from an EFS resource. You can remove tags from EFS file systems and access points using this API operation.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_untag_resource/](https://www.paws-r-sdk.com/docs/efs_untag_resource/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; Specifies the EFS resource that you want to remove tags from.
#' @param TagKeys &#91;required&#93; The keys of the key-value tag pairs that you want to remove from the
#' specified EFS resource.
#'
#' @keywords internal
#'
#' @rdname efs_untag_resource
efs_untag_resource <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/2015-02-01/resource-tags/{ResourceId}",
    paginator = list()
  )
  input <- .efs$untag_resource_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .efs$untag_resource_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$untag_resource <- efs_untag_resource

#' Updates the throughput mode or the amount of provisioned throughput of
#' an existing file system
#'
#' @description
#' Updates the throughput mode or the amount of provisioned throughput of an existing file system.
#'
#' See [https://www.paws-r-sdk.com/docs/efs_update_file_system/](https://www.paws-r-sdk.com/docs/efs_update_file_system/) for full documentation.
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system that you want to update.
#' @param ThroughputMode (Optional) Updates the file system's throughput mode. If you're not
#' updating your throughput mode, you don't need to provide this value in
#' your request. If you are changing the `ThroughputMode` to `provisioned`,
#' you must also set a value for `ProvisionedThroughputInMibps`.
#' @param ProvisionedThroughputInMibps (Optional) Sets the amount of provisioned throughput, in MiB/s, for the
#' file system. Valid values are 1-1024. If you are changing the throughput
#' mode to provisioned, you must also provide the amount of provisioned
#' throughput. Required if `ThroughputMode` is changed to `provisioned` on
#' update.
#'
#' @keywords internal
#'
#' @rdname efs_update_file_system
efs_update_file_system <- function(FileSystemId, ThroughputMode = NULL, ProvisionedThroughputInMibps = NULL) {
  op <- new_operation(
    name = "UpdateFileSystem",
    http_method = "PUT",
    http_path = "/2015-02-01/file-systems/{FileSystemId}",
    paginator = list()
  )
  input <- .efs$update_file_system_input(FileSystemId = FileSystemId, ThroughputMode = ThroughputMode, ProvisionedThroughputInMibps = ProvisionedThroughputInMibps)
  output <- .efs$update_file_system_output()
  config <- get_config()
  svc <- .efs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.efs$operations$update_file_system <- efs_update_file_system
