# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3outposts_service.R
NULL

#' Creates an endpoint and associates it with the specified Outpost
#'
#' @description
#' Creates an endpoint and associates it with the specified Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/s3outposts_create_endpoint/](https://www.paws-r-sdk.com/docs/s3outposts_create_endpoint/) for full documentation.
#'
#' @param OutpostId &#91;required&#93; The ID of the Outposts.
#' @param SubnetId &#91;required&#93; The ID of the subnet in the selected VPC. The endpoint subnet must
#' belong to the Outpost that has Amazon S3 on Outposts provisioned.
#' @param SecurityGroupId &#91;required&#93; The ID of the security group to use with the endpoint.
#' @param AccessType The type of access for the network connectivity for the Amazon S3 on
#' Outposts endpoint. To use the Amazon Web Services VPC, choose `Private`.
#' To use the endpoint with an on-premises network, choose
#' `CustomerOwnedIp`. If you choose `CustomerOwnedIp`, you must also
#' provide the customer-owned IP address pool (CoIP pool).
#' 
#' `Private` is the default access type value.
#' @param CustomerOwnedIpv4Pool The ID of the customer-owned IPv4 address pool (CoIP pool) for the
#' endpoint. IP addresses are allocated from this pool for the endpoint.
#'
#' @keywords internal
#'
#' @rdname s3outposts_create_endpoint
s3outposts_create_endpoint <- function(OutpostId, SubnetId, SecurityGroupId, AccessType = NULL, CustomerOwnedIpv4Pool = NULL) {
  op <- new_operation(
    name = "CreateEndpoint",
    http_method = "POST",
    http_path = "/S3Outposts/CreateEndpoint",
    paginator = list()
  )
  input <- .s3outposts$create_endpoint_input(OutpostId = OutpostId, SubnetId = SubnetId, SecurityGroupId = SecurityGroupId, AccessType = AccessType, CustomerOwnedIpv4Pool = CustomerOwnedIpv4Pool)
  output <- .s3outposts$create_endpoint_output()
  config <- get_config()
  svc <- .s3outposts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3outposts$operations$create_endpoint <- s3outposts_create_endpoint

#' Deletes an endpoint
#'
#' @description
#' Deletes an endpoint.
#'
#' See [https://www.paws-r-sdk.com/docs/s3outposts_delete_endpoint/](https://www.paws-r-sdk.com/docs/s3outposts_delete_endpoint/) for full documentation.
#'
#' @param EndpointId &#91;required&#93; The ID of the endpoint.
#' @param OutpostId &#91;required&#93; The ID of the Outposts.
#'
#' @keywords internal
#'
#' @rdname s3outposts_delete_endpoint
s3outposts_delete_endpoint <- function(EndpointId, OutpostId) {
  op <- new_operation(
    name = "DeleteEndpoint",
    http_method = "DELETE",
    http_path = "/S3Outposts/DeleteEndpoint",
    paginator = list()
  )
  input <- .s3outposts$delete_endpoint_input(EndpointId = EndpointId, OutpostId = OutpostId)
  output <- .s3outposts$delete_endpoint_output()
  config <- get_config()
  svc <- .s3outposts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3outposts$operations$delete_endpoint <- s3outposts_delete_endpoint

#' Lists endpoints associated with the specified Outpost
#'
#' @description
#' Lists endpoints associated with the specified Outpost.
#'
#' See [https://www.paws-r-sdk.com/docs/s3outposts_list_endpoints/](https://www.paws-r-sdk.com/docs/s3outposts_list_endpoints/) for full documentation.
#'
#' @param NextToken If a previous response from this operation included a `NextToken` value,
#' provide that value here to retrieve the next page of results.
#' @param MaxResults The maximum number of endpoints that will be returned in the response.
#'
#' @keywords internal
#'
#' @rdname s3outposts_list_endpoints
s3outposts_list_endpoints <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListEndpoints",
    http_method = "GET",
    http_path = "/S3Outposts/ListEndpoints",
    paginator = list()
  )
  input <- .s3outposts$list_endpoints_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3outposts$list_endpoints_output()
  config <- get_config()
  svc <- .s3outposts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3outposts$operations$list_endpoints <- s3outposts_list_endpoints

#' Lists the Outposts with S3 on Outposts capacity for your Amazon Web
#' Services account
#'
#' @description
#' Lists the Outposts with S3 on Outposts capacity for your Amazon Web Services account. Includes S3 on Outposts that you have access to as the Outposts owner, or as a shared user from Resource Access Manager (RAM).
#'
#' See [https://www.paws-r-sdk.com/docs/s3outposts_list_outposts_with_s3/](https://www.paws-r-sdk.com/docs/s3outposts_list_outposts_with_s3/) for full documentation.
#'
#' @param NextToken When you can get additional results from the
#' [`list_outposts_with_s3`][s3outposts_list_outposts_with_s3] call, a
#' `NextToken` parameter is returned in the output. You can then pass in a
#' subsequent command to the `NextToken` parameter to continue listing
#' additional Outposts.
#' @param MaxResults The maximum number of Outposts to return. The limit is 100.
#'
#' @keywords internal
#'
#' @rdname s3outposts_list_outposts_with_s3
s3outposts_list_outposts_with_s3 <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListOutpostsWithS3",
    http_method = "GET",
    http_path = "/S3Outposts/ListOutpostsWithS3",
    paginator = list()
  )
  input <- .s3outposts$list_outposts_with_s3_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3outposts$list_outposts_with_s3_output()
  config <- get_config()
  svc <- .s3outposts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3outposts$operations$list_outposts_with_s3 <- s3outposts_list_outposts_with_s3

#' Lists all endpoints associated with an Outpost that has been shared by
#' Amazon Web Services Resource Access Manager (RAM)
#'
#' @description
#' Lists all endpoints associated with an Outpost that has been shared by Amazon Web Services Resource Access Manager (RAM).
#'
#' See [https://www.paws-r-sdk.com/docs/s3outposts_list_shared_endpoints/](https://www.paws-r-sdk.com/docs/s3outposts_list_shared_endpoints/) for full documentation.
#'
#' @param NextToken If a previous response from this operation included a `NextToken` value,
#' you can provide that value here to retrieve the next page of results.
#' @param MaxResults The maximum number of endpoints that will be returned in the response.
#' @param OutpostId &#91;required&#93; The ID of the Amazon Web Services Outpost.
#'
#' @keywords internal
#'
#' @rdname s3outposts_list_shared_endpoints
s3outposts_list_shared_endpoints <- function(NextToken = NULL, MaxResults = NULL, OutpostId) {
  op <- new_operation(
    name = "ListSharedEndpoints",
    http_method = "GET",
    http_path = "/S3Outposts/ListSharedEndpoints",
    paginator = list()
  )
  input <- .s3outposts$list_shared_endpoints_input(NextToken = NextToken, MaxResults = MaxResults, OutpostId = OutpostId)
  output <- .s3outposts$list_shared_endpoints_output()
  config <- get_config()
  svc <- .s3outposts$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3outposts$operations$list_shared_endpoints <- s3outposts_list_shared_endpoints
