% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efs_operations.R
\name{efs_delete_mount_target}
\alias{efs_delete_mount_target}
\title{Deletes the specified mount target}
\usage{
efs_delete_mount_target(MountTargetId)
}
\arguments{
\item{MountTargetId}{[required] The ID of the mount target to delete (String).}
}
\description{
Deletes the specified mount target.
}
\details{
This operation forcibly breaks any mounts of the file system by using
the mount target that is being deleted, which might disrupt instances or
applications using those mounts. To avoid applications getting cut off
abruptly, you might consider unmounting any mounts of the mount target,
if feasible. The operation also deletes the associated network
interface. Uncommitted writes might be lost, but breaking a mount target
using this operation does not corrupt the file system itself. The file
system you created remains. You can mount an EC2 instance in your VPC by
using another mount target.

This operation requires permissions for the following action on the file
system:
\itemize{
\item \code{elasticfilesystem:DeleteMountTarget}
}

The \code{DeleteMountTarget} call returns while the mount target state is
still \code{deleting}. You can check the mount target deletion by calling the
DescribeMountTargets operation, which returns a list of mount target
descriptions for the given file system.

The operation also requires permissions for the following Amazon EC2
action on the mount target\'s network interface:
\itemize{
\item \code{ec2:DeleteNetworkInterface}
}
}
\section{Request syntax}{
\preformatted{svc$delete_mount_target(
  MountTargetId = "string"
)
}
}

\examples{
\dontrun{
# This operation deletes a mount target.
svc$delete_mount_target(
  MountTargetId = "fsmt-12340abc"
)
}

}
\keyword{internal}
