# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include glacier_service.R
NULL

#' This operation aborts a multipart upload identified by the upload ID
#'
#' This operation aborts a multipart upload identified by the upload ID.
#' 
#' After the Abort Multipart Upload request succeeds, you cannot upload any
#' more parts to the multipart upload or complete the multipart upload.
#' Aborting a completed upload fails. However, aborting an already-aborted
#' upload will succeed, for a short time. For more information about
#' uploading a part and completing a multipart upload, see
#' UploadMultipartPart and CompleteMultipartUpload.
#' 
#' This operation is idempotent.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Working with
#' Archives in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
#' and [Abort Multipart
#' Upload](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-abort-upload.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_abort_multipart_upload(accountId, vaultName, uploadId)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload to delete.
#'
#' @section Request syntax:
#' ```
#' svc$abort_multipart_upload(
#'   accountId = "string",
#'   vaultName = "string",
#'   uploadId = "string"
#' )
#' ```
#'
#' @examples
#' # The example deletes an in-progress multipart upload to a vault named
#' # my-vault:
#' \donttest{svc$abort_multipart_upload(
#'   accountId = "-",
#'   uploadId = "19gaRezEXAMPLES6Ry5YYdqthHOC_kGRCT03L9yetr220UmPtBYKk-OssZtLqyFu7sY1_lR7vgFuJV...",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_abort_multipart_upload
glacier_abort_multipart_upload <- function(accountId, vaultName, uploadId) {
  op <- new_operation(
    name = "AbortMultipartUpload",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    paginator = list()
  )
  input <- .glacier$abort_multipart_upload_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId)
  output <- .glacier$abort_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$abort_multipart_upload <- glacier_abort_multipart_upload

#' This operation aborts the vault locking process if the vault lock is not
#' in the Locked state
#'
#' This operation aborts the vault locking process if the vault lock is not
#' in the `Locked` state. If the vault lock is in the `Locked` state when
#' this operation is requested, the operation returns an
#' `AccessDeniedException` error. Aborting the vault locking process
#' removes the vault lock policy from the specified vault.
#' 
#' A vault lock is put into the `InProgress` state by calling
#' InitiateVaultLock. A vault lock is put into the `Locked` state by
#' calling CompleteVaultLock. You can get the state of a vault lock by
#' calling GetVaultLock. For more information about the vault locking
#' process, see [Amazon Glacier Vault
#' Lock](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
#' For more information about vault lock policies, see [Amazon Glacier
#' Access Control with Vault Lock
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
#' 
#' This operation is idempotent. You can successfully invoke this operation
#' multiple times, if the vault lock is in the `InProgress` state or if
#' there is no policy associated with the vault.
#'
#' @usage
#' glacier_abort_vault_lock(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$abort_vault_lock(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example aborts the vault locking process if the vault lock is not in
#' # the Locked state for the vault named examplevault.
#' \donttest{svc$abort_vault_lock(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_abort_vault_lock
glacier_abort_vault_lock <- function(accountId, vaultName) {
  op <- new_operation(
    name = "AbortVaultLock",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    paginator = list()
  )
  input <- .glacier$abort_vault_lock_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$abort_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$abort_vault_lock <- glacier_abort_vault_lock

#' This operation adds the specified tags to a vault
#'
#' This operation adds the specified tags to a vault. Each tag is composed
#' of a key and a value. Each vault can have up to 10 tags. If your request
#' would cause the tag limit for the vault to be exceeded, the operation
#' throws the `LimitExceededException` error. If a tag already exists on
#' the vault under a specified key, the existing key value will be
#' overwritten. For more information about tags, see [Tagging Amazon S3
#' Glacier
#' Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
#'
#' @usage
#' glacier_add_tags_to_vault(accountId, vaultName, Tags)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param Tags The tags to add to the vault. Each tag is composed of a key and a value.
#' The value can be an empty string.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_vault(
#'   accountId = "string",
#'   vaultName = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The example adds two tags to a my-vault.
#' \donttest{svc$add_tags_to_vault(
#'   Tags = list(
#'     examplekey1 = "examplevalue1",
#'     examplekey2 = "examplevalue2"
#'   ),
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_add_tags_to_vault
glacier_add_tags_to_vault <- function(accountId, vaultName, Tags = NULL) {
  op <- new_operation(
    name = "AddTagsToVault",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/tags?operation=add",
    paginator = list()
  )
  input <- .glacier$add_tags_to_vault_input(accountId = accountId, vaultName = vaultName, Tags = Tags)
  output <- .glacier$add_tags_to_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$add_tags_to_vault <- glacier_add_tags_to_vault

#' You call this operation to inform Amazon S3 Glacier (Glacier) that all
#' the archive parts have been uploaded and that Glacier can now assemble
#' the archive from the uploaded parts
#'
#' You call this operation to inform Amazon S3 Glacier (Glacier) that all
#' the archive parts have been uploaded and that Glacier can now assemble
#' the archive from the uploaded parts. After assembling and saving the
#' archive to the vault, Glacier returns the URI path of the newly created
#' archive resource. Using the URI path, you can then access the archive.
#' After you upload an archive, you should save the archive ID returned to
#' retrieve the archive at a later point. You can also get the vault
#' inventory to obtain a list of archive IDs in a vault. For more
#' information, see InitiateJob.
#' 
#' In the request, you must include the computed SHA256 tree hash of the
#' entire archive you have uploaded. For information about computing a
#' SHA256 tree hash, see [Computing
#' Checksums](https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
#' On the server side, Glacier also constructs the SHA256 tree hash of the
#' assembled archive. If the values match, Glacier saves the archive to the
#' vault; otherwise, it returns an error, and the operation fails. The
#' ListParts operation returns a list of parts uploaded for a specific
#' multipart upload. It includes checksum information for each uploaded
#' part that can be used to debug a bad checksum issue.
#' 
#' Additionally, Glacier also checks for any missing content ranges when
#' assembling the archive, if missing content ranges are found, Glacier
#' returns an error and the operation fails.
#' 
#' Complete Multipart Upload is an idempotent operation. After your first
#' successful complete multipart upload, if you call the operation again
#' within a short period, the operation will succeed and return the same
#' archive ID. This is useful in the event you experience a network issue
#' that causes an aborted connection or receive a 500 server error, in
#' which case you can repeat your Complete Multipart Upload request and get
#' the same archive ID without creating duplicate archives. Note, however,
#' that after the multipart upload completes, you cannot call the List
#' Parts operation and the multipart upload will not appear in List
#' Multipart Uploads response, even if idempotent complete is possible.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Uploading Large
#' Archives in Parts (Multipart
#' Upload)](https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
#' and [Complete Multipart
#' Upload](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-complete-upload.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_complete_multipart_upload(accountId, vaultName, uploadId,
#'   archiveSize, checksum)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param archiveSize The total size, in bytes, of the entire archive. This value should be
#' the sum of all the sizes of the individual parts that you uploaded.
#' @param checksum The SHA256 tree hash of the entire archive. It is the tree hash of
#' SHA256 tree hash of the individual parts. If the value you specify in
#' the request does not match the SHA256 tree hash of the final assembled
#' archive as computed by Amazon S3 Glacier (Glacier), Glacier returns an
#' error and the request fails.
#'
#' @section Request syntax:
#' ```
#' svc$complete_multipart_upload(
#'   accountId = "string",
#'   vaultName = "string",
#'   uploadId = "string",
#'   archiveSize = "string",
#'   checksum = "string"
#' )
#' ```
#'
#' @examples
#' # The example completes a multipart upload for a 3 MiB archive.
#' \donttest{svc$complete_multipart_upload(
#'   accountId = "-",
#'   archiveSize = "3145728",
#'   checksum = "9628195fcdbcbbe76cdde456d4646fa7de5f219fb39823836d81f0cc0e18aa67",
#'   uploadId = "19gaRezEXAMPLES6Ry5YYdqthHOC_kGRCT03L9yetr220UmPtBYKk-OssZtLqyFu7sY1_lR7vgFuJV...",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_complete_multipart_upload
glacier_complete_multipart_upload <- function(accountId, vaultName, uploadId, archiveSize = NULL, checksum = NULL) {
  op <- new_operation(
    name = "CompleteMultipartUpload",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    paginator = list()
  )
  input <- .glacier$complete_multipart_upload_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, archiveSize = archiveSize, checksum = checksum)
  output <- .glacier$complete_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$complete_multipart_upload <- glacier_complete_multipart_upload

#' This operation completes the vault locking process by transitioning the
#' vault lock from the InProgress state to the Locked state, which causes
#' the vault lock policy to become unchangeable
#'
#' This operation completes the vault locking process by transitioning the
#' vault lock from the `InProgress` state to the `Locked` state, which
#' causes the vault lock policy to become unchangeable. A vault lock is put
#' into the `InProgress` state by calling InitiateVaultLock. You can obtain
#' the state of the vault lock by calling GetVaultLock. For more
#' information about the vault locking process, [Amazon Glacier Vault
#' Lock](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
#' 
#' This operation is idempotent. This request is always successful if the
#' vault lock is in the `Locked` state and the provided lock ID matches the
#' lock ID originally used to lock the vault.
#' 
#' If an invalid lock ID is passed in the request when the vault lock is in
#' the `Locked` state, the operation returns an `AccessDeniedException`
#' error. If an invalid lock ID is passed in the request when the vault
#' lock is in the `InProgress` state, the operation throws an
#' `InvalidParameter` error.
#'
#' @usage
#' glacier_complete_vault_lock(accountId, vaultName, lockId)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param lockId &#91;required&#93; The `lockId` value is the lock ID obtained from a InitiateVaultLock
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$complete_vault_lock(
#'   accountId = "string",
#'   vaultName = "string",
#'   lockId = "string"
#' )
#' ```
#'
#' @examples
#' # The example completes the vault locking process by transitioning the
#' # vault lock from the InProgress state to the Locked state.
#' \donttest{svc$complete_vault_lock(
#'   accountId = "-",
#'   lockId = "AE863rKkWZU53SLW5be4DUcW",
#'   vaultName = "example-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_complete_vault_lock
glacier_complete_vault_lock <- function(accountId, vaultName, lockId) {
  op <- new_operation(
    name = "CompleteVaultLock",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy/{lockId}",
    paginator = list()
  )
  input <- .glacier$complete_vault_lock_input(accountId = accountId, vaultName = vaultName, lockId = lockId)
  output <- .glacier$complete_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$complete_vault_lock <- glacier_complete_vault_lock

#' This operation creates a new vault with the specified name
#'
#' This operation creates a new vault with the specified name. The name of
#' the vault must be unique within a region for an AWS account. You can
#' create up to 1,000 vaults per account. If you need to create more
#' vaults, contact Amazon S3 Glacier.
#' 
#' You must use the following guidelines when naming a vault.
#' 
#' -   Names can be between 1 and 255 characters long.
#' 
#' -   Allowed characters are a-z, A-Z, 0-9, \'\\_\' (underscore), \'-\'
#'     (hyphen), and \'.\' (period).
#' 
#' This operation is idempotent.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Creating a
#' Vault in Amazon
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/creating-vaults.html)
#' and [Create
#' Vault](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-put.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_create_vault(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon S3 Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$create_vault(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The following example creates a new vault named my-vault.
#' \donttest{svc$create_vault(
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_create_vault
glacier_create_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "CreateVault",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}",
    paginator = list()
  )
  input <- .glacier$create_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$create_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$create_vault <- glacier_create_vault

#' This operation deletes an archive from a vault
#'
#' This operation deletes an archive from a vault. Subsequent requests to
#' initiate a retrieval of this archive will fail. Archive retrievals that
#' are in progress for this archive ID may or may not succeed according to
#' the following scenarios:
#' 
#' -   If the archive retrieval job is actively preparing the data for
#'     download when Amazon S3 Glacier receives the delete archive request,
#'     the archival retrieval operation might fail.
#' 
#' -   If the archive retrieval job has successfully prepared the archive
#'     for download when Amazon S3 Glacier receives the delete archive
#'     request, you will be able to download the output.
#' 
#' This operation is idempotent. Attempting to delete an already-deleted
#' archive does not result in an error.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Deleting an
#' Archive in Amazon
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-an-archive.html)
#' and [Delete
#' Archive](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_delete_archive(accountId, vaultName, archiveId)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param archiveId &#91;required&#93; The ID of the archive to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_archive(
#'   accountId = "string",
#'   vaultName = "string",
#'   archiveId = "string"
#' )
#' ```
#'
#' @examples
#' # The example deletes the archive specified by the archive ID.
#' \donttest{svc$delete_archive(
#'   accountId = "-",
#'   archiveId = "NkbByEejwEggmBz2fTHgJrg0XBoDfjP4q6iu87-TjhqG6eGoOY9Z8i1_AUyUsuhPAdTqLHy8pTl5n...",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_delete_archive
glacier_delete_archive <- function(accountId, vaultName, archiveId) {
  op <- new_operation(
    name = "DeleteArchive",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/archives/{archiveId}",
    paginator = list()
  )
  input <- .glacier$delete_archive_input(accountId = accountId, vaultName = vaultName, archiveId = archiveId)
  output <- .glacier$delete_archive_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_archive <- glacier_delete_archive

#' This operation deletes a vault
#'
#' This operation deletes a vault. Amazon S3 Glacier will delete a vault
#' only if there are no archives in the vault as of the last inventory and
#' there have been no writes to the vault since the last inventory. If
#' either of these conditions is not satisfied, the vault deletion fails
#' (that is, the vault is not removed) and Amazon S3 Glacier returns an
#' error. You can use DescribeVault to return the number of archives in a
#' vault, and you can use [Initiate a Job (POST
#' jobs)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html)
#' to initiate a new inventory retrieval for a vault. The inventory
#' contains the archive IDs you use to delete archives using [Delete
#' Archive (DELETE
#' archive)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-delete.html).
#' 
#' This operation is idempotent.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Deleting a
#' Vault in Amazon
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/deleting-vaults.html)
#' and [Delete
#' Vault](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-delete.html)
#' in the *Amazon S3 Glacier Developer Guide*.
#'
#' @usage
#' glacier_delete_vault(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vault(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example deletes a vault named my-vault:
#' \donttest{svc$delete_vault(
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault
glacier_delete_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVault",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}",
    paginator = list()
  )
  input <- .glacier$delete_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault <- glacier_delete_vault

#' This operation deletes the access policy associated with the specified
#' vault
#'
#' This operation deletes the access policy associated with the specified
#' vault. The operation is eventually consistent; that is, it might take
#' some time for Amazon S3 Glacier to completely remove the access policy,
#' and you might still see the effect of the policy for a short time after
#' you send the delete request.
#' 
#' This operation is idempotent. You can invoke delete multiple times, even
#' if there is no policy associated with the vault. For more information
#' about vault access policies, see [Amazon Glacier Access Control with
#' Vault Access
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
#'
#' @usage
#' glacier_delete_vault_access_policy(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vault_access_policy(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example deletes the access policy associated with the vault named
#' # examplevault.
#' \donttest{svc$delete_vault_access_policy(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault_access_policy
glacier_delete_vault_access_policy <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVaultAccessPolicy",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    paginator = list()
  )
  input <- .glacier$delete_vault_access_policy_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault_access_policy <- glacier_delete_vault_access_policy

#' This operation deletes the notification configuration set for a vault
#'
#' This operation deletes the notification configuration set for a vault.
#' The operation is eventually consistent; that is, it might take some time
#' for Amazon S3 Glacier to completely disable the notifications and you
#' might still receive some notifications for a short time after you send
#' the delete request.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Configuring
#' Vault Notifications in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
#' and [Delete Vault Notification
#' Configuration](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-delete.html)
#' in the Amazon S3 Glacier Developer Guide.
#'
#' @usage
#' glacier_delete_vault_notifications(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vault_notifications(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example deletes the notification configuration set for the vault
#' # named examplevault.
#' \donttest{svc$delete_vault_notifications(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_delete_vault_notifications
glacier_delete_vault_notifications <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DeleteVaultNotifications",
    http_method = "DELETE",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    paginator = list()
  )
  input <- .glacier$delete_vault_notifications_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$delete_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$delete_vault_notifications <- glacier_delete_vault_notifications

#' This operation returns information about a job you previously initiated,
#' including the job initiation date, the user who initiated the job, the
#' job status code/message and the Amazon SNS topic to notify after Amazon
#' S3 Glacier (Glacier) completes the job
#'
#' This operation returns information about a job you previously initiated,
#' including the job initiation date, the user who initiated the job, the
#' job status code/message and the Amazon SNS topic to notify after Amazon
#' S3 Glacier (Glacier) completes the job. For more information about
#' initiating a job, see InitiateJob.
#' 
#' This operation enables you to check the status of your job. However, it
#' is strongly recommended that you set up an Amazon SNS topic and specify
#' it in your initiate job request so that Glacier can notify the topic
#' after it completes the job.
#' 
#' A job ID will not expire for at least 24 hours after Glacier completes
#' the job.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For more information about using this operation, see the documentation
#' for the underlying REST API [Describe
#' Job](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-describe-job-get.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_describe_job(accountId, vaultName, jobId)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobId &#91;required&#93; The ID of the job to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_job(
#'   accountId = "string",
#'   vaultName = "string",
#'   jobId = "string"
#' )
#' ```
#'
#' @examples
#' # The example returns information about the previously initiated job
#' # specified by the job ID.
#' \donttest{svc$describe_job(
#'   accountId = "-",
#'   jobId = "zbxcm3Z_3z5UkoroF7SuZKrxgGoDc3RloGduS7Eg-RO47Yc6FxsdGBgf_Q2DK5Ejh18CnTS5XW4_XqlNH...",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_describe_job
glacier_describe_job <- function(accountId, vaultName, jobId) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs/{jobId}",
    paginator = list()
  )
  input <- .glacier$describe_job_input(accountId = accountId, vaultName = vaultName, jobId = jobId)
  output <- .glacier$describe_job_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$describe_job <- glacier_describe_job

#' This operation returns information about a vault, including the vault's
#' Amazon Resource Name (ARN), the date the vault was created, the number
#' of archives it contains, and the total size of all the archives in the
#' vault
#'
#' This operation returns information about a vault, including the vault\'s
#' Amazon Resource Name (ARN), the date the vault was created, the number
#' of archives it contains, and the total size of all the archives in the
#' vault. The number of archives and their total size are as of the last
#' inventory generation. This means that if you add or remove an archive
#' from a vault, and then immediately use Describe Vault, the change in
#' contents will not be immediately reflected. If you want to retrieve the
#' latest inventory of the vault, use InitiateJob. Amazon S3 Glacier
#' generates vault inventories approximately daily. For more information,
#' see [Downloading a Vault Inventory in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html).
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Retrieving
#' Vault Metadata in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
#' and [Describe
#' Vault](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-get.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_describe_vault(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vault(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example retrieves data about a vault named my-vault.
#' \donttest{svc$describe_vault(
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_describe_vault
glacier_describe_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "DescribeVault",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}",
    paginator = list()
  )
  input <- .glacier$describe_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$describe_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$describe_vault <- glacier_describe_vault

#' This operation returns the current data retrieval policy for the account
#' and region specified in the GET request
#'
#' This operation returns the current data retrieval policy for the account
#' and region specified in the GET request. For more information about data
#' retrieval policies, see [Amazon Glacier Data Retrieval
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
#'
#' @usage
#' glacier_get_data_retrieval_policy(accountId)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_data_retrieval_policy(
#'   accountId = "string"
#' )
#' ```
#'
#' @examples
#' # The example returns the current data retrieval policy for the account.
#' \donttest{svc$get_data_retrieval_policy(
#'   accountId = "-"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_get_data_retrieval_policy
glacier_get_data_retrieval_policy <- function(accountId) {
  op <- new_operation(
    name = "GetDataRetrievalPolicy",
    http_method = "GET",
    http_path = "/{accountId}/policies/data-retrieval",
    paginator = list()
  )
  input <- .glacier$get_data_retrieval_policy_input(accountId = accountId)
  output <- .glacier$get_data_retrieval_policy_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_data_retrieval_policy <- glacier_get_data_retrieval_policy

#' This operation downloads the output of the job you initiated using
#' InitiateJob
#'
#' This operation downloads the output of the job you initiated using
#' InitiateJob. Depending on the job type you specified when you initiated
#' the job, the output will be either the content of an archive or a vault
#' inventory.
#' 
#' You can download all the job output or download a portion of the output
#' by specifying a byte range. In the case of an archive retrieval job,
#' depending on the byte range you specify, Amazon S3 Glacier (Glacier)
#' returns the checksum for the portion of the data. You can compute the
#' checksum on the client and verify that the values match to ensure the
#' portion you downloaded is the correct data.
#' 
#' A job ID will not expire for at least 24 hours after Glacier completes
#' the job. That a byte range. For both archive and inventory retrieval
#' jobs, you should verify the downloaded size against the size returned in
#' the headers from the **Get Job Output** response.
#' 
#' For archive retrieval jobs, you should also verify that the size is what
#' you expected. If you download a portion of the output, the expected size
#' is based on the range of bytes you specified. For example, if you
#' specify a range of `bytes=0-1048575`, you should verify your download
#' size is 1,048,576 bytes. If you download an entire archive, the expected
#' size is the size of the archive when you uploaded it to Amazon S3
#' Glacier The expected size is also returned in the headers from the **Get
#' Job Output** response.
#' 
#' In the case of an archive retrieval job, depending on the byte range you
#' specify, Glacier returns the checksum for the portion of the data. To
#' ensure the portion you downloaded is the correct data, compute the
#' checksum on the client, verify that the values match, and verify that
#' the size is what you expected.
#' 
#' A job ID does not expire for at least 24 hours after Glacier completes
#' the job. That is, you can download the job output within the 24 hours
#' period after Amazon Glacier completes the job.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and the underlying REST API, see [Downloading
#' a Vault
#' Inventory](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-inventory.html),
#' [Downloading an
#' Archive](https://docs.aws.amazon.com/amazonglacier/latest/dev/downloading-an-archive.html),
#' and [Get Job
#' Output](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-job-output-get.html)
#'
#' @usage
#' glacier_get_job_output(accountId, vaultName, jobId, range)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobId &#91;required&#93; The job ID whose data is downloaded.
#' @param range The range of bytes to retrieve from the output. For example, if you want
#' to download the first 1,048,576 bytes, specify the range as
#' `bytes=0-1048575`. By default, this operation downloads the entire
#' output.
#' 
#' If the job output is large, then you can use a range to retrieve a
#' portion of the output. This allows you to download the entire output in
#' smaller chunks of bytes. For example, suppose you have 1 GB of job
#' output you want to download and you decide to download 128 MB chunks of
#' data at a time, which is a total of eight Get Job Output requests. You
#' use the following process to download the job output:
#' 
#' 1.  Download a 128 MB chunk of output by specifying the appropriate byte
#'     range. Verify that all 128 MB of data was received.
#' 
#' 2.  Along with the data, the response includes a SHA256 tree hash of the
#'     payload. You compute the checksum of the payload on the client and
#'     compare it with the checksum you received in the response to ensure
#'     you received all the expected data.
#' 
#' 3.  Repeat steps 1 and 2 for all the eight 128 MB chunks of output data,
#'     each time specifying the appropriate byte range.
#' 
#' 4.  After downloading all the parts of the job output, you have a list
#'     of eight checksum values. Compute the tree hash of these values to
#'     find the checksum of the entire output. Using the DescribeJob API,
#'     obtain job information of the job that provided you the output. The
#'     response includes the checksum of the entire archive stored in
#'     Amazon S3 Glacier. You compare this value with the checksum you
#'     computed to ensure you have downloaded the entire archive content
#'     with no errors.
#'
#' @section Request syntax:
#' ```
#' svc$get_job_output(
#'   accountId = "string",
#'   vaultName = "string",
#'   jobId = "string",
#'   range = "string"
#' )
#' ```
#'
#' @examples
#' # The example downloads the output of a previously initiated inventory
#' # retrieval job that is identified by the job ID.
#' \donttest{svc$get_job_output(
#'   accountId = "-",
#'   jobId = "zbxcm3Z_3z5UkoroF7SuZKrxgGoDc3RloGduS7Eg-RO47Yc6FxsdGBgf_Q2DK5Ejh18CnTS5XW4_XqlNH...",
#'   range = "",
#'   vaultName = "my-vaul"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_get_job_output
glacier_get_job_output <- function(accountId, vaultName, jobId, range = NULL) {
  op <- new_operation(
    name = "GetJobOutput",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs/{jobId}/output",
    paginator = list()
  )
  input <- .glacier$get_job_output_input(accountId = accountId, vaultName = vaultName, jobId = jobId, range = range)
  output <- .glacier$get_job_output_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_job_output <- glacier_get_job_output

#' This operation retrieves the access-policy subresource set on the vault;
#' for more information on setting this subresource, see Set Vault Access
#' Policy (PUT access-policy)
#'
#' This operation retrieves the `access-policy` subresource set on the
#' vault; for more information on setting this subresource, see [Set Vault
#' Access Policy (PUT
#' access-policy)](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-SetVaultAccessPolicy.html).
#' If there is no access policy set on the vault, the operation returns a
#' `404 Not found` error. For more information about vault access policies,
#' see [Amazon Glacier Access Control with Vault Access
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
#'
#' @usage
#' glacier_get_vault_access_policy(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$get_vault_access_policy(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example retrieves the access-policy set on the vault named
#' # example-vault.
#' \donttest{svc$get_vault_access_policy(
#'   accountId = "-",
#'   vaultName = "example-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_access_policy
glacier_get_vault_access_policy <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultAccessPolicy",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    paginator = list()
  )
  input <- .glacier$get_vault_access_policy_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_access_policy <- glacier_get_vault_access_policy

#' This operation retrieves the following attributes from the lock-policy
#' subresource set on the specified vault: - The vault lock policy set on
#' the vault
#'
#' This operation retrieves the following attributes from the `lock-policy`
#' subresource set on the specified vault:
#' 
#' -   The vault lock policy set on the vault.
#' 
#' -   The state of the vault lock, which is either `InProgess` or
#'     `Locked`.
#' 
#' -   When the lock ID expires. The lock ID is used to complete the vault
#'     locking process.
#' 
#' -   When the vault lock was initiated and put into the `InProgress`
#'     state.
#' 
#' A vault lock is put into the `InProgress` state by calling
#' InitiateVaultLock. A vault lock is put into the `Locked` state by
#' calling CompleteVaultLock. You can abort the vault locking process by
#' calling AbortVaultLock. For more information about the vault locking
#' process, [Amazon Glacier Vault
#' Lock](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
#' 
#' If there is no vault lock policy set on the vault, the operation returns
#' a `404 Not found` error. For more information about vault lock policies,
#' [Amazon Glacier Access Control with Vault Lock
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
#'
#' @usage
#' glacier_get_vault_lock(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$get_vault_lock(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example retrieves the attributes from the lock-policy subresource
#' # set on the vault named examplevault.
#' \donttest{svc$get_vault_lock(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_lock
glacier_get_vault_lock <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultLock",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    paginator = list()
  )
  input <- .glacier$get_vault_lock_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_lock <- glacier_get_vault_lock

#' This operation retrieves the notification-configuration subresource of
#' the specified vault
#'
#' This operation retrieves the `notification-configuration` subresource of
#' the specified vault.
#' 
#' For information about setting a notification configuration on a vault,
#' see SetVaultNotifications. If a notification configuration for a vault
#' is not set, the operation returns a `404 Not Found` error. For more
#' information about vault notifications, see [Configuring Vault
#' Notifications in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html).
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Configuring
#' Vault Notifications in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
#' and [Get Vault Notification
#' Configuration](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-get.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_get_vault_notifications(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$get_vault_notifications(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example retrieves the notification-configuration for the vault named
#' # my-vault.
#' \donttest{svc$get_vault_notifications(
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_get_vault_notifications
glacier_get_vault_notifications <- function(accountId, vaultName) {
  op <- new_operation(
    name = "GetVaultNotifications",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    paginator = list()
  )
  input <- .glacier$get_vault_notifications_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$get_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$get_vault_notifications <- glacier_get_vault_notifications

#' This operation initiates a job of the specified type, which can be a
#' select, an archival retrieval, or a vault retrieval
#'
#' This operation initiates a job of the specified type, which can be a
#' select, an archival retrieval, or a vault retrieval. For more
#' information about using this operation, see the documentation for the
#' underlying REST API [Initiate a
#' Job](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-initiate-job-post.html).
#'
#' @usage
#' glacier_initiate_job(accountId, vaultName, jobParameters)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param jobParameters Provides options for specifying job information.
#'
#' @section Request syntax:
#' ```
#' svc$initiate_job(
#'   accountId = "string",
#'   vaultName = "string",
#'   jobParameters = list(
#'     Format = "string",
#'     Type = "string",
#'     ArchiveId = "string",
#'     Description = "string",
#'     SNSTopic = "string",
#'     RetrievalByteRange = "string",
#'     Tier = "string",
#'     InventoryRetrievalParameters = list(
#'       StartDate = "string",
#'       EndDate = "string",
#'       Limit = "string",
#'       Marker = "string"
#'     ),
#'     SelectParameters = list(
#'       InputSerialization = list(
#'         csv = list(
#'           FileHeaderInfo = "USE"|"IGNORE"|"NONE",
#'           Comments = "string",
#'           QuoteEscapeCharacter = "string",
#'           RecordDelimiter = "string",
#'           FieldDelimiter = "string",
#'           QuoteCharacter = "string"
#'         )
#'       ),
#'       ExpressionType = "SQL",
#'       Expression = "string",
#'       OutputSerialization = list(
#'         csv = list(
#'           QuoteFields = "ALWAYS"|"ASNEEDED",
#'           QuoteEscapeCharacter = "string",
#'           RecordDelimiter = "string",
#'           FieldDelimiter = "string",
#'           QuoteCharacter = "string"
#'         )
#'       )
#'     ),
#'     OutputLocation = list(
#'       S3 = list(
#'         BucketName = "string",
#'         Prefix = "string",
#'         Encryption = list(
#'           EncryptionType = "aws:kms"|"AES256",
#'           KMSKeyId = "string",
#'           KMSContext = "string"
#'         ),
#'         CannedACL = "private"|"public-read"|"public-read-write"|"aws-exec-read"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control",
#'         AccessControlList = list(
#'           list(
#'             Grantee = list(
#'               Type = "AmazonCustomerByEmail"|"CanonicalUser"|"Group",
#'               DisplayName = "string",
#'               URI = "string",
#'               ID = "string",
#'               EmailAddress = "string"
#'             ),
#'             Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
#'           )
#'         ),
#'         Tagging = list(
#'           "string"
#'         ),
#'         UserMetadata = list(
#'           "string"
#'         ),
#'         StorageClass = "STANDARD"|"REDUCED_REDUNDANCY"|"STANDARD_IA"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The example initiates an inventory-retrieval job for the vault named
#' # examplevault.
#' \donttest{svc$initiate_job(
#'   accountId = "-",
#'   jobParameters = list(
#'     Description = "My inventory job",
#'     Format = "CSV",
#'     SNSTopic = "arn:aws:sns:us-west-2:111111111111:Glacier-InventoryRetrieval-topic-Example",
#'     Type = "inventory-retrieval"
#'   ),
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_job
glacier_initiate_job <- function(accountId, vaultName, jobParameters = NULL) {
  op <- new_operation(
    name = "InitiateJob",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/jobs",
    paginator = list()
  )
  input <- .glacier$initiate_job_input(accountId = accountId, vaultName = vaultName, jobParameters = jobParameters)
  output <- .glacier$initiate_job_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_job <- glacier_initiate_job

#' This operation initiates a multipart upload
#'
#' This operation initiates a multipart upload. Amazon S3 Glacier creates a
#' multipart upload resource and returns its ID in the response. The
#' multipart upload ID is used in subsequent requests to upload parts of an
#' archive (see UploadMultipartPart).
#' 
#' When you initiate a multipart upload, you specify the part size in
#' number of bytes. The part size must be a megabyte (1024 KB) multiplied
#' by a power of 2-for example, 1048576 (1 MB), 2097152 (2 MB), 4194304 (4
#' MB), 8388608 (8 MB), and so on. The minimum allowable part size is 1 MB,
#' and the maximum is 4 GB.
#' 
#' Every part you upload to this resource (see UploadMultipartPart), except
#' the last one, must have the same size. The last one can be the same size
#' or smaller. For example, suppose you want to upload a 16.2 MB file. If
#' you initiate the multipart upload with a part size of 4 MB, you will
#' upload four parts of 4 MB each and one part of 0.2 MB.
#' 
#' You don\'t need to know the size of the archive when you start a
#' multipart upload because Amazon S3 Glacier does not require you to
#' specify the overall archive size.
#' 
#' After you complete the multipart upload, Amazon S3 Glacier (Glacier)
#' removes the multipart upload resource referenced by the ID. Glacier also
#' removes the multipart upload resource if you cancel the multipart upload
#' or it may be removed if there is no activity for a period of 24 hours.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Uploading Large
#' Archives in Parts (Multipart
#' Upload)](https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
#' and [Initiate Multipart
#' Upload](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-initiate-upload.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_initiate_multipart_upload(accountId, vaultName,
#'   archiveDescription, partSize)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param archiveDescription The archive description that you are uploading in parts.
#' 
#' The part size must be a megabyte (1024 KB) multiplied by a power of 2,
#' for example 1048576 (1 MB), 2097152 (2 MB), 4194304 (4 MB), 8388608 (8
#' MB), and so on. The minimum allowable part size is 1 MB, and the maximum
#' is 4 GB (4096 MB).
#' @param partSize The size of each part except the last, in bytes. The last part can be
#' smaller than this part size.
#'
#' @section Request syntax:
#' ```
#' svc$initiate_multipart_upload(
#'   accountId = "string",
#'   vaultName = "string",
#'   archiveDescription = "string",
#'   partSize = "string"
#' )
#' ```
#'
#' @examples
#' # The example initiates a multipart upload to a vault named my-vault with
#' # a part size of 1 MiB (1024 x 1024 bytes) per file.
#' \donttest{svc$initiate_multipart_upload(
#'   accountId = "-",
#'   partSize = "1048576",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_multipart_upload
glacier_initiate_multipart_upload <- function(accountId, vaultName, archiveDescription = NULL, partSize = NULL) {
  op <- new_operation(
    name = "InitiateMultipartUpload",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads",
    paginator = list()
  )
  input <- .glacier$initiate_multipart_upload_input(accountId = accountId, vaultName = vaultName, archiveDescription = archiveDescription, partSize = partSize)
  output <- .glacier$initiate_multipart_upload_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_multipart_upload <- glacier_initiate_multipart_upload

#' This operation initiates the vault locking process by doing the
#' following: - Installing a vault lock policy on the specified vault
#'
#' This operation initiates the vault locking process by doing the
#' following:
#' 
#' -   Installing a vault lock policy on the specified vault.
#' 
#' -   Setting the lock state of vault lock to `InProgress`.
#' 
#' -   Returning a lock ID, which is used to complete the vault locking
#'     process.
#' 
#' You can set one vault lock policy for each vault and this policy can be
#' up to 20 KB in size. For more information about vault lock policies, see
#' [Amazon Glacier Access Control with Vault Lock
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock-policy.html).
#' 
#' You must complete the vault locking process within 24 hours after the
#' vault lock enters the `InProgress` state. After the 24 hour window ends,
#' the lock ID expires, the vault automatically exits the `InProgress`
#' state, and the vault lock policy is removed from the vault. You call
#' CompleteVaultLock to complete the vault locking process by setting the
#' state of the vault lock to `Locked`.
#' 
#' After a vault lock is in the `Locked` state, you cannot initiate a new
#' vault lock for the vault.
#' 
#' You can abort the vault locking process by calling AbortVaultLock. You
#' can get the state of the vault lock by calling GetVaultLock. For more
#' information about the vault locking process, [Amazon Glacier Vault
#' Lock](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-lock.html).
#' 
#' If this operation is called when the vault lock is in the `InProgress`
#' state, the operation returns an `AccessDeniedException` error. When the
#' vault lock is in the `InProgress` state you must call AbortVaultLock
#' before you can initiate a new vault lock policy.
#'
#' @usage
#' glacier_initiate_vault_lock(accountId, vaultName, policy)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param policy The vault lock policy as a JSON string, which uses \"\\\" as an escape
#' character.
#'
#' @section Request syntax:
#' ```
#' svc$initiate_vault_lock(
#'   accountId = "string",
#'   vaultName = "string",
#'   policy = list(
#'     Policy = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The example initiates the vault locking process for the vault named
#' # my-vault.
#' \donttest{svc$initiate_vault_lock(
#'   accountId = "-",
#'   policy = list(
#'     Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":\"Define-vault-lock\",..."
#'   ),
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_initiate_vault_lock
glacier_initiate_vault_lock <- function(accountId, vaultName, policy = NULL) {
  op <- new_operation(
    name = "InitiateVaultLock",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/lock-policy",
    paginator = list()
  )
  input <- .glacier$initiate_vault_lock_input(accountId = accountId, vaultName = vaultName, policy = policy)
  output <- .glacier$initiate_vault_lock_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$initiate_vault_lock <- glacier_initiate_vault_lock

#' This operation lists jobs for a vault, including jobs that are
#' in-progress and jobs that have recently finished
#'
#' This operation lists jobs for a vault, including jobs that are
#' in-progress and jobs that have recently finished. The List Job operation
#' returns a list of these jobs sorted by job initiation time.
#' 
#' Amazon Glacier retains recently completed jobs for a period before
#' deleting them; however, it eventually removes completed jobs. The output
#' of completed jobs can be retrieved. Retaining completed jobs for a
#' period of time after they have completed enables you to get a job output
#' in the event you miss the job completion notification or your first
#' attempt to download it fails. For example, suppose you start an archive
#' retrieval job to download an archive. After the job completes, you start
#' to download the archive but encounter a network error. In this scenario,
#' you can retry and download the archive while the job exists.
#' 
#' The List Jobs operation supports pagination. You should always check the
#' response `Marker` field. If there are no more jobs to list, the `Marker`
#' field is set to `null`. If there are more jobs to list, the `Marker`
#' field is set to a non-null value, which you can use to continue the
#' pagination of the list. To return a list of jobs that begins at a
#' specific job, set the marker request parameter to the `Marker` value for
#' that job that you obtained from a previous List Jobs request.
#' 
#' You can set a maximum limit for the number of jobs returned in the
#' response by specifying the `limit` parameter in the request. The default
#' limit is 50. The number of jobs returned might be fewer than the limit,
#' but the number of returned jobs never exceeds the limit.
#' 
#' Additionally, you can filter the jobs list returned by specifying the
#' optional `statuscode` parameter or `completed` parameter, or both. Using
#' the `statuscode` parameter, you can specify to return only jobs that
#' match either the `InProgress`, `Succeeded`, or `Failed` status. Using
#' the `completed` parameter, you can specify to return only jobs that were
#' completed (`true`) or jobs that were not completed (`false`).
#' 
#' For more information about using this operation, see the documentation
#' for the underlying REST API [List
#' Jobs](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-jobs-get.html).
#'
#' @usage
#' glacier_list_jobs(accountId, vaultName, limit, marker, statuscode,
#'   completed)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param limit The maximum number of jobs to be returned. The default limit is 50. The
#' number of jobs returned might be fewer than the specified limit, but the
#' number of returned jobs never exceeds the limit.
#' @param marker An opaque string used for pagination. This value specifies the job at
#' which the listing of jobs should begin. Get the marker value from a
#' previous List Jobs response. You only need to include the marker if you
#' are continuing the pagination of results started in a previous List Jobs
#' request.
#' @param statuscode The type of job status to return. You can specify the following values:
#' `InProgress`, `Succeeded`, or `Failed`.
#' @param completed The state of the jobs to return. You can specify `true` or `false`.
#'
#' @section Request syntax:
#' ```
#' svc$list_jobs(
#'   accountId = "string",
#'   vaultName = "string",
#'   limit = "string",
#'   marker = "string",
#'   statuscode = "string",
#'   completed = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists jobs for the vault named my-vault.
#' \donttest{svc$list_jobs(
#'   accountId = "-",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_jobs
glacier_list_jobs <- function(accountId, vaultName, limit = NULL, marker = NULL, statuscode = NULL, completed = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/jobs",
    paginator = list()
  )
  input <- .glacier$list_jobs_input(accountId = accountId, vaultName = vaultName, limit = limit, marker = marker, statuscode = statuscode, completed = completed)
  output <- .glacier$list_jobs_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_jobs <- glacier_list_jobs

#' This operation lists in-progress multipart uploads for the specified
#' vault
#'
#' This operation lists in-progress multipart uploads for the specified
#' vault. An in-progress multipart upload is a multipart upload that has
#' been initiated by an InitiateMultipartUpload request, but has not yet
#' been completed or aborted. The list returned in the List Multipart
#' Upload response has no guaranteed order.
#' 
#' The List Multipart Uploads operation supports pagination. By default,
#' this operation returns up to 50 multipart uploads in the response. You
#' should always check the response for a `marker` at which to continue the
#' list; if there are no more items the `marker` is `null`. To return a
#' list of multipart uploads that begins at a specific upload, set the
#' `marker` request parameter to the value you obtained from a previous
#' List Multipart Upload request. You can also limit the number of uploads
#' returned in the response by specifying the `limit` parameter in the
#' request.
#' 
#' Note the difference between this operation and listing parts
#' (ListParts). The List Multipart Uploads operation lists all multipart
#' uploads for a vault and does not require a multipart upload ID. The List
#' Parts operation requires a multipart upload ID since parts are
#' associated with a single upload.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and the underlying REST API, see [Working
#' with Archives in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
#' and [List Multipart
#' Uploads](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-uploads.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_list_multipart_uploads(accountId, vaultName, marker, limit)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param marker An opaque string used for pagination. This value specifies the upload at
#' which the listing of uploads should begin. Get the marker value from a
#' previous List Uploads response. You need only include the marker if you
#' are continuing the pagination of results started in a previous List
#' Uploads request.
#' @param limit Specifies the maximum number of uploads returned in the response body.
#' If this value is not specified, the List Uploads operation returns up to
#' 50 uploads.
#'
#' @section Request syntax:
#' ```
#' svc$list_multipart_uploads(
#'   accountId = "string",
#'   vaultName = "string",
#'   marker = "string",
#'   limit = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists all the in-progress multipart uploads for the vault
#' # named examplevault.
#' \donttest{svc$list_multipart_uploads(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_multipart_uploads
glacier_list_multipart_uploads <- function(accountId, vaultName, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListMultipartUploads",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads",
    paginator = list()
  )
  input <- .glacier$list_multipart_uploads_input(accountId = accountId, vaultName = vaultName, marker = marker, limit = limit)
  output <- .glacier$list_multipart_uploads_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_multipart_uploads <- glacier_list_multipart_uploads

#' This operation lists the parts of an archive that have been uploaded in
#' a specific multipart upload
#'
#' This operation lists the parts of an archive that have been uploaded in
#' a specific multipart upload. You can make this request at any time
#' during an in-progress multipart upload before you complete the upload
#' (see CompleteMultipartUpload. List Parts returns an error for completed
#' uploads. The list returned in the List Parts response is sorted by part
#' range.
#' 
#' The List Parts operation supports pagination. By default, this operation
#' returns up to 50 uploaded parts in the response. You should always check
#' the response for a `marker` at which to continue the list; if there are
#' no more items the `marker` is `null`. To return a list of parts that
#' begins at a specific part, set the `marker` request parameter to the
#' value you obtained from a previous List Parts request. You can also
#' limit the number of parts returned in the response by specifying the
#' `limit` parameter in the request.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and the underlying REST API, see [Working
#' with Archives in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/working-with-archives.html)
#' and [List
#' Parts](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-multipart-list-parts.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_list_parts(accountId, vaultName, uploadId, marker, limit)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param marker An opaque string used for pagination. This value specifies the part at
#' which the listing of parts should begin. Get the marker value from the
#' response of a previous List Parts response. You need only include the
#' marker if you are continuing the pagination of results started in a
#' previous List Parts request.
#' @param limit The maximum number of parts to be returned. The default limit is 50. The
#' number of parts returned might be fewer than the specified limit, but
#' the number of returned parts never exceeds the limit.
#'
#' @section Request syntax:
#' ```
#' svc$list_parts(
#'   accountId = "string",
#'   vaultName = "string",
#'   uploadId = "string",
#'   marker = "string",
#'   limit = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists all the parts of a multipart upload.
#' \donttest{svc$list_parts(
#'   accountId = "-",
#'   uploadId = "OW2fM5iVylEpFEMM9_HpKowRapC3vn5sSL39_396UW9zLFUWVrnRHaPjUJddQ5OxSHVXjYtrN47NBZ...",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_parts
glacier_list_parts <- function(accountId, vaultName, uploadId, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListParts",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    paginator = list()
  )
  input <- .glacier$list_parts_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, marker = marker, limit = limit)
  output <- .glacier$list_parts_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_parts <- glacier_list_parts

#' This operation lists the provisioned capacity units for the specified
#' AWS account
#'
#' This operation lists the provisioned capacity units for the specified
#' AWS account.
#'
#' @usage
#' glacier_list_provisioned_capacity(accountId)
#'
#' @param accountId &#91;required&#93; The AWS account ID of the account that owns the vault. You can either
#' specify an AWS account ID or optionally a single \'-\' (hyphen), in
#' which case Amazon S3 Glacier uses the AWS account ID associated with the
#' credentials used to sign the request. If you use an account ID, don\'t
#' include any hyphens (\'-\') in the ID.
#'
#' @section Request syntax:
#' ```
#' svc$list_provisioned_capacity(
#'   accountId = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists the provisioned capacity units for an account.
#' \donttest{svc$list_provisioned_capacity(
#'   accountId = "-"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_provisioned_capacity
glacier_list_provisioned_capacity <- function(accountId) {
  op <- new_operation(
    name = "ListProvisionedCapacity",
    http_method = "GET",
    http_path = "/{accountId}/provisioned-capacity",
    paginator = list()
  )
  input <- .glacier$list_provisioned_capacity_input(accountId = accountId)
  output <- .glacier$list_provisioned_capacity_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_provisioned_capacity <- glacier_list_provisioned_capacity

#' This operation lists all the tags attached to a vault
#'
#' This operation lists all the tags attached to a vault. The operation
#' returns an empty map if there are no tags. For more information about
#' tags, see [Tagging Amazon S3 Glacier
#' Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
#'
#' @usage
#' glacier_list_tags_for_vault(accountId, vaultName)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_vault(
#'   accountId = "string",
#'   vaultName = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists all the tags attached to the vault examplevault.
#' \donttest{svc$list_tags_for_vault(
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_tags_for_vault
glacier_list_tags_for_vault <- function(accountId, vaultName) {
  op <- new_operation(
    name = "ListTagsForVault",
    http_method = "GET",
    http_path = "/{accountId}/vaults/{vaultName}/tags",
    paginator = list()
  )
  input <- .glacier$list_tags_for_vault_input(accountId = accountId, vaultName = vaultName)
  output <- .glacier$list_tags_for_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_tags_for_vault <- glacier_list_tags_for_vault

#' This operation lists all vaults owned by the calling user's account
#'
#' This operation lists all vaults owned by the calling user\'s account.
#' The list returned in the response is ASCII-sorted by vault name.
#' 
#' By default, this operation returns up to 10 items. If there are more
#' vaults to list, the response `marker` field contains the vault Amazon
#' Resource Name (ARN) at which to continue the list with a new List Vaults
#' request; otherwise, the `marker` field is `null`. To return a list of
#' vaults that begins at a specific vault, set the `marker` request
#' parameter to the vault ARN you obtained from a previous List Vaults
#' request. You can also limit the number of vaults returned in the
#' response by specifying the `limit` parameter in the request.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Retrieving
#' Vault Metadata in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/retrieving-vault-info.html)
#' and [List
#' Vaults](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vaults-get.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_list_vaults(accountId, marker, limit)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param marker A string used for pagination. The marker specifies the vault ARN after
#' which the listing of vaults should begin.
#' @param limit The maximum number of vaults to be returned. The default limit is 10.
#' The number of vaults returned might be fewer than the specified limit,
#' but the number of returned vaults never exceeds the limit.
#'
#' @section Request syntax:
#' ```
#' svc$list_vaults(
#'   accountId = "string",
#'   marker = "string",
#'   limit = "string"
#' )
#' ```
#'
#' @examples
#' # The example lists all vaults owned by the specified AWS account.
#' \donttest{svc$list_vaults(
#'   accountId = "-",
#'   limit = "",
#'   marker = ""
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_list_vaults
glacier_list_vaults <- function(accountId, marker = NULL, limit = NULL) {
  op <- new_operation(
    name = "ListVaults",
    http_method = "GET",
    http_path = "/{accountId}/vaults",
    paginator = list()
  )
  input <- .glacier$list_vaults_input(accountId = accountId, marker = marker, limit = limit)
  output <- .glacier$list_vaults_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$list_vaults <- glacier_list_vaults

#' This operation purchases a provisioned capacity unit for an AWS account
#'
#' This operation purchases a provisioned capacity unit for an AWS account.
#'
#' @usage
#' glacier_purchase_provisioned_capacity(accountId)
#'
#' @param accountId &#91;required&#93; The AWS account ID of the account that owns the vault. You can either
#' specify an AWS account ID or optionally a single \'-\' (hyphen), in
#' which case Amazon S3 Glacier uses the AWS account ID associated with the
#' credentials used to sign the request. If you use an account ID, don\'t
#' include any hyphens (\'-\') in the ID.
#'
#' @section Request syntax:
#' ```
#' svc$purchase_provisioned_capacity(
#'   accountId = "string"
#' )
#' ```
#'
#' @examples
#' # The example purchases provisioned capacity unit for an AWS account.
#' \donttest{svc$purchase_provisioned_capacity(
#'   accountId = "-"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_purchase_provisioned_capacity
glacier_purchase_provisioned_capacity <- function(accountId) {
  op <- new_operation(
    name = "PurchaseProvisionedCapacity",
    http_method = "POST",
    http_path = "/{accountId}/provisioned-capacity",
    paginator = list()
  )
  input <- .glacier$purchase_provisioned_capacity_input(accountId = accountId)
  output <- .glacier$purchase_provisioned_capacity_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$purchase_provisioned_capacity <- glacier_purchase_provisioned_capacity

#' This operation removes one or more tags from the set of tags attached to
#' a vault
#'
#' This operation removes one or more tags from the set of tags attached to
#' a vault. For more information about tags, see [Tagging Amazon S3 Glacier
#' Resources](https://docs.aws.amazon.com/amazonglacier/latest/dev/tagging.html).
#' This operation is idempotent. The operation will be successful, even if
#' there are no tags attached to the vault.
#'
#' @usage
#' glacier_remove_tags_from_vault(accountId, vaultName, TagKeys)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param TagKeys A list of tag keys. Each corresponding tag is removed from the vault.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_vault(
#'   accountId = "string",
#'   vaultName = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The example removes two tags from the vault named examplevault.
#' \donttest{svc$remove_tags_from_vault(
#'   TagKeys = list(
#'     "examplekey1",
#'     "examplekey2"
#'   ),
#'   accountId = "-",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_remove_tags_from_vault
glacier_remove_tags_from_vault <- function(accountId, vaultName, TagKeys = NULL) {
  op <- new_operation(
    name = "RemoveTagsFromVault",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/tags?operation=remove",
    paginator = list()
  )
  input <- .glacier$remove_tags_from_vault_input(accountId = accountId, vaultName = vaultName, TagKeys = TagKeys)
  output <- .glacier$remove_tags_from_vault_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$remove_tags_from_vault <- glacier_remove_tags_from_vault

#' This operation sets and then enacts a data retrieval policy in the
#' region specified in the PUT request
#'
#' This operation sets and then enacts a data retrieval policy in the
#' region specified in the PUT request. You can set one policy per region
#' for an AWS account. The policy is enacted within a few minutes of a
#' successful PUT operation.
#' 
#' The set policy operation does not affect retrieval jobs that were in
#' progress before the policy was enacted. For more information about data
#' retrieval policies, see [Amazon Glacier Data Retrieval
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/data-retrieval-policy.html).
#'
#' @usage
#' glacier_set_data_retrieval_policy(accountId, Policy)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID. This value must match the
#' AWS account ID associated with the credentials used to sign the request.
#' You can either specify an AWS account ID or optionally a single \'`-`\'
#' (hyphen), in which case Amazon Glacier uses the AWS account ID
#' associated with the credentials used to sign the request. If you specify
#' your account ID, do not include any hyphens (\'-\') in the ID.
#' @param Policy The data retrieval policy in JSON format.
#'
#' @section Request syntax:
#' ```
#' svc$set_data_retrieval_policy(
#'   accountId = "string",
#'   Policy = list(
#'     Rules = list(
#'       list(
#'         Strategy = "string",
#'         BytesPerHour = 123
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The example sets and then enacts a data retrieval policy.
#' \donttest{svc$set_data_retrieval_policy(
#'   Policy = list(
#'     Rules = list(
#'       list(
#'         BytesPerHour = 10737418240,
#'         Strategy = "BytesPerHour"
#'       )
#'     )
#'   ),
#'   accountId = "-"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_set_data_retrieval_policy
glacier_set_data_retrieval_policy <- function(accountId, Policy = NULL) {
  op <- new_operation(
    name = "SetDataRetrievalPolicy",
    http_method = "PUT",
    http_path = "/{accountId}/policies/data-retrieval",
    paginator = list()
  )
  input <- .glacier$set_data_retrieval_policy_input(accountId = accountId, Policy = Policy)
  output <- .glacier$set_data_retrieval_policy_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_data_retrieval_policy <- glacier_set_data_retrieval_policy

#' This operation configures an access policy for a vault and will
#' overwrite an existing policy
#'
#' This operation configures an access policy for a vault and will
#' overwrite an existing policy. To configure a vault access policy, send a
#' PUT request to the `access-policy` subresource of the vault. An access
#' policy is specific to a vault and is also called a vault subresource.
#' You can set one access policy per vault and the policy can be up to 20
#' KB in size. For more information about vault access policies, see
#' [Amazon Glacier Access Control with Vault Access
#' Policies](https://docs.aws.amazon.com/amazonglacier/latest/dev/vault-access-policy.html).
#'
#' @usage
#' glacier_set_vault_access_policy(accountId, vaultName, policy)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param policy The vault access policy as a JSON string.
#'
#' @section Request syntax:
#' ```
#' svc$set_vault_access_policy(
#'   accountId = "string",
#'   vaultName = "string",
#'   policy = list(
#'     Policy = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # The example configures an access policy for the vault named
#' # examplevault.
#' \donttest{svc$set_vault_access_policy(
#'   accountId = "-",
#'   policy = list(
#'     Policy = "{\"Version\":\"2012-10-17\",\"Statement\":[{\"Sid\":..."
#'   ),
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_set_vault_access_policy
glacier_set_vault_access_policy <- function(accountId, vaultName, policy = NULL) {
  op <- new_operation(
    name = "SetVaultAccessPolicy",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/access-policy",
    paginator = list()
  )
  input <- .glacier$set_vault_access_policy_input(accountId = accountId, vaultName = vaultName, policy = policy)
  output <- .glacier$set_vault_access_policy_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_vault_access_policy <- glacier_set_vault_access_policy

#' This operation configures notifications that will be sent when specific
#' events happen to a vault
#'
#' This operation configures notifications that will be sent when specific
#' events happen to a vault. By default, you don\'t get any notifications.
#' 
#' To configure vault notifications, send a PUT request to the
#' `notification-configuration` subresource of the vault. The request
#' should include a JSON document that provides an Amazon SNS topic and
#' specific events for which you want Amazon S3 Glacier to send
#' notifications to the topic.
#' 
#' Amazon SNS topics must grant permission to the vault to be allowed to
#' publish notifications to the topic. You can configure a vault to publish
#' a notification for the following vault events:
#' 
#' -   **ArchiveRetrievalCompleted** This event occurs when a job that was
#'     initiated for an archive retrieval is completed (InitiateJob). The
#'     status of the completed job can be \"Succeeded\" or \"Failed\". The
#'     notification sent to the SNS topic is the same output as returned
#'     from DescribeJob.
#' 
#' -   **InventoryRetrievalCompleted** This event occurs when a job that
#'     was initiated for an inventory retrieval is completed (InitiateJob).
#'     The status of the completed job can be \"Succeeded\" or \"Failed\".
#'     The notification sent to the SNS topic is the same output as
#'     returned from DescribeJob.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Configuring
#' Vault Notifications in Amazon S3
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/configuring-notifications.html)
#' and [Set Vault Notification
#' Configuration](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-vault-notifications-put.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_set_vault_notifications(accountId, vaultName,
#'   vaultNotificationConfig)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param vaultNotificationConfig Provides options for specifying notification configuration.
#'
#' @section Request syntax:
#' ```
#' svc$set_vault_notifications(
#'   accountId = "string",
#'   vaultName = "string",
#'   vaultNotificationConfig = list(
#'     SNSTopic = "string",
#'     Events = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # The example sets the examplevault notification configuration.
#' \donttest{svc$set_vault_notifications(
#'   accountId = "-",
#'   vaultName = "examplevault",
#'   vaultNotificationConfig = list(
#'     Events = list(
#'       "ArchiveRetrievalCompleted",
#'       "InventoryRetrievalCompleted"
#'     ),
#'     SNSTopic = "arn:aws:sns:us-west-2:012345678901:mytopic"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_set_vault_notifications
glacier_set_vault_notifications <- function(accountId, vaultName, vaultNotificationConfig = NULL) {
  op <- new_operation(
    name = "SetVaultNotifications",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/notification-configuration",
    paginator = list()
  )
  input <- .glacier$set_vault_notifications_input(accountId = accountId, vaultName = vaultName, vaultNotificationConfig = vaultNotificationConfig)
  output <- .glacier$set_vault_notifications_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$set_vault_notifications <- glacier_set_vault_notifications

#' This operation adds an archive to a vault
#'
#' This operation adds an archive to a vault. This is a synchronous
#' operation, and for a successful upload, your data is durably persisted.
#' Amazon S3 Glacier returns the archive ID in the `x-amz-archive-id`
#' header of the response.
#' 
#' You must use the archive ID to access your data in Amazon S3 Glacier.
#' After you upload an archive, you should save the archive ID returned so
#' that you can retrieve or delete the archive later. Besides saving the
#' archive ID, you can also index it and give it a friendly name to allow
#' for better searching. You can also use the optional archive description
#' field to specify how the archive is referred to in an external index of
#' archives, such as you might create in Amazon DynamoDB. You can also get
#' the vault inventory to obtain a list of archive IDs in a vault. For more
#' information, see InitiateJob.
#' 
#' You must provide a SHA256 tree hash of the data you are uploading. For
#' information about computing a SHA256 tree hash, see [Computing
#' Checksums](https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
#' 
#' You can optionally specify an archive description of up to 1,024
#' printable ASCII characters. You can get the archive description when you
#' either retrieve the archive or get the vault inventory. For more
#' information, see InitiateJob. Amazon Glacier does not interpret the
#' description in any way. An archive description does not need to be
#' unique. You cannot use the description to retrieve or sort the archive
#' list.
#' 
#' Archives are immutable. After you upload an archive, you cannot edit the
#' archive or its description.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Uploading an
#' Archive in Amazon
#' Glacier](https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-an-archive.html)
#' and [Upload
#' Archive](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-archive-post.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_upload_archive(vaultName, accountId, archiveDescription,
#'   checksum, body)
#'
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param archiveDescription The optional description of the archive you are uploading.
#' @param checksum The SHA256 tree hash of the data being uploaded.
#' @param body The data to upload.
#'
#' @section Request syntax:
#' ```
#' svc$upload_archive(
#'   vaultName = "string",
#'   accountId = "string",
#'   archiveDescription = "string",
#'   checksum = "string",
#'   body = raw
#' )
#' ```
#'
#' @examples
#' # The example adds an archive to a vault.
#' \donttest{svc$upload_archive(
#'   accountId = "-",
#'   archiveDescription = "",
#'   body = "example-data-to-upload",
#'   checksum = "",
#'   vaultName = "my-vault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_upload_archive
glacier_upload_archive <- function(vaultName, accountId, archiveDescription = NULL, checksum = NULL, body = NULL) {
  op <- new_operation(
    name = "UploadArchive",
    http_method = "POST",
    http_path = "/{accountId}/vaults/{vaultName}/archives",
    paginator = list()
  )
  input <- .glacier$upload_archive_input(vaultName = vaultName, accountId = accountId, archiveDescription = archiveDescription, checksum = checksum, body = body)
  output <- .glacier$upload_archive_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$upload_archive <- glacier_upload_archive

#' This operation uploads a part of an archive
#'
#' This operation uploads a part of an archive. You can upload archive
#' parts in any order. You can also upload them in parallel. You can upload
#' up to 10,000 parts for a multipart upload.
#' 
#' Amazon Glacier rejects your upload part request if any of the following
#' conditions is true:
#' 
#' -   **SHA256 tree hash does not match**To ensure that part data is not
#'     corrupted in transmission, you compute a SHA256 tree hash of the
#'     part and include it in your request. Upon receiving the part data,
#'     Amazon S3 Glacier also computes a SHA256 tree hash. If these hash
#'     values don\'t match, the operation fails. For information about
#'     computing a SHA256 tree hash, see [Computing
#'     Checksums](https://docs.aws.amazon.com/amazonglacier/latest/dev/checksum-calculations.html).
#' 
#' -   **Part size does not match**The size of each part except the last
#'     must match the size specified in the corresponding
#'     InitiateMultipartUpload request. The size of the last part must be
#'     the same size as, or smaller than, the specified size.
#' 
#'     If you upload a part whose size is smaller than the part size you
#'     specified in your initiate multipart upload request and that part is
#'     not the last part, then the upload part request will succeed.
#'     However, the subsequent Complete Multipart Upload request will fail.
#' 
#' -   **Range does not align**The byte range value in the request does not
#'     align with the part size specified in the corresponding initiate
#'     request. For example, if you specify a part size of 4194304 bytes (4
#'     MB), then 0 to 4194303 bytes (4 MB - 1) and 4194304 (4 MB) to
#'     8388607 (8 MB - 1) are valid part ranges. However, if you set a
#'     range value of 2 MB to 6 MB, the range does not align with the part
#'     size and the upload will fail.
#' 
#' This operation is idempotent. If you upload the same part multiple
#' times, the data included in the most recent request overwrites the
#' previously uploaded data.
#' 
#' An AWS account has full permission to perform all operations (actions).
#' However, AWS Identity and Access Management (IAM) users don\'t have any
#' permissions by default. You must grant them explicit permission to
#' perform specific actions. For more information, see [Access Control
#' Using AWS Identity and Access Management
#' (IAM)](https://docs.aws.amazon.com/amazonglacier/latest/dev/using-iam-with-amazon-glacier.html).
#' 
#' For conceptual information and underlying REST API, see [Uploading Large
#' Archives in Parts (Multipart
#' Upload)](https://docs.aws.amazon.com/amazonglacier/latest/dev/uploading-archive-mpu.html)
#' and [Upload
#' Part](https://docs.aws.amazon.com/amazonglacier/latest/dev/api-upload-part.html)
#' in the *Amazon Glacier Developer Guide*.
#'
#' @usage
#' glacier_upload_multipart_part(accountId, vaultName, uploadId, checksum,
#'   range, body)
#'
#' @param accountId &#91;required&#93; The `AccountId` value is the AWS account ID of the account that owns the
#' vault. You can either specify an AWS account ID or optionally a single
#' \'`-`\' (hyphen), in which case Amazon S3 Glacier uses the AWS account
#' ID associated with the credentials used to sign the request. If you use
#' an account ID, do not include any hyphens (\'-\') in the ID.
#' @param vaultName &#91;required&#93; The name of the vault.
#' @param uploadId &#91;required&#93; The upload ID of the multipart upload.
#' @param checksum The SHA256 tree hash of the data being uploaded.
#' @param range Identifies the range of bytes in the assembled archive that will be
#' uploaded in this part. Amazon S3 Glacier uses this information to
#' assemble the archive in the proper sequence. The format of this header
#' follows RFC 2616. An example header is Content-Range:bytes 0-4194303/\*.
#' @param body The data to upload.
#'
#' @section Request syntax:
#' ```
#' svc$upload_multipart_part(
#'   accountId = "string",
#'   vaultName = "string",
#'   uploadId = "string",
#'   checksum = "string",
#'   range = "string",
#'   body = raw
#' )
#' ```
#'
#' @examples
#' # The example uploads the first 1 MiB (1024 x 1024 bytes) part of an
#' # archive.
#' \donttest{svc$upload_multipart_part(
#'   accountId = "-",
#'   body = "part1",
#'   checksum = "c06f7cd4baacb087002a99a5f48bf953",
#'   range = "bytes 0-1048575/*",
#'   uploadId = "19gaRezEXAMPLES6Ry5YYdqthHOC_kGRCT03L9yetr220UmPtBYKk-OssZtLqyFu7sY1_lR7vgFuJV...",
#'   vaultName = "examplevault"
#' )}
#'
#' @keywords internal
#'
#' @rdname glacier_upload_multipart_part
glacier_upload_multipart_part <- function(accountId, vaultName, uploadId, checksum = NULL, range = NULL, body = NULL) {
  op <- new_operation(
    name = "UploadMultipartPart",
    http_method = "PUT",
    http_path = "/{accountId}/vaults/{vaultName}/multipart-uploads/{uploadId}",
    paginator = list()
  )
  input <- .glacier$upload_multipart_part_input(accountId = accountId, vaultName = vaultName, uploadId = uploadId, checksum = checksum, range = range, body = body)
  output <- .glacier$upload_multipart_part_output()
  config <- get_config()
  svc <- .glacier$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.glacier$operations$upload_multipart_part <- glacier_upload_multipart_part
