% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_list_jobs}
\alias{s3control_list_jobs}
\title{Lists current jobs and jobs that have ended within the last 30 days for
the AWS account making the request}
\usage{
s3control_list_jobs(AccountId, JobStatuses, NextToken, MaxResults)
}
\arguments{
\item{AccountId}{[required]}

\item{JobStatuses}{The \code{List Jobs} request returns jobs that match the statuses listed in
this element.}

\item{NextToken}{A pagination token to request the next page of results. Use the token
that Amazon S3 returned in the \code{NextToken} element of the
\code{ListJobsResult} from the previous \code{List Jobs} request.}

\item{MaxResults}{The maximum number of jobs that Amazon S3 will include in the
\code{List Jobs} response. If there are more jobs than this number, the
response will include a pagination token in the \code{NextToken} field to
enable you to retrieve the next page of results.}
}
\description{
Lists current jobs and jobs that have ended within the last 30 days for
the AWS account making the request.
}
\section{Request syntax}{
\preformatted{svc$list_jobs(
  AccountId = "string",
  JobStatuses = list(
    "Active"|"Cancelled"|"Cancelling"|"Complete"|"Completing"|"Failed"|"Failing"|"New"|"Paused"|"Pausing"|"Preparing"|"Ready"|"Suspended"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
