% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_get_access_point}
\alias{s3control_get_access_point}
\title{Returns configuration information about the specified access point}
\usage{
s3control_get_access_point(AccountId, Name)
}
\arguments{
\item{AccountId}{[required] The account ID for the account that owns the specified access point.}

\item{Name}{[required] The name of the access point whose configuration information you want to
retrieve.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the access point accessed in the format
\verb{arn:aws:s3-outposts:&lt;Region&gt;:&lt;account-id&gt;:outpost/&lt;outpost-id&gt;/accesspoint/&lt;my-accesspoint-name&gt;}.
For example, to access the access point \code{reports-ap} through outpost
\code{my-outpost} owned by account \code{123456789012} in Region \code{us-west-2}, use
the URL encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap}.
The value must be URL encoded.}
}
\description{
Returns configuration information about the specified access point.

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_GetAccessPoint.html#API_control_GetAccessPoint_Examples}{Examples}
section.

The following actions are related to \code{GetAccessPoint}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_CreateAccessPoint.html}{CreateAccessPoint}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_DeleteAccessPoint.html}{DeleteAccessPoint}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_ListAccessPoints.html}{ListAccessPoints}
}
}
\section{Request syntax}{
\preformatted{svc$get_access_point(
  AccountId = "string",
  Name = "string"
)
}
}

\keyword{internal}
