% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/storagegateway_operations.R
\name{storagegateway_update_nfs_file_share}
\alias{storagegateway_update_nfs_file_share}
\title{Updates a Network File System (NFS) file share}
\usage{
storagegateway_update_nfs_file_share(FileShareARN, KMSEncrypted, KMSKey,
  NFSFileShareDefaults, DefaultStorageClass, ObjectACL, ClientList,
  Squash, ReadOnly, GuessMIMETypeEnabled, RequesterPays)
}
\arguments{
\item{FileShareARN}{[required] The Amazon Resource Name (ARN) of the file share to be updated.}

\item{KMSEncrypted}{True to use Amazon S3 server side encryption with your own AWS KMS key,
or false to use a key managed by Amazon S3. Optional.}

\item{KMSKey}{The Amazon Resource Name (ARN) of the AWS KMS key used for Amazon S3
server side encryption. This value can only be set when KMSEncrypted is
true. Optional.}

\item{NFSFileShareDefaults}{The default values for the file share. Optional.}

\item{DefaultStorageClass}{The default storage class for objects put into an Amazon S3 bucket by
the file gateway. Possible values are \code{S3_STANDARD}, \code{S3_STANDARD_IA},
or \code{S3_ONEZONE_IA}. If this field is not populated, the default value
\code{S3_STANDARD} is used. Optional.}

\item{ObjectACL}{A value that sets the access control list permission for objects in the
S3 bucket that a file gateway puts objects into. The default value is
"private".}

\item{ClientList}{The list of clients that are allowed to access the file gateway. The
list must contain either valid IP addresses or valid CIDR blocks.}

\item{Squash}{The user mapped to anonymous user. Valid options are the following:
\itemize{
\item \code{RootSquash} - Only root is mapped to anonymous user.
\item \code{NoSquash} - No one is mapped to anonymous user
\item \code{AllSquash} - Everyone is mapped to anonymous user.
}}

\item{ReadOnly}{A value that sets the write status of a file share. This value is true
if the write status is read-only, and otherwise false.}

\item{GuessMIMETypeEnabled}{A value that enables guessing of the MIME type for uploaded objects
based on file extensions. Set this value to true to enable MIME type
guessing, and otherwise to false. The default value is true.}

\item{RequesterPays}{A value that sets the access control list permission for objects in the
Amazon S3 bucket that a file gateway puts objects into. The default
value is \code{private}.}
}
\description{
Updates a Network File System (NFS) file share. This operation is only
supported in the file gateway type.
}
\details{
To leave a file share field unchanged, set the corresponding input field
to null.

Updates the following file share setting:
\itemize{
\item Default storage class for your S3 bucket
\item Metadata defaults for your S3 bucket
\item Allowed NFS clients for your file share
\item Squash settings
\item Write status of your file share
}

To leave a file share field unchanged, set the corresponding input field
to null. This operation is only supported in file gateways.
}
\section{Request syntax}{
\preformatted{svc$update_nfs_file_share(
  FileShareARN = "string",
  KMSEncrypted = TRUE|FALSE,
  KMSKey = "string",
  NFSFileShareDefaults = list(
    FileMode = "string",
    DirectoryMode = "string",
    GroupId = 123,
    OwnerId = 123
  ),
  DefaultStorageClass = "string",
  ObjectACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"bucket-owner-read"|"bucket-owner-full-control"|"aws-exec-read",
  ClientList = list(
    "string"
  ),
  Squash = "string",
  ReadOnly = TRUE|FALSE,
  GuessMIMETypeEnabled = TRUE|FALSE,
  RequesterPays = TRUE|FALSE
)
}
}

\keyword{internal}
