% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanroomsml_operations.R
\name{cleanroomsml_start_audience_generation_job}
\alias{cleanroomsml_start_audience_generation_job}
\title{Information necessary to start the audience generation job}
\usage{
cleanroomsml_start_audience_generation_job(
  name,
  configuredAudienceModelArn,
  seedAudience,
  includeSeedInOutput = NULL,
  collaborationId = NULL,
  description = NULL,
  tags = NULL
)
}
\arguments{
\item{name}{[required] The name of the audience generation job.}

\item{configuredAudienceModelArn}{[required] The Amazon Resource Name (ARN) of the configured audience model that is
used for this audience generation job.}

\item{seedAudience}{[required] The seed audience that is used to generate the audience.}

\item{includeSeedInOutput}{Whether the seed audience is included in the audience generation output.}

\item{collaborationId}{The identifier of the collaboration that contains the audience
generation job.}

\item{description}{The description of the audience generation job.}

\item{tags}{The optional metadata that you apply to the resource to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use aws:, AWS:, or any upper or lowercase combination of such
as a prefix for keys as it is reserved for AWS use. You cannot edit
or delete tag keys with this prefix. Values can have this prefix. If
a tag value has aws as its prefix but the key does not, then Clean
Rooms ML considers it to be a user tag and will count against the
limit of 50 tags. Tags with only the key prefix of aws do not count
against your tags per resource limit.
}}
}
\description{
Information necessary to start the audience generation job.

See \url{https://www.paws-r-sdk.com/docs/cleanroomsml_start_audience_generation_job/} for full documentation.
}
\keyword{internal}
