% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cleanroomsml_operations.R
\name{cleanroomsml_create_configured_model_algorithm_association}
\alias{cleanroomsml_create_configured_model_algorithm_association}
\title{Associates a configured model algorithm to a collaboration for use by
any member of the collaboration}
\usage{
cleanroomsml_create_configured_model_algorithm_association(
  membershipIdentifier,
  configuredModelAlgorithmArn,
  name,
  description = NULL,
  privacyConfiguration = NULL,
  tags = NULL
)
}
\arguments{
\item{membershipIdentifier}{[required] The membership ID of the member who is associating this configured model
algorithm.}

\item{configuredModelAlgorithmArn}{[required] The Amazon Resource Name (ARN) of the configured model algorithm that
you want to associate.}

\item{name}{[required] The name of the configured model algorithm association.}

\item{description}{The description of the configured model algorithm association.}

\item{privacyConfiguration}{Specifies the privacy configuration information for the configured model
algorithm association. This information includes the maximum data size
that can be exported.}

\item{tags}{The optional metadata that you apply to the resource to help you
categorize and organize them. Each tag consists of a key and an optional
value, both of which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50.
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8.
\item Maximum value length - 256 Unicode characters in UTF-8.
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . _ : / @.
\item Tag keys and values are case sensitive.
\item Do not use aws:, AWS:, or any upper or lowercase combination of such
as a prefix for keys as it is reserved for AWS use. You cannot edit
or delete tag keys with this prefix. Values can have this prefix. If
a tag value has aws as its prefix but the key does not, then Clean
Rooms ML considers it to be a user tag and will count against the
limit of 50 tags. Tags with only the key prefix of aws do not count
against your tags per resource limit.
}}
}
\description{
Associates a configured model algorithm to a collaboration for use by any member of the collaboration.

See \url{https://www.paws-r-sdk.com/docs/cleanroomsml_create_configured_model_algorithm_association/} for full documentation.
}
\keyword{internal}
