% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verifiedpermissions_operations.R
\name{verifiedpermissions_is_authorized}
\alias{verifiedpermissions_is_authorized}
\title{Makes an authorization decision about a service request described in the
parameters}
\usage{
verifiedpermissions_is_authorized(
  policyStoreId,
  principal = NULL,
  action = NULL,
  resource = NULL,
  context = NULL,
  entities = NULL
)
}
\arguments{
\item{policyStoreId}{[required] Specifies the ID of the policy store. Policies in this policy store will
be used to make an authorization decision for the input.}

\item{principal}{Specifies the principal for which the authorization decision is to be
made.}

\item{action}{Specifies the requested action to be authorized. For example, is the
principal authorized to perform this action on the resource?}

\item{resource}{Specifies the resource for which the authorization decision is to be
made.}

\item{context}{Specifies additional context that can be used to make more granular
authorization decisions.}

\item{entities}{Specifies the list of resources and principals and their associated
attributes that Verified Permissions can examine when evaluating the
policies.

You can include only principal and resource entities in this parameter;
you can't include actions. You must specify actions in the schema.}
}
\description{
Makes an authorization decision about a service request described in the parameters. The information in the parameters can also define additional context that Verified Permissions can include in the evaluation. The request is evaluated against all matching policies in the specified policy store. The result of the decision is either \code{Allow} or \code{Deny}, along with a list of the policies that resulted in the decision.

See \url{https://www.paws-r-sdk.com/docs/verifiedpermissions_is_authorized/} for full documentation.
}
\keyword{internal}
