% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_list_discovered_resources}
\alias{fms_list_discovered_resources}
\title{Returns an array of resources in the organization's accounts that are
available to be associated with a resource set}
\usage{
fms_list_discovered_resources(
  MemberAccountIds,
  ResourceType,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{MemberAccountIds}{[required] The Amazon Web Services account IDs to discover resources in. Only one
account is supported per request. The account must be a member of your
organization.}

\item{ResourceType}{[required] The type of resources to discover.}

\item{MaxResults}{The maximum number of objects that you want Firewall Manager to return
for this request. If more objects are available, in the response,
Firewall Manager provides a \code{NextToken} value that you can use in a
subsequent call to get the next batch of objects.}

\item{NextToken}{When you request a list of objects with a \code{MaxResults} setting, if the
number of objects that are still available for retrieval exceeds the
maximum you requested, Firewall Manager returns a \code{NextToken} value in
the response. To retrieve the next batch of objects, use the token
returned from the prior request in your next request.}
}
\description{
Returns an array of resources in the organization's accounts that are available to be associated with a resource set.

See \url{https://www.paws-r-sdk.com/docs/fms_list_discovered_resources/} for full documentation.
}
\keyword{internal}
