% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_get_user_attribute_verification_code}
\alias{cognitoidentityprovider_get_user_attribute_verification_code}
\title{Generates a user attribute verification code for the specified attribute
name}
\usage{
cognitoidentityprovider_get_user_attribute_verification_code(
  AccessToken,
  AttributeName,
  ClientMetadata = NULL
)
}
\arguments{
\item{AccessToken}{[required] A non-expired access token for the user whose attribute verification
code you want to generate.}

\item{AttributeName}{[required] The attribute name returned by the server response to get the user
attribute verification code.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

You create custom workflows by assigning Lambda functions to user pool
triggers. When you use the GetUserAttributeVerificationCode API action,
Amazon Cognito invokes the function that is assigned to the \emph{custom
message} trigger. When Amazon Cognito invokes this function, it passes a
JSON payload, which the function receives as input. This payload
contains a \code{clientMetadata} attribute, which provides the data that you
assigned to the ClientMetadata parameter in your
GetUserAttributeVerificationCode request. In your function code in
Lambda, you can process the \code{clientMetadata} value to enhance your
workflow for your specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the ClientMetadata parameter, remember that Amazon Cognito
won't do the following:
\itemize{
\item Store the ClientMetadata value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the ClientMetadata parameter serves no purpose.
\item Validate the ClientMetadata value.
\item Encrypt the ClientMetadata value. Don't use Amazon Cognito to
provide sensitive information.
}}
}
\description{
Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user_attribute_verification_code/} for full documentation.
}
\keyword{internal}
