% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_accept_resource_share_invitation}
\alias{ram_accept_resource_share_invitation}
\title{Accepts an invitation to a resource share from another Amazon Web
Services account}
\usage{
ram_accept_resource_share_invitation(
  resourceShareInvitationArn,
  clientToken = NULL
)
}
\arguments{
\item{resourceShareInvitationArn}{[required] The \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Name (ARN)}
of the invitation that you want to accept.}

\item{clientToken}{Specifies a unique, case-sensitive identifier that you provide to ensure
the idempotency of the request. This lets you safely retry the request
without accidentally performing the same operation a second time.
Passing the same value to a later call to an operation requires that you
also pass the same value for all other parameters. We recommend that you
use a \href{https://en.wikipedia.org/wiki/Universally_unique_identifier}{UUID type of value.}.

If you don't provide this value, then Amazon Web Services generates a
random one for you.

If you retry the operation with the same \code{ClientToken}, but with
different parameters, the retry fails with an
\code{IdempotentParameterMismatch} error.}
}
\description{
Accepts an invitation to a resource share from another Amazon Web Services account. After you accept the invitation, the resources included in the resource share are available to interact with in the relevant Amazon Web Services Management Consoles and tools.

See \url{https://www.paws-r-sdk.com/docs/ram_accept_resource_share_invitation/} for full documentation.
}
\keyword{internal}
