% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_tag_user}
\alias{iam_tag_user}
\title{Adds one or more tags to an IAM user}
\usage{
iam_tag_user(UserName, Tags)
}
\arguments{
\item{UserName}{[required] The name of the IAM user to which you want to add tags.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Tags}{[required] The list of tags that you want to attach to the IAM user. Each tag
consists of a key name and an associated value.}
}
\description{
Adds one or more tags to an IAM user. If a tag with the same key name already exists, then that tag is overwritten with the new value.

See \url{https://www.paws-r-sdk.com/docs/iam_tag_user/} for full documentation.
}
\keyword{internal}
