% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_update_classification_job}
\alias{macie2_update_classification_job}
\title{Changes the status of a classification job}
\usage{
macie2_update_classification_job(jobId, jobStatus)
}
\arguments{
\item{jobId}{[required] The unique identifier for the classification job.}

\item{jobStatus}{[required] The new status for the job. Valid values are:
\itemize{
\item CANCELLED - Stops the job permanently and cancels it. This value is
valid only if the job's current status is IDLE, PAUSED, RUNNING, or
USER_PAUSED.

If you specify this value and the job's current status is RUNNING,
Amazon Macie immediately begins to stop all processing tasks for the
job. You can't resume or restart a job after you cancel it.
\item RUNNING - Resumes the job. This value is valid only if the job's
current status is USER_PAUSED.

If you paused the job while it was actively running and you specify
this value less than 30 days after you paused the job, Macie
immediately resumes processing from the point where you paused the
job. Otherwise, Macie resumes the job according to the schedule and
other settings for the job.
\item USER_PAUSED - Pauses the job temporarily. This value is valid only
if the job's current status is IDLE, PAUSED, or RUNNING. If you
specify this value and the job's current status is RUNNING, Macie
immediately begins to pause all processing tasks for the job.

If you pause a one-time job and you don't resume it within 30 days,
the job expires and Macie cancels the job. If you pause a recurring
job when its status is RUNNING and you don't resume it within 30
days, the job run expires and Macie cancels the run. To check the
expiration date, refer to the UserPausedDetails.jobExpiresAt
property.
}}
}
\description{
Changes the status of a classification job.

See \url{https://www.paws-r-sdk.com/docs/macie2_update_classification_job/} for full documentation.
}
\keyword{internal}
