# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include cognitoidentityprovider_service.R
NULL

#' Adds additional user attributes to the user pool schema
#'
#' @description
#' Adds additional user attributes to the user pool schema.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_add_custom_attributes/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_add_custom_attributes/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to add custom
#' attributes.
#' @param CustomAttributes &#91;required&#93; An array of custom attributes, such as Mutable and Name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_add_custom_attributes
cognitoidentityprovider_add_custom_attributes <- function(UserPoolId, CustomAttributes) {
  op <- new_operation(
    name = "AddCustomAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$add_custom_attributes_input(UserPoolId = UserPoolId, CustomAttributes = CustomAttributes)
  output <- .cognitoidentityprovider$add_custom_attributes_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$add_custom_attributes <- cognitoidentityprovider_add_custom_attributes

#' Adds the specified user to the specified group
#'
#' @description
#' Adds the specified user to the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_add_user_to_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_add_user_to_group/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Username &#91;required&#93; The username for the user.
#' @param GroupName &#91;required&#93; The group name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_add_user_to_group
cognitoidentityprovider_admin_add_user_to_group <- function(UserPoolId, Username, GroupName) {
  op <- new_operation(
    name = "AdminAddUserToGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_add_user_to_group_input(UserPoolId = UserPoolId, Username = Username, GroupName = GroupName)
  output <- .cognitoidentityprovider$admin_add_user_to_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_add_user_to_group <- cognitoidentityprovider_admin_add_user_to_group

#' Confirms user registration as an admin without using a confirmation code
#'
#' @description
#' Confirms user registration as an admin without using a confirmation code. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_confirm_sign_up/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_confirm_sign_up/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for which you want to confirm user registration.
#' @param Username &#91;required&#93; The user name for which you want to confirm user registration.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' If your user pool configuration includes triggers, the
#' AdminConfirmSignUp API action invokes the Lambda function that is
#' specified for the *post confirmation* trigger. When Amazon Cognito
#' invokes this function, it passes a JSON payload, which the function
#' receives as input. In this payload, the `clientMetadata` attribute
#' provides the data that you assigned to the ClientMetadata parameter in
#' your AdminConfirmSignUp request. In your function code in Lambda, you
#' can process the ClientMetadata value to enhance your workflow for your
#' specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_confirm_sign_up
cognitoidentityprovider_admin_confirm_sign_up <- function(UserPoolId, Username, ClientMetadata = NULL) {
  op <- new_operation(
    name = "AdminConfirmSignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_confirm_sign_up_input(UserPoolId = UserPoolId, Username = Username, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$admin_confirm_sign_up_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_confirm_sign_up <- cognitoidentityprovider_admin_confirm_sign_up

#' Creates a new user in the specified user pool
#'
#' @description
#' Creates a new user in the specified user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_create_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_create_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where the user will be created.
#' @param Username &#91;required&#93; The username for the user. Must be unique within the user pool. Must be
#' a UTF-8 string between 1 and 128 characters. After the user is created,
#' the username can't be changed.
#' @param UserAttributes An array of name-value pairs that contain user attributes and attribute
#' values to be set for the user to be created. You can create a user
#' without specifying any attributes other than `Username`. However, any
#' attributes that you specify as required (when creating a user pool or in
#' the **Attributes** tab of the console) either you should supply (in your
#' call to
#' [`admin_create_user`][cognitoidentityprovider_admin_create_user]) or the
#' user should supply (when they sign up in response to your welcome
#' message).
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' 
#' To send a message inviting the user to sign up, you must specify the
#' user's email address or phone number. You can do this in your call to
#' AdminCreateUser or in the **Users** tab of the Amazon Cognito console
#' for managing your user pools.
#' 
#' In your call to
#' [`admin_create_user`][cognitoidentityprovider_admin_create_user], you
#' can set the `email_verified` attribute to `True`, and you can set the
#' `phone_number_verified` attribute to `True`. You can also do this by
#' calling
#' [`admin_update_user_attributes`][cognitoidentityprovider_admin_update_user_attributes].
#' 
#' -   **email**: The email address of the user to whom the message that
#'     contains the code and username will be sent. Required if the
#'     `email_verified` attribute is set to `True`, or if `"EMAIL"` is
#'     specified in the `DesiredDeliveryMediums` parameter.
#' 
#' -   **phone_number**: The phone number of the user to whom the message
#'     that contains the code and username will be sent. Required if the
#'     `phone_number_verified` attribute is set to `True`, or if `"SMS"` is
#'     specified in the `DesiredDeliveryMediums` parameter.
#' @param ValidationData The user's validation data. This is an array of name-value pairs that
#' contain user attributes and attribute values that you can use for custom
#' validation, such as restricting the types of user accounts that can be
#' registered. For example, you might choose to allow or disallow user
#' sign-up based on the user's domain.
#' 
#' To configure custom validation, you must create a Pre Sign-up Lambda
#' trigger for the user pool as described in the Amazon Cognito Developer
#' Guide. The Lambda trigger receives the validation data and uses it in
#' the validation process.
#' 
#' The user's validation data isn't persisted.
#' @param TemporaryPassword The user's temporary password. This password must conform to the
#' password policy that you specified when you created the user pool.
#' 
#' The temporary password is valid only once. To complete the Admin Create
#' User flow, the user must enter the temporary password in the sign-in
#' page, along with a new password to be used in all future sign-ins.
#' 
#' This parameter isn't required. If you don't specify a value, Amazon
#' Cognito generates one for you.
#' 
#' The temporary password can only be used until the user account
#' expiration limit that you specified when you created the user pool. To
#' reset the account after that time limit, you must call
#' [`admin_create_user`][cognitoidentityprovider_admin_create_user] again,
#' specifying `"RESEND"` for the `MessageAction` parameter.
#' @param ForceAliasCreation This parameter is used only if the `phone_number_verified` or
#' `email_verified` attribute is set to `True`. Otherwise, it is ignored.
#' 
#' If this parameter is set to `True` and the phone number or email address
#' specified in the UserAttributes parameter already exists as an alias
#' with a different user, the API call will migrate the alias from the
#' previous user to the newly created user. The previous user will no
#' longer be able to log in using that alias.
#' 
#' If this parameter is set to `False`, the API throws an
#' `AliasExistsException` error if the alias already exists. The default
#' value is `False`.
#' @param MessageAction Set to `RESEND` to resend the invitation message to a user that already
#' exists and reset the expiration limit on the user's account. Set to
#' `SUPPRESS` to suppress sending the message. You can specify only one
#' value.
#' @param DesiredDeliveryMediums Specify `"EMAIL"` if email will be used to send the welcome message.
#' Specify `"SMS"` if the phone number will be used. The default value is
#' `"SMS"`. You can specify more than one value.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the AdminCreateUser API action, Amazon Cognito
#' invokes the function that is assigned to the *pre sign-up* trigger. When
#' Amazon Cognito invokes this function, it passes a JSON payload, which
#' the function receives as input. This payload contains a `clientMetadata`
#' attribute, which provides the data that you assigned to the
#' ClientMetadata parameter in your AdminCreateUser request. In your
#' function code in Lambda, you can process the `clientMetadata` value to
#' enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_create_user
cognitoidentityprovider_admin_create_user <- function(UserPoolId, Username, UserAttributes = NULL, ValidationData = NULL, TemporaryPassword = NULL, ForceAliasCreation = NULL, MessageAction = NULL, DesiredDeliveryMediums = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "AdminCreateUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_create_user_input(UserPoolId = UserPoolId, Username = Username, UserAttributes = UserAttributes, ValidationData = ValidationData, TemporaryPassword = TemporaryPassword, ForceAliasCreation = ForceAliasCreation, MessageAction = MessageAction, DesiredDeliveryMediums = DesiredDeliveryMediums, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$admin_create_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_create_user <- cognitoidentityprovider_admin_create_user

#' Deletes a user as an administrator
#'
#' @description
#' Deletes a user as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_delete_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_delete_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete the user.
#' @param Username &#91;required&#93; The user name of the user you want to delete.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_delete_user
cognitoidentityprovider_admin_delete_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminDeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_delete_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_delete_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_delete_user <- cognitoidentityprovider_admin_delete_user

#' Deletes the user attributes in a user pool as an administrator
#'
#' @description
#' Deletes the user attributes in a user pool as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_delete_user_attributes/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_delete_user_attributes/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete user
#' attributes.
#' @param Username &#91;required&#93; The user name of the user from which you would like to delete
#' attributes.
#' @param UserAttributeNames &#91;required&#93; An array of strings representing the user attribute names you want to
#' delete.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_delete_user_attributes
cognitoidentityprovider_admin_delete_user_attributes <- function(UserPoolId, Username, UserAttributeNames) {
  op <- new_operation(
    name = "AdminDeleteUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_delete_user_attributes_input(UserPoolId = UserPoolId, Username = Username, UserAttributeNames = UserAttributeNames)
  output <- .cognitoidentityprovider$admin_delete_user_attributes_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_delete_user_attributes <- cognitoidentityprovider_admin_delete_user_attributes

#' Prevents the user from signing in with the specified external (SAML or
#' social) identity provider (IdP)
#'
#' @description
#' Prevents the user from signing in with the specified external (SAML or social) identity provider (IdP). If the user that you want to deactivate is a Amazon Cognito user pools native username + password user, they can't use their password to sign in. If the user to deactivate is a linked external IdP user, any link between that user and an existing user is removed. When the external user signs in again, and the user is no longer attached to the previously linked `DestinationUser`, the user must create a new user account. See [`admin_link_provider_for_user`][cognitoidentityprovider_admin_link_provider_for_user].
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_disable_provider_for_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_disable_provider_for_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param User &#91;required&#93; The user to be disabled.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_disable_provider_for_user
cognitoidentityprovider_admin_disable_provider_for_user <- function(UserPoolId, User) {
  op <- new_operation(
    name = "AdminDisableProviderForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_disable_provider_for_user_input(UserPoolId = UserPoolId, User = User)
  output <- .cognitoidentityprovider$admin_disable_provider_for_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_disable_provider_for_user <- cognitoidentityprovider_admin_disable_provider_for_user

#' Deactivates a user and revokes all access tokens for the user
#'
#' @description
#' Deactivates a user and revokes all access tokens for the user. A deactivated user can't sign in, but still appears in the responses to [`get_user`][cognitoidentityprovider_get_user] and [`list_users`][cognitoidentityprovider_list_users] API requests.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_disable_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_disable_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to disable the user.
#' @param Username &#91;required&#93; The user name of the user you want to disable.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_disable_user
cognitoidentityprovider_admin_disable_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminDisableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_disable_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_disable_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_disable_user <- cognitoidentityprovider_admin_disable_user

#' Enables the specified user as an administrator
#'
#' @description
#' Enables the specified user as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_enable_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_enable_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to enable the user.
#' @param Username &#91;required&#93; The user name of the user you want to enable.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_enable_user
cognitoidentityprovider_admin_enable_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminEnableUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_enable_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_enable_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_enable_user <- cognitoidentityprovider_admin_enable_user

#' Forgets the device, as an administrator
#'
#' @description
#' Forgets the device, as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_forget_device/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_forget_device/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param DeviceKey &#91;required&#93; The device key.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_forget_device
cognitoidentityprovider_admin_forget_device <- function(UserPoolId, Username, DeviceKey) {
  op <- new_operation(
    name = "AdminForgetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_forget_device_input(UserPoolId = UserPoolId, Username = Username, DeviceKey = DeviceKey)
  output <- .cognitoidentityprovider$admin_forget_device_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_forget_device <- cognitoidentityprovider_admin_forget_device

#' Gets the device, as an administrator
#'
#' @description
#' Gets the device, as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_get_device/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_get_device/) for full documentation.
#'
#' @param DeviceKey &#91;required&#93; The device key.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_get_device
cognitoidentityprovider_admin_get_device <- function(DeviceKey, UserPoolId, Username) {
  op <- new_operation(
    name = "AdminGetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_get_device_input(DeviceKey = DeviceKey, UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_get_device_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_get_device <- cognitoidentityprovider_admin_get_device

#' Gets the specified user by user name in a user pool as an administrator
#'
#' @description
#' Gets the specified user by user name in a user pool as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_get_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_get_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to get information
#' about the user.
#' @param Username &#91;required&#93; The user name of the user you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_get_user
cognitoidentityprovider_admin_get_user <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminGetUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_get_user_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_get_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_get_user <- cognitoidentityprovider_admin_get_user

#' Initiates the authentication flow, as an administrator
#'
#' @description
#' Initiates the authentication flow, as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_initiate_auth/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_initiate_auth/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The ID of the Amazon Cognito user pool.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param AuthFlow &#91;required&#93; The authentication flow for this call to run. The API action will depend
#' on this value. For example:
#' 
#' -   `REFRESH_TOKEN_AUTH` will take in a valid refresh token and return
#'     new tokens.
#' 
#' -   `USER_SRP_AUTH` will take in `USERNAME` and `SRP_A` and return the
#'     Secure Remote Password (SRP) protocol variables to be used for next
#'     challenge execution.
#' 
#' -   `ADMIN_USER_PASSWORD_AUTH` will take in `USERNAME` and `PASSWORD`
#'     and return the next challenge or tokens.
#' 
#' Valid values include:
#' 
#' -   `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password
#'     (SRP) protocol.
#' 
#' -   `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for
#'     refreshing the access token and ID token by supplying a valid
#'     refresh token.
#' 
#' -   `CUSTOM_AUTH`: Custom authentication flow.
#' 
#' -   `ADMIN_NO_SRP_AUTH`: Non-SRP authentication flow; you can pass in
#'     the USERNAME and PASSWORD directly if the flow is enabled for
#'     calling the app client.
#' 
#' -   `ADMIN_USER_PASSWORD_AUTH`: Admin-based user password
#'     authentication. This replaces the `ADMIN_NO_SRP_AUTH` authentication
#'     flow. In this flow, Amazon Cognito receives the password in the
#'     request instead of using the SRP process to verify passwords.
#' @param AuthParameters The authentication parameters. These are inputs corresponding to the
#' `AuthFlow` that you're invoking. The required values depend on the value
#' of `AuthFlow`:
#' 
#' -   For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`.
#' 
#' -   For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`.
#' 
#' -   For `ADMIN_NO_SRP_AUTH`: `USERNAME` (required), `SECRET_HASH` (if
#'     app client is configured with client secret), `PASSWORD` (required),
#'     `DEVICE_KEY`.
#' 
#' -   For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app
#'     client is configured with client secret), `DEVICE_KEY`. To start the
#'     authentication flow with password verification, include
#'     `ChallengeName: SRP_A` and `SRP_A: (The SRP_A Value)`.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for
#' certain custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the AdminInitiateAuth API action, Amazon Cognito
#' invokes the Lambda functions that are specified for various triggers.
#' The ClientMetadata value is passed as input to the functions for only
#' the following triggers:
#' 
#' -   Pre signup
#' 
#' -   Pre authentication
#' 
#' -   User migration
#' 
#' When Amazon Cognito invokes the functions for these triggers, it passes
#' a JSON payload, which the function receives as input. This payload
#' contains a `validationData` attribute, which provides the data that you
#' assigned to the ClientMetadata parameter in your AdminInitiateAuth
#' request. In your function code in Lambda, you can process the
#' `validationData` value to enhance your workflow for your specific needs.
#' 
#' When you use the AdminInitiateAuth API action, Amazon Cognito also
#' invokes the functions for the following triggers, but it doesn't provide
#' the ClientMetadata value as input:
#' 
#' -   Post authentication
#' 
#' -   Custom message
#' 
#' -   Pre token generation
#' 
#' -   Create auth challenge
#' 
#' -   Define auth challenge
#' 
#' -   Verify auth challenge
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#' @param AnalyticsMetadata The analytics metadata for collecting Amazon Pinpoint metrics for
#' [`admin_initiate_auth`][cognitoidentityprovider_admin_initiate_auth]
#' calls.
#' @param ContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_initiate_auth
cognitoidentityprovider_admin_initiate_auth <- function(UserPoolId, ClientId, AuthFlow, AuthParameters = NULL, ClientMetadata = NULL, AnalyticsMetadata = NULL, ContextData = NULL) {
  op <- new_operation(
    name = "AdminInitiateAuth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_initiate_auth_input(UserPoolId = UserPoolId, ClientId = ClientId, AuthFlow = AuthFlow, AuthParameters = AuthParameters, ClientMetadata = ClientMetadata, AnalyticsMetadata = AnalyticsMetadata, ContextData = ContextData)
  output <- .cognitoidentityprovider$admin_initiate_auth_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_initiate_auth <- cognitoidentityprovider_admin_initiate_auth

#' Links an existing user account in a user pool (DestinationUser) to an
#' identity from an external IdP (SourceUser) based on a specified
#' attribute name and value from the external IdP
#'
#' @description
#' Links an existing user account in a user pool (`DestinationUser`) to an identity from an external IdP (`SourceUser`) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_link_provider_for_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_link_provider_for_user/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param DestinationUser &#91;required&#93; The existing user in the user pool that you want to assign to the
#' external IdP user account. This user can be a native (Username +
#' Password) Amazon Cognito user pools user or a federated user (for
#' example, a SAML or Facebook user). If the user doesn't exist, Amazon
#' Cognito generates an exception. Amazon Cognito returns this user when
#' the new user (with the linked IdP attribute) signs in.
#' 
#' For a native username + password user, the `ProviderAttributeValue` for
#' the `DestinationUser` should be the username in the user pool. For a
#' federated user, it should be the provider-specific `user_id`.
#' 
#' The `ProviderAttributeName` of the `DestinationUser` is ignored.
#' 
#' The `ProviderName` should be set to `Cognito` for users in Cognito user
#' pools.
#' 
#' All attributes in the DestinationUser profile must be mutable. If you
#' have assigned the user any immutable custom attributes, the operation
#' won't succeed.
#' @param SourceUser &#91;required&#93; An external IdP account for a user who doesn't exist yet in the user
#' pool. This user must be a federated user (for example, a SAML or
#' Facebook user), not another native user.
#' 
#' If the `SourceUser` is using a federated social IdP, such as Facebook,
#' Google, or Login with Amazon, you must set the `ProviderAttributeName`
#' to `Cognito_Subject`. For social IdPs, the `ProviderName` will be
#' `Facebook`, `Google`, or `LoginWithAmazon`, and Amazon Cognito will
#' automatically parse the Facebook, Google, and Login with Amazon tokens
#' for `id`, `sub`, and `user_id`, respectively. The
#' `ProviderAttributeValue` for the user must be the same value as the
#' `id`, `sub`, or `user_id` value found in the social IdP token.
#' 
#' For SAML, the `ProviderAttributeName` can be any value that matches a
#' claim in the SAML assertion. If you want to link SAML users based on the
#' subject of the SAML assertion, you should map the subject to a claim
#' through the SAML IdP and submit that claim name as the
#' `ProviderAttributeName`. If you set `ProviderAttributeName` to
#' `Cognito_Subject`, Amazon Cognito will automatically parse the default
#' unique identifier found in the subject from the SAML token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_link_provider_for_user
cognitoidentityprovider_admin_link_provider_for_user <- function(UserPoolId, DestinationUser, SourceUser) {
  op <- new_operation(
    name = "AdminLinkProviderForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_link_provider_for_user_input(UserPoolId = UserPoolId, DestinationUser = DestinationUser, SourceUser = SourceUser)
  output <- .cognitoidentityprovider$admin_link_provider_for_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_link_provider_for_user <- cognitoidentityprovider_admin_link_provider_for_user

#' Lists devices, as an administrator
#'
#' @description
#' Lists devices, as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_devices/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_devices/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param Limit The limit of the devices request.
#' @param PaginationToken The pagination token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_devices
cognitoidentityprovider_admin_list_devices <- function(UserPoolId, Username, Limit = NULL, PaginationToken = NULL) {
  op <- new_operation(
    name = "AdminListDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_devices_input(UserPoolId = UserPoolId, Username = Username, Limit = Limit, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$admin_list_devices_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_devices <- cognitoidentityprovider_admin_list_devices

#' Lists the groups that the user belongs to
#'
#' @description
#' Lists the groups that the user belongs to.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_groups_for_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_groups_for_user/) for full documentation.
#'
#' @param Username &#91;required&#93; The username for the user.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Limit The limit of the request to list groups.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_groups_for_user
cognitoidentityprovider_admin_list_groups_for_user <- function(Username, UserPoolId, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "AdminListGroupsForUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_groups_for_user_input(Username = Username, UserPoolId = UserPoolId, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$admin_list_groups_for_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_groups_for_user <- cognitoidentityprovider_admin_list_groups_for_user

#' A history of user activity and any risks detected as part of Amazon
#' Cognito advanced security
#'
#' @description
#' A history of user activity and any risks detected as part of Amazon Cognito advanced security.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_user_auth_events/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_list_user_auth_events/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username or an alias.
#' @param MaxResults The maximum number of authentication events to return. Returns 60 events
#' if you set `MaxResults` to 0, or if you don't include a `MaxResults`
#' parameter.
#' @param NextToken A pagination token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_list_user_auth_events
cognitoidentityprovider_admin_list_user_auth_events <- function(UserPoolId, Username, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "AdminListUserAuthEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_list_user_auth_events_input(UserPoolId = UserPoolId, Username = Username, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$admin_list_user_auth_events_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_list_user_auth_events <- cognitoidentityprovider_admin_list_user_auth_events

#' Removes the specified user from the specified group
#'
#' @description
#' Removes the specified user from the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_remove_user_from_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_remove_user_from_group/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Username &#91;required&#93; The username for the user.
#' @param GroupName &#91;required&#93; The group name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_remove_user_from_group
cognitoidentityprovider_admin_remove_user_from_group <- function(UserPoolId, Username, GroupName) {
  op <- new_operation(
    name = "AdminRemoveUserFromGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_remove_user_from_group_input(UserPoolId = UserPoolId, Username = Username, GroupName = GroupName)
  output <- .cognitoidentityprovider$admin_remove_user_from_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_remove_user_from_group <- cognitoidentityprovider_admin_remove_user_from_group

#' Resets the specified user's password in a user pool as an administrator
#'
#' @description
#' Resets the specified user's password in a user pool as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_reset_user_password/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_reset_user_password/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to reset the user's
#' password.
#' @param Username &#91;required&#93; The user name of the user whose password you want to reset.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the AdminResetUserPassword API action, Amazon
#' Cognito invokes the function that is assigned to the *custom message*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your AdminResetUserPassword request. In
#' your function code in Lambda, you can process the `clientMetadata` value
#' to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_reset_user_password
cognitoidentityprovider_admin_reset_user_password <- function(UserPoolId, Username, ClientMetadata = NULL) {
  op <- new_operation(
    name = "AdminResetUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_reset_user_password_input(UserPoolId = UserPoolId, Username = Username, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$admin_reset_user_password_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_reset_user_password <- cognitoidentityprovider_admin_reset_user_password

#' Responds to an authentication challenge, as an administrator
#'
#' @description
#' Responds to an authentication challenge, as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_respond_to_auth_challenge/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_respond_to_auth_challenge/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The ID of the Amazon Cognito user pool.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param ChallengeName &#91;required&#93; The challenge name. For more information, see
#' [`admin_initiate_auth`][cognitoidentityprovider_admin_initiate_auth].
#' @param ChallengeResponses The challenge responses. These are inputs corresponding to the value of
#' `ChallengeName`, for example:
#' 
#' -   `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`, `SECRET_HASH` (if app client
#'     is configured with client secret).
#' 
#' -   `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`,
#'     `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`,
#'     `SECRET_HASH` (if app client is configured with client secret).
#' 
#'     `PASSWORD_VERIFIER` requires `DEVICE_KEY` when signing in with a
#'     remembered device.
#' 
#' -   `ADMIN_NO_SRP_AUTH`: `PASSWORD`, `USERNAME`, `SECRET_HASH` (if app
#'     client is configured with client secret).
#' 
#' -   `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH`
#'     (if app client is configured with client secret). To set any
#'     required attributes that Amazon Cognito returned as
#'     `requiredAttributes` in the
#'     [`admin_initiate_auth`][cognitoidentityprovider_admin_initiate_auth]
#'     response, add a `userAttributes.attributename ` parameter. This
#'     parameter can also set values for writable attributes that aren't
#'     required by your user pool.
#' 
#'     In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a
#'     required attribute that already has a value. In
#'     [`admin_respond_to_auth_challenge`][cognitoidentityprovider_admin_respond_to_auth_challenge],
#'     set a value for any keys that Amazon Cognito returned in the
#'     `requiredAttributes` parameter, then use the
#'     [`admin_update_user_attributes`][cognitoidentityprovider_admin_update_user_attributes]
#'     API operation to modify the value of any additional attributes.
#' 
#' -   `MFA_SETUP` requires `USERNAME`, plus you must use the session value
#'     returned by
#'     [`verify_software_token`][cognitoidentityprovider_verify_software_token]
#'     in the `Session` parameter.
#' 
#' The value of the `USERNAME` attribute must be the user's actual
#' username, not an alias (such as an email address or phone number). To
#' make this simpler, the
#' [`admin_initiate_auth`][cognitoidentityprovider_admin_initiate_auth]
#' response includes the actual username value in the
#' `USERNAMEUSER_ID_FOR_SRP` attribute. This happens even if you specified
#' an alias in your call to
#' [`admin_initiate_auth`][cognitoidentityprovider_admin_initiate_auth].
#' @param Session The session that should be passed both ways in challenge-response calls
#' to the service. If an
#' [`initiate_auth`][cognitoidentityprovider_initiate_auth] or
#' [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge]
#' API call determines that the caller must pass another challenge, it
#' returns a session with other challenge parameters. This session should
#' be passed as it is to the next
#' [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge]
#' API call.
#' @param AnalyticsMetadata The analytics metadata for collecting Amazon Pinpoint metrics for
#' [`admin_respond_to_auth_challenge`][cognitoidentityprovider_admin_respond_to_auth_challenge]
#' calls.
#' @param ContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the AdminRespondToAuthChallenge API action,
#' Amazon Cognito invokes any functions that you have assigned to the
#' following triggers:
#' 
#' -   pre sign-up
#' 
#' -   custom message
#' 
#' -   post authentication
#' 
#' -   user migration
#' 
#' -   pre token generation
#' 
#' -   define auth challenge
#' 
#' -   create auth challenge
#' 
#' -   verify auth challenge response
#' 
#' When Amazon Cognito invokes any of these functions, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute that provides the data that you assigned to
#' the ClientMetadata parameter in your AdminRespondToAuthChallenge
#' request. In your function code in Lambda, you can process the
#' `clientMetadata` value to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_respond_to_auth_challenge
cognitoidentityprovider_admin_respond_to_auth_challenge <- function(UserPoolId, ClientId, ChallengeName, ChallengeResponses = NULL, Session = NULL, AnalyticsMetadata = NULL, ContextData = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "AdminRespondToAuthChallenge",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_respond_to_auth_challenge_input(UserPoolId = UserPoolId, ClientId = ClientId, ChallengeName = ChallengeName, ChallengeResponses = ChallengeResponses, Session = Session, AnalyticsMetadata = AnalyticsMetadata, ContextData = ContextData, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$admin_respond_to_auth_challenge_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_respond_to_auth_challenge <- cognitoidentityprovider_admin_respond_to_auth_challenge

#' The user's multi-factor authentication (MFA) preference, including which
#' MFA options are activated, and if any are preferred
#'
#' @description
#' The user's multi-factor authentication (MFA) preference, including which MFA options are activated, and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_mfa_preference/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_mfa_preference/) for full documentation.
#'
#' @param SMSMfaSettings The SMS text message MFA settings.
#' @param SoftwareTokenMfaSettings The time-based one-time password software token MFA settings.
#' @param Username &#91;required&#93; The user pool username or alias.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_set_user_mfa_preference
cognitoidentityprovider_admin_set_user_mfa_preference <- function(SMSMfaSettings = NULL, SoftwareTokenMfaSettings = NULL, Username, UserPoolId) {
  op <- new_operation(
    name = "AdminSetUserMFAPreference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_set_user_mfa_preference_input(SMSMfaSettings = SMSMfaSettings, SoftwareTokenMfaSettings = SoftwareTokenMfaSettings, Username = Username, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$admin_set_user_mfa_preference_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_set_user_mfa_preference <- cognitoidentityprovider_admin_set_user_mfa_preference

#' Sets the specified user's password in a user pool as an administrator
#'
#' @description
#' Sets the specified user's password in a user pool as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_password/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_password/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to set the user's
#' password.
#' @param Username &#91;required&#93; The user name of the user whose password you want to set.
#' @param Password &#91;required&#93; The password for the user.
#' @param Permanent `True` if the password is permanent, `False` if it is temporary.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_set_user_password
cognitoidentityprovider_admin_set_user_password <- function(UserPoolId, Username, Password, Permanent = NULL) {
  op <- new_operation(
    name = "AdminSetUserPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_set_user_password_input(UserPoolId = UserPoolId, Username = Username, Password = Password, Permanent = Permanent)
  output <- .cognitoidentityprovider$admin_set_user_password_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_set_user_password <- cognitoidentityprovider_admin_set_user_password

#' This action is no longer supported
#'
#' @description
#' *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [`admin_set_user_mfa_preference`][cognitoidentityprovider_admin_set_user_mfa_preference] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_settings/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_set_user_settings/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The ID of the user pool that contains the user whose options you're
#' setting.
#' @param Username &#91;required&#93; The user name of the user whose options you're setting.
#' @param MFAOptions &#91;required&#93; You can use this parameter only to set an SMS configuration that uses
#' SMS for delivery.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_set_user_settings
cognitoidentityprovider_admin_set_user_settings <- function(UserPoolId, Username, MFAOptions) {
  op <- new_operation(
    name = "AdminSetUserSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_set_user_settings_input(UserPoolId = UserPoolId, Username = Username, MFAOptions = MFAOptions)
  output <- .cognitoidentityprovider$admin_set_user_settings_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_set_user_settings <- cognitoidentityprovider_admin_set_user_settings

#' Provides feedback for an authentication event indicating if it was from
#' a valid user
#'
#' @description
#' Provides feedback for an authentication event indicating if it was from a valid user. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_auth_event_feedback/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_auth_event_feedback/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username.
#' @param EventId &#91;required&#93; The authentication event ID.
#' @param FeedbackValue &#91;required&#93; The authentication event feedback value.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_auth_event_feedback
cognitoidentityprovider_admin_update_auth_event_feedback <- function(UserPoolId, Username, EventId, FeedbackValue) {
  op <- new_operation(
    name = "AdminUpdateAuthEventFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_auth_event_feedback_input(UserPoolId = UserPoolId, Username = Username, EventId = EventId, FeedbackValue = FeedbackValue)
  output <- .cognitoidentityprovider$admin_update_auth_event_feedback_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_auth_event_feedback <- cognitoidentityprovider_admin_update_auth_event_feedback

#' Updates the device status as an administrator
#'
#' @description
#' Updates the device status as an administrator.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_device_status/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_device_status/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceRememberedStatus The status indicating whether a device has been remembered or not.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_device_status
cognitoidentityprovider_admin_update_device_status <- function(UserPoolId, Username, DeviceKey, DeviceRememberedStatus = NULL) {
  op <- new_operation(
    name = "AdminUpdateDeviceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_device_status_input(UserPoolId = UserPoolId, Username = Username, DeviceKey = DeviceKey, DeviceRememberedStatus = DeviceRememberedStatus)
  output <- .cognitoidentityprovider$admin_update_device_status_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_device_status <- cognitoidentityprovider_admin_update_device_status

#' Updates the specified user's attributes, including developer attributes,
#' as an administrator
#'
#' @description
#' Updates the specified user's attributes, including developer attributes, as an administrator. Works on any user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_user_attributes/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_update_user_attributes/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to update user
#' attributes.
#' @param Username &#91;required&#93; The user name of the user for whom you want to update user attributes.
#' @param UserAttributes &#91;required&#93; An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' 
#' If your user pool requires verification before Amazon Cognito updates an
#' attribute value that you specify in this request, Amazon Cognito doesn’t
#' immediately update the value of that attribute. After your user receives
#' and responds to a verification message to verify the new value, Amazon
#' Cognito updates the attribute value. Your user can sign in and receive
#' messages with the original attribute value until they verify the new
#' value.
#' 
#' To update the value of an attribute that requires verification in the
#' same API request, include the `email_verified` or
#' `phone_number_verified` attribute, with a value of `true`. If you set
#' the `email_verified` or `phone_number_verified` value for an `email` or
#' `phone_number` attribute that requires verification to `true`, Amazon
#' Cognito doesn’t send a verification message to your user.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the AdminUpdateUserAttributes API action, Amazon
#' Cognito invokes the function that is assigned to the *custom message*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your AdminUpdateUserAttributes request.
#' In your function code in Lambda, you can process the `clientMetadata`
#' value to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_update_user_attributes
cognitoidentityprovider_admin_update_user_attributes <- function(UserPoolId, Username, UserAttributes, ClientMetadata = NULL) {
  op <- new_operation(
    name = "AdminUpdateUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_update_user_attributes_input(UserPoolId = UserPoolId, Username = Username, UserAttributes = UserAttributes, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$admin_update_user_attributes_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_update_user_attributes <- cognitoidentityprovider_admin_update_user_attributes

#' Signs out a user from all devices
#'
#' @description
#' Signs out a user from all devices. You must sign [`admin_user_global_sign_out`][cognitoidentityprovider_admin_user_global_sign_out] requests with Amazon Web Services credentials. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. The user's current access and ID tokens remain valid until they expire. By default, access and ID tokens expire one hour after they're issued. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the cookie validity period of 1 hour.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_user_global_sign_out/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_user_global_sign_out/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_admin_user_global_sign_out
cognitoidentityprovider_admin_user_global_sign_out <- function(UserPoolId, Username) {
  op <- new_operation(
    name = "AdminUserGlobalSignOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$admin_user_global_sign_out_input(UserPoolId = UserPoolId, Username = Username)
  output <- .cognitoidentityprovider$admin_user_global_sign_out_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$admin_user_global_sign_out <- cognitoidentityprovider_admin_user_global_sign_out

#' Begins setup of time-based one-time password (TOTP) multi-factor
#' authentication (MFA) for a user, with a unique private key that Amazon
#' Cognito generates and returns in the API response
#'
#' @description
#' Begins setup of time-based one-time password (TOTP) multi-factor authentication (MFA) for a user, with a unique private key that Amazon Cognito generates and returns in the API response. You can authorize an [`associate_software_token`][cognitoidentityprovider_associate_software_token] request with either the user's access token, or a session string from a challenge response that you received from Amazon Cognito.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_associate_software_token/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_associate_software_token/) for full documentation.
#'
#' @param AccessToken A valid access token that Amazon Cognito issued to the user whose
#' software token you want to generate.
#' @param Session The session that should be passed both ways in challenge-response calls
#' to the service. This allows authentication of the user as part of the
#' MFA setup process.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_associate_software_token
cognitoidentityprovider_associate_software_token <- function(AccessToken = NULL, Session = NULL) {
  op <- new_operation(
    name = "AssociateSoftwareToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$associate_software_token_input(AccessToken = AccessToken, Session = Session)
  output <- .cognitoidentityprovider$associate_software_token_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$associate_software_token <- cognitoidentityprovider_associate_software_token

#' Changes the password for a specified user in a user pool
#'
#' @description
#' Changes the password for a specified user in a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_change_password/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_change_password/) for full documentation.
#'
#' @param PreviousPassword &#91;required&#93; The old password.
#' @param ProposedPassword &#91;required&#93; The new password.
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose
#' password you want to change.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_change_password
cognitoidentityprovider_change_password <- function(PreviousPassword, ProposedPassword, AccessToken) {
  op <- new_operation(
    name = "ChangePassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$change_password_input(PreviousPassword = PreviousPassword, ProposedPassword = ProposedPassword, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$change_password_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$change_password <- cognitoidentityprovider_change_password

#' Confirms tracking of the device
#'
#' @description
#' Confirms tracking of the device. This API call is the call that begins device tracking.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_device/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_device/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose device
#' you want to confirm.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceSecretVerifierConfig The configuration of the device secret verifier.
#' @param DeviceName The device name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_device
cognitoidentityprovider_confirm_device <- function(AccessToken, DeviceKey, DeviceSecretVerifierConfig = NULL, DeviceName = NULL) {
  op <- new_operation(
    name = "ConfirmDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_device_input(AccessToken = AccessToken, DeviceKey = DeviceKey, DeviceSecretVerifierConfig = DeviceSecretVerifierConfig, DeviceName = DeviceName)
  output <- .cognitoidentityprovider$confirm_device_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_device <- cognitoidentityprovider_confirm_device

#' Allows a user to enter a confirmation code to reset a forgotten password
#'
#' @description
#' Allows a user to enter a confirmation code to reset a forgotten password.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_forgot_password/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_forgot_password/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user for whom you want to enter a code to retrieve
#' a forgotten password.
#' @param ConfirmationCode &#91;required&#93; The confirmation code from your user's request to reset their password.
#' For more information, see
#' [`forgot_password`][cognitoidentityprovider_forgot_password].
#' @param Password &#91;required&#93; The new password that your user wants to set.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' [`confirm_forgot_password`][cognitoidentityprovider_confirm_forgot_password]
#' calls.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the ConfirmForgotPassword API action, Amazon
#' Cognito invokes the function that is assigned to the *post confirmation*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your ConfirmForgotPassword request. In
#' your function code in Lambda, you can process the `clientMetadata` value
#' to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_forgot_password
cognitoidentityprovider_confirm_forgot_password <- function(ClientId, SecretHash = NULL, Username, ConfirmationCode, Password, AnalyticsMetadata = NULL, UserContextData = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "ConfirmForgotPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_forgot_password_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, ConfirmationCode = ConfirmationCode, Password = Password, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$confirm_forgot_password_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_forgot_password <- cognitoidentityprovider_confirm_forgot_password

#' Confirms registration of a new user
#'
#' @description
#' Confirms registration of a new user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_sign_up/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_confirm_sign_up/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The ID of the app client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user whose registration you want to confirm.
#' @param ConfirmationCode &#91;required&#93; The confirmation code sent by a user's request to confirm registration.
#' @param ForceAliasCreation Boolean to be specified to force user confirmation irrespective of
#' existing alias. By default set to `False`. If this parameter is set to
#' `True` and the phone number/email used for sign up confirmation already
#' exists as an alias with a different user, the API call will migrate the
#' alias from the previous user to the newly created user being confirmed.
#' If set to `False`, the API will throw an **AliasExistsException** error.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata for collecting metrics for
#' [`confirm_sign_up`][cognitoidentityprovider_confirm_sign_up] calls.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the ConfirmSignUp API action, Amazon Cognito
#' invokes the function that is assigned to the *post confirmation*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your ConfirmSignUp request. In your
#' function code in Lambda, you can process the `clientMetadata` value to
#' enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_confirm_sign_up
cognitoidentityprovider_confirm_sign_up <- function(ClientId, SecretHash = NULL, Username, ConfirmationCode, ForceAliasCreation = NULL, AnalyticsMetadata = NULL, UserContextData = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "ConfirmSignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$confirm_sign_up_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, ConfirmationCode = ConfirmationCode, ForceAliasCreation = ForceAliasCreation, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$confirm_sign_up_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$confirm_sign_up <- cognitoidentityprovider_confirm_sign_up

#' Creates a new group in the specified user pool
#'
#' @description
#' Creates a new group in the specified user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group. Must be unique.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Description A string containing the description of the group.
#' @param RoleArn The role Amazon Resource Name (ARN) for the group.
#' @param Precedence A non-negative integer value that specifies the precedence of this group
#' relative to the other groups that a user can belong to in the user pool.
#' Zero is the highest precedence value. Groups with lower `Precedence`
#' values take precedence over groups with higher or null `Precedence`
#' values. If a user belongs to two or more groups, it is the group with
#' the lowest precedence value whose role ARN is given in the user's tokens
#' for the `cognito:roles` and `cognito:preferred_role` claims.
#' 
#' Two groups can have the same `Precedence` value. If this happens,
#' neither group takes precedence over the other. If two groups with the
#' same `Precedence` have the same role ARN, that role is used in the
#' `cognito:preferred_role` claim in tokens for users in each group. If the
#' two groups have different role ARNs, the `cognito:preferred_role` claim
#' isn't set in users' tokens.
#' 
#' The default `Precedence` value is null. The maximum `Precedence` value
#' is `2^31-1`.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_group
cognitoidentityprovider_create_group <- function(GroupName, UserPoolId, Description = NULL, RoleArn = NULL, Precedence = NULL) {
  op <- new_operation(
    name = "CreateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_group_input(GroupName = GroupName, UserPoolId = UserPoolId, Description = Description, RoleArn = RoleArn, Precedence = Precedence)
  output <- .cognitoidentityprovider$create_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_group <- cognitoidentityprovider_create_group

#' Creates an IdP for a user pool
#'
#' @description
#' Creates an IdP for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_identity_provider/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_identity_provider/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The IdP name.
#' @param ProviderType &#91;required&#93; The IdP type.
#' @param ProviderDetails &#91;required&#93; The IdP details. The following list describes the provider detail keys
#' for each IdP type.
#' 
#' -   For Google and Login with Amazon:
#' 
#'     -   client_id
#' 
#'     -   client_secret
#' 
#'     -   authorize_scopes
#' 
#' -   For Facebook:
#' 
#'     -   client_id
#' 
#'     -   client_secret
#' 
#'     -   authorize_scopes
#' 
#'     -   api_version
#' 
#' -   For Sign in with Apple:
#' 
#'     -   client_id
#' 
#'     -   team_id
#' 
#'     -   key_id
#' 
#'     -   private_key
#' 
#'     -   authorize_scopes
#' 
#' -   For OpenID Connect (OIDC) providers:
#' 
#'     -   client_id
#' 
#'     -   client_secret
#' 
#'     -   attributes_request_method
#' 
#'     -   oidc_issuer
#' 
#'     -   authorize_scopes
#' 
#'     -   The following keys are only present if Amazon Cognito didn't
#'         discover them at the `oidc_issuer` URL.
#' 
#'         -   authorize_url
#' 
#'         -   token_url
#' 
#'         -   attributes_url
#' 
#'         -   jwks_uri
#' 
#'     -   Amazon Cognito sets the value of the following keys
#'         automatically. They are read-only.
#' 
#'         -   attributes_url_add_attributes
#' 
#' -   For SAML providers:
#' 
#'     -   MetadataFile or MetadataURL
#' 
#'     -   IDPSignout *optional*
#' @param AttributeMapping A mapping of IdP attributes to standard and custom user pool attributes.
#' @param IdpIdentifiers A list of IdP identifiers.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_identity_provider
cognitoidentityprovider_create_identity_provider <- function(UserPoolId, ProviderName, ProviderType, ProviderDetails, AttributeMapping = NULL, IdpIdentifiers = NULL) {
  op <- new_operation(
    name = "CreateIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName, ProviderType = ProviderType, ProviderDetails = ProviderDetails, AttributeMapping = AttributeMapping, IdpIdentifiers = IdpIdentifiers)
  output <- .cognitoidentityprovider$create_identity_provider_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_identity_provider <- cognitoidentityprovider_create_identity_provider

#' Creates a new OAuth2
#'
#' @description
#' Creates a new OAuth2.0 resource server and defines custom scopes within it.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_resource_server/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_resource_server/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Identifier &#91;required&#93; A unique resource server identifier for the resource server. This could
#' be an HTTPS endpoint where the resource server is located, such as
#' `https://my-weather-api.example.com`.
#' @param Name &#91;required&#93; A friendly name for the resource server.
#' @param Scopes A list of scopes. Each scope is a key-value map with the keys `name` and
#' `description`.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_resource_server
cognitoidentityprovider_create_resource_server <- function(UserPoolId, Identifier, Name, Scopes = NULL) {
  op <- new_operation(
    name = "CreateResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier, Name = Name, Scopes = Scopes)
  output <- .cognitoidentityprovider$create_resource_server_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_resource_server <- cognitoidentityprovider_create_resource_server

#' Creates the user import job
#'
#' @description
#' Creates the user import job.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_import_job/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_import_job/) for full documentation.
#'
#' @param JobName &#91;required&#93; The job name for the user import job.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param CloudWatchLogsRoleArn &#91;required&#93; The role ARN for the Amazon CloudWatch Logs Logging role for the user
#' import job.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_import_job
cognitoidentityprovider_create_user_import_job <- function(JobName, UserPoolId, CloudWatchLogsRoleArn) {
  op <- new_operation(
    name = "CreateUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_import_job_input(JobName = JobName, UserPoolId = UserPoolId, CloudWatchLogsRoleArn = CloudWatchLogsRoleArn)
  output <- .cognitoidentityprovider$create_user_import_job_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_import_job <- cognitoidentityprovider_create_user_import_job

#' Creates a new Amazon Cognito user pool and sets the password policy for
#' the pool
#'
#' @description
#' Creates a new Amazon Cognito user pool and sets the password policy for the pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool/) for full documentation.
#'
#' @param PoolName &#91;required&#93; A string used to name the user pool.
#' @param Policies The policies associated with the new user pool.
#' @param DeletionProtection When active, `DeletionProtection` prevents accidental deletion of your
#' user pool. Before you can delete a user pool that you have protected
#' against deletion, you must deactivate this feature.
#' 
#' When you try to delete a protected user pool in a
#' [`delete_user_pool`][cognitoidentityprovider_delete_user_pool] API
#' request, Amazon Cognito returns an `InvalidParameterException` error. To
#' delete a protected user pool, send a new
#' [`delete_user_pool`][cognitoidentityprovider_delete_user_pool] request
#' after you deactivate deletion protection in an
#' [`update_user_pool`][cognitoidentityprovider_update_user_pool] API
#' request.
#' @param LambdaConfig The Lambda trigger configuration information for the new user pool.
#' 
#' In a push model, event sources (such as Amazon S3 and custom
#' applications) need permission to invoke a function. So you must make an
#' extra call to add permission for these event sources to invoke your
#' Lambda function.
#' 
#' For more information on using the Lambda API to add permission, see
#' [AddPermission](https://docs.aws.amazon.com/lambda/latest/dg/API_AddPermission.html)
#' .
#' 
#' For adding permission using the CLI, see
#' [add-permission](https://docs.aws.amazon.com/cli/latest/reference/lambda/add-permission.html)
#' .
#' @param AutoVerifiedAttributes The attributes to be auto-verified. Possible values: **email**,
#' **phone_number**.
#' @param AliasAttributes Attributes supported as an alias for this user pool. Possible values:
#' **phone_number**, **email**, or **preferred_username**.
#' @param UsernameAttributes Specifies whether a user can use an email address or phone number as a
#' username when they sign up.
#' @param SmsVerificationMessage This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param EmailVerificationMessage This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param EmailVerificationSubject This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param VerificationMessageTemplate The template for the verification message that the user sees when the
#' app requests permission to access the user's information.
#' @param SmsAuthenticationMessage A string representing the SMS authentication message.
#' @param MfaConfiguration Specifies MFA configuration details.
#' @param UserAttributeUpdateSettings The settings for updates to user attributes. These settings include the
#' property `AttributesRequireVerificationBeforeUpdate`, a user-pool
#' setting that tells Amazon Cognito how to handle changes to the value of
#' your users' email address and phone number attributes. For more
#' information, see [Verifying updates to email addresses and phone
#' numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
#' @param DeviceConfiguration The device-remembering configuration for a user pool. A null value
#' indicates that you have deactivated device remembering in your user
#' pool.
#' 
#' When you provide a value for any `DeviceConfiguration` field, you
#' activate the Amazon Cognito device-remembering feature.
#' @param EmailConfiguration The email configuration of your user pool. The email configuration type
#' sets your preferred sending method, Amazon Web Services Region, and
#' sender for messages from your user pool.
#' @param SmsConfiguration The SMS configuration with the settings that your Amazon Cognito user
#' pool must use to send an SMS message from your Amazon Web Services
#' account through Amazon Simple Notification Service. To send SMS messages
#' with Amazon SNS in the Amazon Web Services Region that you want, the
#' Amazon Cognito user pool uses an Identity and Access Management (IAM)
#' role in your Amazon Web Services account.
#' @param UserPoolTags The tag keys and values to assign to the user pool. A tag is a label
#' that you can use to categorize and manage user pools in different ways,
#' such as by purpose, owner, environment, or other criteria.
#' @param AdminCreateUserConfig The configuration for
#' [`admin_create_user`][cognitoidentityprovider_admin_create_user]
#' requests.
#' @param Schema An array of schema attributes for the new user pool. These attributes
#' can be standard or custom attributes.
#' @param UserPoolAddOns Enables advanced security risk detection. Set the key
#' `AdvancedSecurityMode` to the value "AUDIT".
#' @param UsernameConfiguration Case sensitivity on the username input for the selected sign-in option.
#' For example, when case sensitivity is set to `False`, users can sign in
#' using either "username" or "Username". This configuration is immutable
#' once it has been set. For more information, see
#' [UsernameConfigurationType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_UsernameConfigurationType.html).
#' @param AccountRecoverySetting The available verified method a user can use to recover their password
#' when they call
#' [`forgot_password`][cognitoidentityprovider_forgot_password]. You can
#' use this setting to define a preferred method when a user has more than
#' one method available. With this setting, SMS doesn't qualify for a valid
#' password recovery mechanism if the user also has SMS multi-factor
#' authentication (MFA) activated. In the absence of this setting, Amazon
#' Cognito uses the legacy behavior to determine the recovery method where
#' SMS is preferred through email.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool
cognitoidentityprovider_create_user_pool <- function(PoolName, Policies = NULL, DeletionProtection = NULL, LambdaConfig = NULL, AutoVerifiedAttributes = NULL, AliasAttributes = NULL, UsernameAttributes = NULL, SmsVerificationMessage = NULL, EmailVerificationMessage = NULL, EmailVerificationSubject = NULL, VerificationMessageTemplate = NULL, SmsAuthenticationMessage = NULL, MfaConfiguration = NULL, UserAttributeUpdateSettings = NULL, DeviceConfiguration = NULL, EmailConfiguration = NULL, SmsConfiguration = NULL, UserPoolTags = NULL, AdminCreateUserConfig = NULL, Schema = NULL, UserPoolAddOns = NULL, UsernameConfiguration = NULL, AccountRecoverySetting = NULL) {
  op <- new_operation(
    name = "CreateUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_input(PoolName = PoolName, Policies = Policies, DeletionProtection = DeletionProtection, LambdaConfig = LambdaConfig, AutoVerifiedAttributes = AutoVerifiedAttributes, AliasAttributes = AliasAttributes, UsernameAttributes = UsernameAttributes, SmsVerificationMessage = SmsVerificationMessage, EmailVerificationMessage = EmailVerificationMessage, EmailVerificationSubject = EmailVerificationSubject, VerificationMessageTemplate = VerificationMessageTemplate, SmsAuthenticationMessage = SmsAuthenticationMessage, MfaConfiguration = MfaConfiguration, UserAttributeUpdateSettings = UserAttributeUpdateSettings, DeviceConfiguration = DeviceConfiguration, EmailConfiguration = EmailConfiguration, SmsConfiguration = SmsConfiguration, UserPoolTags = UserPoolTags, AdminCreateUserConfig = AdminCreateUserConfig, Schema = Schema, UserPoolAddOns = UserPoolAddOns, UsernameConfiguration = UsernameConfiguration, AccountRecoverySetting = AccountRecoverySetting)
  output <- .cognitoidentityprovider$create_user_pool_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool <- cognitoidentityprovider_create_user_pool

#' Creates the user pool client
#'
#' @description
#' Creates the user pool client.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool_client/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool_client/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to create a user pool
#' client.
#' @param ClientName &#91;required&#93; The client name for the user pool client you would like to create.
#' @param GenerateSecret Boolean to specify whether you want to generate a secret for the user
#' pool client being created.
#' @param RefreshTokenValidity The refresh token time limit. After this limit expires, your user can't
#' use their refresh token. To specify the time unit for
#' `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set
#' a `TokenValidityUnits` value in your API request.
#' 
#' For example, when you set `RefreshTokenValidity` as `10` and
#' `TokenValidityUnits` as `days`, your user can refresh their session and
#' retrieve new access and ID tokens for 10 days.
#' 
#' The default time unit for `RefreshTokenValidity` in an API request is
#' days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon
#' Cognito overrides the value with the default value of 30 days. *Valid
#' range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your refresh tokens are valid for 30 days.
#' @param AccessTokenValidity The access token time limit. After this limit expires, your user can't
#' use their access token. To specify the time unit for
#' `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a
#' `TokenValidityUnits` value in your API request.
#' 
#' For example, when you set `AccessTokenValidity` to `10` and
#' `TokenValidityUnits` to `hours`, your user can authorize access with
#' their access token for 10 hours.
#' 
#' The default time unit for `AccessTokenValidity` in an API request is
#' hours. *Valid range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your access tokens are valid for one hour.
#' @param IdTokenValidity The ID token time limit. After this limit expires, your user can't use
#' their ID token. To specify the time unit for `IdTokenValidity` as
#' `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits`
#' value in your API request.
#' 
#' For example, when you set `IdTokenValidity` as `10` and
#' `TokenValidityUnits` as `hours`, your user can authenticate their
#' session with their ID token for 10 hours.
#' 
#' The default time unit for `AccessTokenValidity` in an API request is
#' hours. *Valid range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your ID tokens are valid for one hour.
#' @param TokenValidityUnits The units in which the validity times are represented. The default unit
#' for RefreshToken is days, and default for ID and access tokens are
#' hours.
#' @param ReadAttributes The read attributes.
#' @param WriteAttributes The user pool attributes that the app client can write to.
#' 
#' If your app client allows users to sign in through an IdP, this array
#' must include all attributes that you have mapped to IdP attributes.
#' Amazon Cognito updates mapped attributes when users sign in to your
#' application through an IdP. If your app client does not have write
#' access to a mapped attribute, Amazon Cognito throws an error when it
#' tries to update the attribute. For more information, see [Specifying IdP
#' Attribute Mappings for Your user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-specifying-attribute-mapping.html).
#' @param ExplicitAuthFlows The authentication flows that you want your user pool client to support.
#' For each app client in your user pool, you can sign in your users with
#' any combination of one or more flows, including with a user name and
#' Secure Remote Password (SRP), a user name and password, or a custom
#' authentication process that you define with Lambda functions.
#' 
#' If you don't specify a value for `ExplicitAuthFlows`, your user client
#' supports `ALLOW_REFRESH_TOKEN_AUTH`, `ALLOW_USER_SRP_AUTH`, and
#' `ALLOW_CUSTOM_AUTH`.
#' 
#' Valid values include:
#' 
#' -   `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password
#'     authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting
#'     replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication
#'     flow, your app passes a user name and password to Amazon Cognito in
#'     the request, instead of using the Secure Remote Password (SRP)
#'     protocol to securely transmit the password.
#' 
#' -   `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
#' 
#' -   `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based
#'     authentication. In this flow, Amazon Cognito receives the password
#'     in the request instead of using the SRP protocol to verify
#'     passwords.
#' 
#' -   `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
#' 
#' -   `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
#' 
#' In some environments, you will see the values `ADMIN_NO_SRP_AUTH`,
#' `CUSTOM_AUTH_FLOW_ONLY`, or `USER_PASSWORD_AUTH`. You can't assign these
#' legacy `ExplicitAuthFlows` values to user pool clients at the same time
#' as values that begin with `ALLOW_`, like `ALLOW_USER_SRP_AUTH`.
#' @param SupportedIdentityProviders A list of provider names for the identity providers (IdPs) that are
#' supported on this client. The following are supported: `COGNITO`,
#' `Facebook`, `Google`, `SignInWithApple`, and `LoginWithAmazon`. You can
#' also specify the names that you configured for the SAML and OIDC IdPs in
#' your user pool, for example `MySAMLIdP` or `MyOIDCIdP`.
#' @param CallbackURLs A list of allowed redirect (callback) URLs for the IdPs.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param LogoutURLs A list of allowed logout URLs for the IdPs.
#' @param DefaultRedirectURI The default redirect URI. Must be in the `CallbackURLs` list.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as myapp://example are also supported.
#' @param AllowedOAuthFlows The allowed OAuth flows.
#' 
#' **code**
#' 
#' Use a code grant flow, which provides an authorization code as the
#' response. This code can be exchanged for access tokens with the
#' `/oauth2/token` endpoint.
#' 
#' **implicit**
#' 
#' Issue the access token (and, optionally, ID token, based on scopes)
#' directly to your user.
#' 
#' **client_credentials**
#' 
#' Issue the access token from the `/oauth2/token` endpoint directly to a
#' non-person user using a combination of the client ID and client secret.
#' @param AllowedOAuthScopes The allowed OAuth scopes. Possible values provided by OAuth are `phone`,
#' `email`, `openid`, and `profile`. Possible values provided by Amazon Web
#' Services are `aws.cognito.signin.user.admin`. Custom scopes created in
#' Resource Servers are also supported.
#' @param AllowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when
#' interacting with Amazon Cognito user pools.
#' @param AnalyticsConfiguration The user pool analytics configuration for collecting metrics and sending
#' them to your Amazon Pinpoint campaign.
#' 
#' In Amazon Web Services Regions where Amazon Pinpoint isn't available,
#' user pools only support sending events to Amazon Pinpoint projects in
#' Amazon Web Services Region us-east-1. In Regions where Amazon Pinpoint
#' is available, user pools support sending events to Amazon Pinpoint
#' projects within that same Region.
#' @param PreventUserExistenceErrors Errors and responses that you want Amazon Cognito APIs to return during
#' authentication, account confirmation, and password recovery when the
#' user doesn't exist in the user pool. When set to `ENABLED` and the user
#' doesn't exist, authentication returns an error indicating either the
#' username or password was incorrect. Account confirmation and password
#' recovery return a response indicating a code was sent to a simulated
#' destination. When set to `LEGACY`, those APIs return a
#' `UserNotFoundException` exception if the user doesn't exist in the user
#' pool.
#' 
#' Valid values include:
#' 
#' -   `ENABLED` - This prevents user existence-related errors.
#' 
#' -   `LEGACY` - This represents the early behavior of Amazon Cognito
#'     where user existence related errors aren't prevented.
#' @param EnableTokenRevocation Activates or deactivates token revocation. For more information about
#' revoking tokens, see
#' [`revoke_token`][cognitoidentityprovider_revoke_token].
#' 
#' If you don't include this parameter, token revocation is automatically
#' activated for the new user pool client.
#' @param EnablePropagateAdditionalUserContextData Activates the propagation of additional user context data. For more
#' information about propagation of user context data, see [Adding advanced
#' security to a user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html).
#' If you don’t include this parameter, you can't send device fingerprint
#' information, including source IP address, to Amazon Cognito advanced
#' security. You can only activate
#' `EnablePropagateAdditionalUserContextData` in an app client that has a
#' client secret.
#' @param AuthSessionValidity Amazon Cognito creates a session token for each API request in an
#' authentication flow. `AuthSessionValidity` is the duration, in minutes,
#' of that session token. Your user pool native user must respond to each
#' authentication challenge before the session expires.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool_client
cognitoidentityprovider_create_user_pool_client <- function(UserPoolId, ClientName, GenerateSecret = NULL, RefreshTokenValidity = NULL, AccessTokenValidity = NULL, IdTokenValidity = NULL, TokenValidityUnits = NULL, ReadAttributes = NULL, WriteAttributes = NULL, ExplicitAuthFlows = NULL, SupportedIdentityProviders = NULL, CallbackURLs = NULL, LogoutURLs = NULL, DefaultRedirectURI = NULL, AllowedOAuthFlows = NULL, AllowedOAuthScopes = NULL, AllowedOAuthFlowsUserPoolClient = NULL, AnalyticsConfiguration = NULL, PreventUserExistenceErrors = NULL, EnableTokenRevocation = NULL, EnablePropagateAdditionalUserContextData = NULL, AuthSessionValidity = NULL) {
  op <- new_operation(
    name = "CreateUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_client_input(UserPoolId = UserPoolId, ClientName = ClientName, GenerateSecret = GenerateSecret, RefreshTokenValidity = RefreshTokenValidity, AccessTokenValidity = AccessTokenValidity, IdTokenValidity = IdTokenValidity, TokenValidityUnits = TokenValidityUnits, ReadAttributes = ReadAttributes, WriteAttributes = WriteAttributes, ExplicitAuthFlows = ExplicitAuthFlows, SupportedIdentityProviders = SupportedIdentityProviders, CallbackURLs = CallbackURLs, LogoutURLs = LogoutURLs, DefaultRedirectURI = DefaultRedirectURI, AllowedOAuthFlows = AllowedOAuthFlows, AllowedOAuthScopes = AllowedOAuthScopes, AllowedOAuthFlowsUserPoolClient = AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration = AnalyticsConfiguration, PreventUserExistenceErrors = PreventUserExistenceErrors, EnableTokenRevocation = EnableTokenRevocation, EnablePropagateAdditionalUserContextData = EnablePropagateAdditionalUserContextData, AuthSessionValidity = AuthSessionValidity)
  output <- .cognitoidentityprovider$create_user_pool_client_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool_client <- cognitoidentityprovider_create_user_pool_client

#' Creates a new domain for a user pool
#'
#' @description
#' Creates a new domain for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool_domain/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_create_user_pool_domain/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain string. For custom domains, this is the fully-qualified
#' domain name, such as `auth.example.com`. For Amazon Cognito prefix
#' domains, this is the prefix alone, such as `auth`.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param CustomDomainConfig The configuration for a custom domain that hosts the sign-up and sign-in
#' webpages for your application.
#' 
#' Provide this parameter only if you want to use a custom domain for your
#' user pool. Otherwise, you can exclude this parameter and use the Amazon
#' Cognito hosted domain instead.
#' 
#' For more information about the hosted domain and custom domains, see
#' [Configuring a User Pool
#' Domain](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-assign-domain.html).
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_create_user_pool_domain
cognitoidentityprovider_create_user_pool_domain <- function(Domain, UserPoolId, CustomDomainConfig = NULL) {
  op <- new_operation(
    name = "CreateUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$create_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId, CustomDomainConfig = CustomDomainConfig)
  output <- .cognitoidentityprovider$create_user_pool_domain_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$create_user_pool_domain <- cognitoidentityprovider_create_user_pool_domain

#' Deletes a group
#'
#' @description
#' Deletes a group.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_group
cognitoidentityprovider_delete_group <- function(GroupName, UserPoolId) {
  op <- new_operation(
    name = "DeleteGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_group_input(GroupName = GroupName, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_group <- cognitoidentityprovider_delete_group

#' Deletes an IdP for a user pool
#'
#' @description
#' Deletes an IdP for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_identity_provider/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_identity_provider/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The IdP name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_identity_provider
cognitoidentityprovider_delete_identity_provider <- function(UserPoolId, ProviderName) {
  op <- new_operation(
    name = "DeleteIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName)
  output <- .cognitoidentityprovider$delete_identity_provider_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_identity_provider <- cognitoidentityprovider_delete_identity_provider

#' Deletes a resource server
#'
#' @description
#' Deletes a resource server.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_resource_server/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_resource_server/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that hosts the resource server.
#' @param Identifier &#91;required&#93; The identifier for the resource server.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_resource_server
cognitoidentityprovider_delete_resource_server <- function(UserPoolId, Identifier) {
  op <- new_operation(
    name = "DeleteResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier)
  output <- .cognitoidentityprovider$delete_resource_server_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_resource_server <- cognitoidentityprovider_delete_resource_server

#' Allows a user to delete himself or herself
#'
#' @description
#' Allows a user to delete himself or herself.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose user
#' profile you want to delete.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user
cognitoidentityprovider_delete_user <- function(AccessToken) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$delete_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user <- cognitoidentityprovider_delete_user

#' Deletes the attributes for a user
#'
#' @description
#' Deletes the attributes for a user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_attributes/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_attributes/) for full documentation.
#'
#' @param UserAttributeNames &#91;required&#93; An array of strings representing the user attribute names you want to
#' delete.
#' 
#' For custom attributes, you must prependattach the `custom:` prefix to
#' the front of the attribute name.
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose
#' attributes you want to delete.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_attributes
cognitoidentityprovider_delete_user_attributes <- function(UserAttributeNames, AccessToken) {
  op <- new_operation(
    name = "DeleteUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_attributes_input(UserAttributeNames = UserAttributeNames, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$delete_user_attributes_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_attributes <- cognitoidentityprovider_delete_user_attributes

#' Deletes the specified Amazon Cognito user pool
#'
#' @description
#' Deletes the specified Amazon Cognito user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to delete.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool
cognitoidentityprovider_delete_user_pool <- function(UserPoolId) {
  op <- new_operation(
    name = "DeleteUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_user_pool_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool <- cognitoidentityprovider_delete_user_pool

#' Allows the developer to delete the user pool client
#'
#' @description
#' Allows the developer to delete the user pool client.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool_client/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool_client/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to delete the client.
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool_client
cognitoidentityprovider_delete_user_pool_client <- function(UserPoolId, ClientId) {
  op <- new_operation(
    name = "DeleteUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$delete_user_pool_client_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool_client <- cognitoidentityprovider_delete_user_pool_client

#' Deletes a domain for a user pool
#'
#' @description
#' Deletes a domain for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool_domain/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_delete_user_pool_domain/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain string. For custom domains, this is the fully-qualified
#' domain name, such as `auth.example.com`. For Amazon Cognito prefix
#' domains, this is the prefix alone, such as `auth`.
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_delete_user_pool_domain
cognitoidentityprovider_delete_user_pool_domain <- function(Domain, UserPoolId) {
  op <- new_operation(
    name = "DeleteUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$delete_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$delete_user_pool_domain_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$delete_user_pool_domain <- cognitoidentityprovider_delete_user_pool_domain

#' Gets information about a specific IdP
#'
#' @description
#' Gets information about a specific IdP.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_identity_provider/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_identity_provider/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The IdP name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_identity_provider
cognitoidentityprovider_describe_identity_provider <- function(UserPoolId, ProviderName) {
  op <- new_operation(
    name = "DescribeIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName)
  output <- .cognitoidentityprovider$describe_identity_provider_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_identity_provider <- cognitoidentityprovider_describe_identity_provider

#' Describes a resource server
#'
#' @description
#' Describes a resource server.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_resource_server/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_resource_server/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that hosts the resource server.
#' @param Identifier &#91;required&#93; The identifier for the resource server
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_resource_server
cognitoidentityprovider_describe_resource_server <- function(UserPoolId, Identifier) {
  op <- new_operation(
    name = "DescribeResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier)
  output <- .cognitoidentityprovider$describe_resource_server_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_resource_server <- cognitoidentityprovider_describe_resource_server

#' Describes the risk configuration
#'
#' @description
#' Describes the risk configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_risk_configuration/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_risk_configuration/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ClientId The app client ID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_risk_configuration
cognitoidentityprovider_describe_risk_configuration <- function(UserPoolId, ClientId = NULL) {
  op <- new_operation(
    name = "DescribeRiskConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_risk_configuration_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$describe_risk_configuration_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_risk_configuration <- cognitoidentityprovider_describe_risk_configuration

#' Describes the user import job
#'
#' @description
#' Describes the user import job.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_import_job/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_import_job/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_import_job
cognitoidentityprovider_describe_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "DescribeUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$describe_user_import_job_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_import_job <- cognitoidentityprovider_describe_user_import_job

#' Returns the configuration information and metadata of the specified user
#' pool
#'
#' @description
#' Returns the configuration information and metadata of the specified user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to describe.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool
cognitoidentityprovider_describe_user_pool <- function(UserPoolId) {
  op <- new_operation(
    name = "DescribeUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$describe_user_pool_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool <- cognitoidentityprovider_describe_user_pool

#' Client method for returning the configuration information and metadata
#' of the specified user pool app client
#'
#' @description
#' Client method for returning the configuration information and metadata of the specified user pool app client.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool_client/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool_client/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to describe.
#' @param ClientId &#91;required&#93; The app client ID of the app associated with the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool_client
cognitoidentityprovider_describe_user_pool_client <- function(UserPoolId, ClientId) {
  op <- new_operation(
    name = "DescribeUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$describe_user_pool_client_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool_client <- cognitoidentityprovider_describe_user_pool_client

#' Gets information about a domain
#'
#' @description
#' Gets information about a domain.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool_domain/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_describe_user_pool_domain/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain string. For custom domains, this is the fully-qualified
#' domain name, such as `auth.example.com`. For Amazon Cognito prefix
#' domains, this is the prefix alone, such as `auth`.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_describe_user_pool_domain
cognitoidentityprovider_describe_user_pool_domain <- function(Domain) {
  op <- new_operation(
    name = "DescribeUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$describe_user_pool_domain_input(Domain = Domain)
  output <- .cognitoidentityprovider$describe_user_pool_domain_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$describe_user_pool_domain <- cognitoidentityprovider_describe_user_pool_domain

#' Forgets the specified device
#'
#' @description
#' Forgets the specified device.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_forget_device/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_forget_device/) for full documentation.
#'
#' @param AccessToken A valid access token that Amazon Cognito issued to the user whose
#' registered device you want to forget.
#' @param DeviceKey &#91;required&#93; The device key.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_forget_device
cognitoidentityprovider_forget_device <- function(AccessToken = NULL, DeviceKey) {
  op <- new_operation(
    name = "ForgetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$forget_device_input(AccessToken = AccessToken, DeviceKey = DeviceKey)
  output <- .cognitoidentityprovider$forget_device_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$forget_device <- cognitoidentityprovider_forget_device

#' Calling this API causes a message to be sent to the end user with a
#' confirmation code that is required to change the user's password
#'
#' @description
#' Calling this API causes a message to be sent to the end user with a confirmation code that is required to change the user's password. For the `Username` parameter, you can use the username or user alias. The method used to send the confirmation code is sent according to the specified AccountRecoverySetting. For more information, see [Recovering User Accounts](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-recover-a-user-account.html) in the *Amazon Cognito Developer Guide*. If neither a verified phone number nor a verified email exists, an `InvalidParameterException` is thrown. To use the confirmation code for resetting the password, call [`confirm_forgot_password`][cognitoidentityprovider_confirm_forgot_password].
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_forgot_password/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_forgot_password/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param Username &#91;required&#93; The user name of the user for whom you want to enter a code to reset a
#' forgotten password.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata that contributes to your metrics
#' for [`forgot_password`][cognitoidentityprovider_forgot_password] calls.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the ForgotPassword API action, Amazon Cognito
#' invokes any functions that are assigned to the following triggers: *pre
#' sign-up*, *custom message*, and *user migration*. When Amazon Cognito
#' invokes any of these functions, it passes a JSON payload, which the
#' function receives as input. This payload contains a `clientMetadata`
#' attribute, which provides the data that you assigned to the
#' ClientMetadata parameter in your ForgotPassword request. In your
#' function code in Lambda, you can process the `clientMetadata` value to
#' enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_forgot_password
cognitoidentityprovider_forgot_password <- function(ClientId, SecretHash = NULL, UserContextData = NULL, Username, AnalyticsMetadata = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "ForgotPassword",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$forgot_password_input(ClientId = ClientId, SecretHash = SecretHash, UserContextData = UserContextData, Username = Username, AnalyticsMetadata = AnalyticsMetadata, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$forgot_password_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$forgot_password <- cognitoidentityprovider_forgot_password

#' Gets the header information for the comma-separated value (CSV) file to
#' be used as input for the user import job
#'
#' @description
#' Gets the header information for the comma-separated value (CSV) file to be used as input for the user import job.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_csv_header/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_csv_header/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are to be imported
#' into.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_csv_header
cognitoidentityprovider_get_csv_header <- function(UserPoolId) {
  op <- new_operation(
    name = "GetCSVHeader",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_csv_header_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_csv_header_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_csv_header <- cognitoidentityprovider_get_csv_header

#' Gets the device
#'
#' @description
#' Gets the device.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_device/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_device/) for full documentation.
#'
#' @param DeviceKey &#91;required&#93; The device key.
#' @param AccessToken A valid access token that Amazon Cognito issued to the user whose device
#' information you want to request.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_device
cognitoidentityprovider_get_device <- function(DeviceKey, AccessToken = NULL) {
  op <- new_operation(
    name = "GetDevice",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_device_input(DeviceKey = DeviceKey, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$get_device_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_device <- cognitoidentityprovider_get_device

#' Gets a group
#'
#' @description
#' Gets a group.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_group
cognitoidentityprovider_get_group <- function(GroupName, UserPoolId) {
  op <- new_operation(
    name = "GetGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_group_input(GroupName = GroupName, UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_group <- cognitoidentityprovider_get_group

#' Gets the specified IdP
#'
#' @description
#' Gets the specified IdP.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_identity_provider_by_identifier/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_identity_provider_by_identifier/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param IdpIdentifier &#91;required&#93; The IdP identifier.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_identity_provider_by_identifier
cognitoidentityprovider_get_identity_provider_by_identifier <- function(UserPoolId, IdpIdentifier) {
  op <- new_operation(
    name = "GetIdentityProviderByIdentifier",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_identity_provider_by_identifier_input(UserPoolId = UserPoolId, IdpIdentifier = IdpIdentifier)
  output <- .cognitoidentityprovider$get_identity_provider_by_identifier_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_identity_provider_by_identifier <- cognitoidentityprovider_get_identity_provider_by_identifier

#' This method takes a user pool ID, and returns the signing certificate
#'
#' @description
#' This method takes a user pool ID, and returns the signing certificate. The issued certificate is valid for 10 years from the date of issue.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_signing_certificate/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_signing_certificate/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_signing_certificate
cognitoidentityprovider_get_signing_certificate <- function(UserPoolId) {
  op <- new_operation(
    name = "GetSigningCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_signing_certificate_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_signing_certificate_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_signing_certificate <- cognitoidentityprovider_get_signing_certificate

#' Gets the user interface (UI) Customization information for a particular
#' app client's app UI, if any such information exists for the client
#'
#' @description
#' Gets the user interface (UI) Customization information for a particular app client's app UI, if any such information exists for the client. If nothing is set for the particular client, but there is an existing pool level customization (the app `clientId` is `ALL`), then that information is returned. If nothing is present, then an empty shape is returned.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_ui_customization/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_ui_customization/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param ClientId The client ID for the client app.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_ui_customization
cognitoidentityprovider_get_ui_customization <- function(UserPoolId, ClientId = NULL) {
  op <- new_operation(
    name = "GetUICustomization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_ui_customization_input(UserPoolId = UserPoolId, ClientId = ClientId)
  output <- .cognitoidentityprovider$get_ui_customization_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_ui_customization <- cognitoidentityprovider_get_ui_customization

#' Gets the user attributes and metadata for a user
#'
#' @description
#' Gets the user attributes and metadata for a user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A non-expired access token for the user whose information you want to
#' query.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user
cognitoidentityprovider_get_user <- function(AccessToken) {
  op <- new_operation(
    name = "GetUser",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$get_user_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user <- cognitoidentityprovider_get_user

#' Generates a user attribute verification code for the specified attribute
#' name
#'
#' @description
#' Generates a user attribute verification code for the specified attribute name. Sends a message to a user with a code that they must return in a VerifyUserAttribute request.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user_attribute_verification_code/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user_attribute_verification_code/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A non-expired access token for the user whose attribute verification
#' code you want to generate.
#' @param AttributeName &#91;required&#93; The attribute name returned by the server response to get the user
#' attribute verification code.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the GetUserAttributeVerificationCode API action,
#' Amazon Cognito invokes the function that is assigned to the *custom
#' message* trigger. When Amazon Cognito invokes this function, it passes a
#' JSON payload, which the function receives as input. This payload
#' contains a `clientMetadata` attribute, which provides the data that you
#' assigned to the ClientMetadata parameter in your
#' GetUserAttributeVerificationCode request. In your function code in
#' Lambda, you can process the `clientMetadata` value to enhance your
#' workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user_attribute_verification_code
cognitoidentityprovider_get_user_attribute_verification_code <- function(AccessToken, AttributeName, ClientMetadata = NULL) {
  op <- new_operation(
    name = "GetUserAttributeVerificationCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_attribute_verification_code_input(AccessToken = AccessToken, AttributeName = AttributeName, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$get_user_attribute_verification_code_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user_attribute_verification_code <- cognitoidentityprovider_get_user_attribute_verification_code

#' Gets the user pool multi-factor authentication (MFA) configuration
#'
#' @description
#' Gets the user pool multi-factor authentication (MFA) configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user_pool_mfa_config/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_get_user_pool_mfa_config/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_get_user_pool_mfa_config
cognitoidentityprovider_get_user_pool_mfa_config <- function(UserPoolId) {
  op <- new_operation(
    name = "GetUserPoolMfaConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$get_user_pool_mfa_config_input(UserPoolId = UserPoolId)
  output <- .cognitoidentityprovider$get_user_pool_mfa_config_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$get_user_pool_mfa_config <- cognitoidentityprovider_get_user_pool_mfa_config

#' Signs out users from all devices
#'
#' @description
#' Signs out users from all devices. It also invalidates all refresh tokens that Amazon Cognito has issued to a user. A user can still use a hosted UI cookie to retrieve new tokens for the duration of the 1-hour cookie validity period.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_global_sign_out/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_global_sign_out/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user who you want
#' to sign out.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_global_sign_out
cognitoidentityprovider_global_sign_out <- function(AccessToken) {
  op <- new_operation(
    name = "GlobalSignOut",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$global_sign_out_input(AccessToken = AccessToken)
  output <- .cognitoidentityprovider$global_sign_out_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$global_sign_out <- cognitoidentityprovider_global_sign_out

#' Initiates sign-in for a user in the Amazon Cognito user directory
#'
#' @description
#' Initiates sign-in for a user in the Amazon Cognito user directory. You can't sign in a user with a federated IdP with [`initiate_auth`][cognitoidentityprovider_initiate_auth]. For more information, see [Adding user pool sign-in through a third party](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-identity-federation.html).
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_initiate_auth/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_initiate_auth/) for full documentation.
#'
#' @param AuthFlow &#91;required&#93; The authentication flow for this call to run. The API action will depend
#' on this value. For example:
#' 
#' -   `REFRESH_TOKEN_AUTH` takes in a valid refresh token and returns new
#'     tokens.
#' 
#' -   `USER_SRP_AUTH` takes in `USERNAME` and `SRP_A` and returns the SRP
#'     variables to be used for next challenge execution.
#' 
#' -   `USER_PASSWORD_AUTH` takes in `USERNAME` and `PASSWORD` and returns
#'     the next challenge or tokens.
#' 
#' Valid values include:
#' 
#' -   `USER_SRP_AUTH`: Authentication flow for the Secure Remote Password
#'     (SRP) protocol.
#' 
#' -   `REFRESH_TOKEN_AUTH`/`REFRESH_TOKEN`: Authentication flow for
#'     refreshing the access token and ID token by supplying a valid
#'     refresh token.
#' 
#' -   `CUSTOM_AUTH`: Custom authentication flow.
#' 
#' -   `USER_PASSWORD_AUTH`: Non-SRP authentication flow; user name and
#'     password are passed directly. If a user migration Lambda trigger is
#'     set, this flow will invoke the user migration Lambda if it doesn't
#'     find the user name in the user pool.
#' 
#' `ADMIN_NO_SRP_AUTH` isn't a valid value.
#' @param AuthParameters The authentication parameters. These are inputs corresponding to the
#' `AuthFlow` that you're invoking. The required values depend on the value
#' of `AuthFlow`:
#' 
#' -   For `USER_SRP_AUTH`: `USERNAME` (required), `SRP_A` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`.
#' 
#' -   For `REFRESH_TOKEN_AUTH/REFRESH_TOKEN`: `REFRESH_TOKEN` (required),
#'     `SECRET_HASH` (required if the app client is configured with a
#'     client secret), `DEVICE_KEY`.
#' 
#' -   For `CUSTOM_AUTH`: `USERNAME` (required), `SECRET_HASH` (if app
#'     client is configured with client secret), `DEVICE_KEY`. To start the
#'     authentication flow with password verification, include
#'     `ChallengeName: SRP_A` and `SRP_A: (The SRP_A Value)`.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for
#' certain custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the InitiateAuth API action, Amazon Cognito
#' invokes the Lambda functions that are specified for various triggers.
#' The ClientMetadata value is passed as input to the functions for only
#' the following triggers:
#' 
#' -   Pre signup
#' 
#' -   Pre authentication
#' 
#' -   User migration
#' 
#' When Amazon Cognito invokes the functions for these triggers, it passes
#' a JSON payload, which the function receives as input. This payload
#' contains a `validationData` attribute, which provides the data that you
#' assigned to the ClientMetadata parameter in your InitiateAuth request.
#' In your function code in Lambda, you can process the `validationData`
#' value to enhance your workflow for your specific needs.
#' 
#' When you use the InitiateAuth API action, Amazon Cognito also invokes
#' the functions for the following triggers, but it doesn't provide the
#' ClientMetadata value as input:
#' 
#' -   Post authentication
#' 
#' -   Custom message
#' 
#' -   Pre token generation
#' 
#' -   Create auth challenge
#' 
#' -   Define auth challenge
#' 
#' -   Verify auth challenge
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#' @param ClientId &#91;required&#93; The app client ID.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata that contributes to your metrics
#' for [`initiate_auth`][cognitoidentityprovider_initiate_auth] calls.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_initiate_auth
cognitoidentityprovider_initiate_auth <- function(AuthFlow, AuthParameters = NULL, ClientMetadata = NULL, ClientId, AnalyticsMetadata = NULL, UserContextData = NULL) {
  op <- new_operation(
    name = "InitiateAuth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$initiate_auth_input(AuthFlow = AuthFlow, AuthParameters = AuthParameters, ClientMetadata = ClientMetadata, ClientId = ClientId, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData)
  output <- .cognitoidentityprovider$initiate_auth_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$initiate_auth <- cognitoidentityprovider_initiate_auth

#' Lists the sign-in devices that Amazon Cognito has registered to the
#' current user
#'
#' @description
#' Lists the sign-in devices that Amazon Cognito has registered to the current user.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_devices/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_devices/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose list
#' of devices you want to view.
#' @param Limit The limit of the device request.
#' @param PaginationToken The pagination token for the list request.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_devices
cognitoidentityprovider_list_devices <- function(AccessToken, Limit = NULL, PaginationToken = NULL) {
  op <- new_operation(
    name = "ListDevices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_devices_input(AccessToken = AccessToken, Limit = Limit, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$list_devices_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_devices <- cognitoidentityprovider_list_devices

#' Lists the groups associated with a user pool
#'
#' @description
#' Lists the groups associated with a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_groups/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_groups/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Limit The limit of the request to list groups.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_groups
cognitoidentityprovider_list_groups <- function(UserPoolId, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_groups_input(UserPoolId = UserPoolId, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_groups_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_groups <- cognitoidentityprovider_list_groups

#' Lists information about all IdPs for a user pool
#'
#' @description
#' Lists information about all IdPs for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_identity_providers/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_identity_providers/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param MaxResults The maximum number of IdPs to return.
#' @param NextToken A pagination token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_identity_providers
cognitoidentityprovider_list_identity_providers <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListIdentityProviders",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_identity_providers_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_identity_providers_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_identity_providers <- cognitoidentityprovider_list_identity_providers

#' Lists the resource servers for a user pool
#'
#' @description
#' Lists the resource servers for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_resource_servers/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_resource_servers/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param MaxResults The maximum number of resource servers to return.
#' @param NextToken A pagination token.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_resource_servers
cognitoidentityprovider_list_resource_servers <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResourceServers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_resource_servers_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_resource_servers_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_resource_servers <- cognitoidentityprovider_list_resource_servers

#' Lists the tags that are assigned to an Amazon Cognito user pool
#'
#' @description
#' Lists the tags that are assigned to an Amazon Cognito user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool that the tags are
#' assigned to.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_tags_for_resource
cognitoidentityprovider_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .cognitoidentityprovider$list_tags_for_resource_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_tags_for_resource <- cognitoidentityprovider_list_tags_for_resource

#' Lists the user import jobs
#'
#' @description
#' Lists the user import jobs.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_import_jobs/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_import_jobs/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param MaxResults &#91;required&#93; The maximum number of import jobs you want the request to return.
#' @param PaginationToken An identifier that was returned from the previous call to
#' [`list_user_import_jobs`][cognitoidentityprovider_list_user_import_jobs],
#' which can be used to return the next set of import jobs in the list.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_import_jobs
cognitoidentityprovider_list_user_import_jobs <- function(UserPoolId, MaxResults, PaginationToken = NULL) {
  op <- new_operation(
    name = "ListUserImportJobs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_import_jobs_input(UserPoolId = UserPoolId, MaxResults = MaxResults, PaginationToken = PaginationToken)
  output <- .cognitoidentityprovider$list_user_import_jobs_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_import_jobs <- cognitoidentityprovider_list_user_import_jobs

#' Lists the clients that have been created for the specified user pool
#'
#' @description
#' Lists the clients that have been created for the specified user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_pool_clients/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_pool_clients/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to list user pool
#' clients.
#' @param MaxResults The maximum number of results you want the request to return when
#' listing the user pool clients.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_pool_clients
cognitoidentityprovider_list_user_pool_clients <- function(UserPoolId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUserPoolClients",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_pool_clients_input(UserPoolId = UserPoolId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_user_pool_clients_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_pool_clients <- cognitoidentityprovider_list_user_pool_clients

#' Lists the user pools associated with an Amazon Web Services account
#'
#' @description
#' Lists the user pools associated with an Amazon Web Services account.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_pools/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_user_pools/) for full documentation.
#'
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#' @param MaxResults &#91;required&#93; The maximum number of results you want the request to return when
#' listing the user pools.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_user_pools
cognitoidentityprovider_list_user_pools <- function(NextToken = NULL, MaxResults) {
  op <- new_operation(
    name = "ListUserPools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_user_pools_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .cognitoidentityprovider$list_user_pools_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_user_pools <- cognitoidentityprovider_list_user_pools

#' Lists the users in the Amazon Cognito user pool
#'
#' @description
#' Lists the users in the Amazon Cognito user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_users/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_users/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool on which the search should be
#' performed.
#' @param AttributesToGet An array of strings, where each string is the name of a user attribute
#' to be returned for each user in the search results. If the array is
#' null, all attributes are returned.
#' @param Limit Maximum number of users to be returned.
#' @param PaginationToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#' @param Filter A filter string of the form "*AttributeName* *Filter-Type*
#' "*AttributeValue*"". Quotation marks within the filter string must be
#' escaped using the backslash (\\) character. For example, "`family_name`
#' = \\"Reddy\\"".
#' 
#' -   *AttributeName*: The name of the attribute to search for. You can
#'     only search for one attribute at a time.
#' 
#' -   *Filter-Type*: For an exact match, use =, for example, "`given_name`
#'     = \\"Jon\\"". For a prefix ("starts with") match, use ^=, for
#'     example, "`given_name` ^= \\"Jon\\"".
#' 
#' -   *AttributeValue*: The attribute value that must be matched for each
#'     user.
#' 
#' If the filter string is empty,
#' [`list_users`][cognitoidentityprovider_list_users] returns all users in
#' the user pool.
#' 
#' You can only search for the following standard attributes:
#' 
#' -   `username` (case-sensitive)
#' 
#' -   `email`
#' 
#' -   `phone_number`
#' 
#' -   `name`
#' 
#' -   `given_name`
#' 
#' -   `family_name`
#' 
#' -   `preferred_username`
#' 
#' -   `cognito:user_status` (called **Status** in the Console)
#'     (case-insensitive)
#' 
#' -   `status (called Enabled in the Console) (case-sensitive)`
#' 
#' -   `sub`
#' 
#' Custom attributes aren't searchable.
#' 
#' You can also list users with a client-side filter. The server-side
#' filter matches no more than one attribute. For an advanced search, use a
#' client-side filter with the `--query` parameter of the `list-users`
#' action in the CLI. When you use a client-side filter, ListUsers returns
#' a paginated list of zero or more users. You can receive multiple pages
#' in a row with zero results. Repeat the query with each pagination token
#' that is returned until you receive a null pagination token value, and
#' then review the combined result.
#' 
#' For more information about server-side and client-side filtering, see
#' [FilteringCLI
#' output](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html)
#' in the [Command Line Interface User
#' Guide](https://docs.aws.amazon.com/cli/latest/userguide/cli-usage-filter.html).
#' 
#' For more information, see [Searching for Users Using the ListUsers
#' API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-using-listusers-api)
#' and [Examples of Using the ListUsers
#' API](https://docs.aws.amazon.com/cognito/latest/developerguide/how-to-manage-user-accounts.html#cognito-user-pools-searching-for-users-listusers-api-examples)
#' in the *Amazon Cognito Developer Guide*.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_users
cognitoidentityprovider_list_users <- function(UserPoolId, AttributesToGet = NULL, Limit = NULL, PaginationToken = NULL, Filter = NULL) {
  op <- new_operation(
    name = "ListUsers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_users_input(UserPoolId = UserPoolId, AttributesToGet = AttributesToGet, Limit = Limit, PaginationToken = PaginationToken, Filter = Filter)
  output <- .cognitoidentityprovider$list_users_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_users <- cognitoidentityprovider_list_users

#' Lists the users in the specified group
#'
#' @description
#' Lists the users in the specified group.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_users_in_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_list_users_in_group/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param GroupName &#91;required&#93; The name of the group.
#' @param Limit The limit of the request to list users.
#' @param NextToken An identifier that was returned from the previous call to this
#' operation, which can be used to return the next set of items in the
#' list.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_list_users_in_group
cognitoidentityprovider_list_users_in_group <- function(UserPoolId, GroupName, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListUsersInGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$list_users_in_group_input(UserPoolId = UserPoolId, GroupName = GroupName, Limit = Limit, NextToken = NextToken)
  output <- .cognitoidentityprovider$list_users_in_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$list_users_in_group <- cognitoidentityprovider_list_users_in_group

#' Resends the confirmation (for confirmation of registration) to a
#' specific user in the user pool
#'
#' @description
#' Resends the confirmation (for confirmation of registration) to a specific user in the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_resend_confirmation_code/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_resend_confirmation_code/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param Username &#91;required&#93; The `username` attribute of the user to whom you want to resend a
#' confirmation code.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata that contributes to your metrics
#' for
#' [`resend_confirmation_code`][cognitoidentityprovider_resend_confirmation_code]
#' calls.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the ResendConfirmationCode API action, Amazon
#' Cognito invokes the function that is assigned to the *custom message*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your ResendConfirmationCode request. In
#' your function code in Lambda, you can process the `clientMetadata` value
#' to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_resend_confirmation_code
cognitoidentityprovider_resend_confirmation_code <- function(ClientId, SecretHash = NULL, UserContextData = NULL, Username, AnalyticsMetadata = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "ResendConfirmationCode",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$resend_confirmation_code_input(ClientId = ClientId, SecretHash = SecretHash, UserContextData = UserContextData, Username = Username, AnalyticsMetadata = AnalyticsMetadata, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$resend_confirmation_code_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$resend_confirmation_code <- cognitoidentityprovider_resend_confirmation_code

#' Responds to the authentication challenge
#'
#' @description
#' Responds to the authentication challenge.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_respond_to_auth_challenge/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_respond_to_auth_challenge/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The app client ID.
#' @param ChallengeName &#91;required&#93; The challenge name. For more information, see
#' [`initiate_auth`][cognitoidentityprovider_initiate_auth].
#' 
#' `ADMIN_NO_SRP_AUTH` isn't a valid value.
#' @param Session The session that should be passed both ways in challenge-response calls
#' to the service. If
#' [`initiate_auth`][cognitoidentityprovider_initiate_auth] or
#' [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge]
#' API call determines that the caller must pass another challenge, they
#' return a session with other challenge parameters. This session should be
#' passed as it is to the next
#' [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge]
#' API call.
#' @param ChallengeResponses The challenge responses. These are inputs corresponding to the value of
#' `ChallengeName`, for example:
#' 
#' `SECRET_HASH` (if app client is configured with client secret) applies
#' to all of the inputs that follow (including `SOFTWARE_TOKEN_MFA`).
#' 
#' -   `SMS_MFA`: `SMS_MFA_CODE`, `USERNAME`.
#' 
#' -   `PASSWORD_VERIFIER`: `PASSWORD_CLAIM_SIGNATURE`,
#'     `PASSWORD_CLAIM_SECRET_BLOCK`, `TIMESTAMP`, `USERNAME`.
#' 
#'     `PASSWORD_VERIFIER` requires `DEVICE_KEY` when you sign in with a
#'     remembered device.
#' 
#' -   `NEW_PASSWORD_REQUIRED`: `NEW_PASSWORD`, `USERNAME`, `SECRET_HASH`
#'     (if app client is configured with client secret). To set any
#'     required attributes that Amazon Cognito returned as
#'     `requiredAttributes` in the
#'     [`initiate_auth`][cognitoidentityprovider_initiate_auth] response,
#'     add a `userAttributes.attributename ` parameter. This parameter can
#'     also set values for writable attributes that aren't required by your
#'     user pool.
#' 
#'     In a `NEW_PASSWORD_REQUIRED` challenge response, you can't modify a
#'     required attribute that already has a value. In
#'     [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge],
#'     set a value for any keys that Amazon Cognito returned in the
#'     `requiredAttributes` parameter, then use the
#'     [`update_user_attributes`][cognitoidentityprovider_update_user_attributes]
#'     API operation to modify the value of any additional attributes.
#' 
#' -   `SOFTWARE_TOKEN_MFA`: `USERNAME` and `SOFTWARE_TOKEN_MFA_CODE` are
#'     required attributes.
#' 
#' -   `DEVICE_SRP_AUTH` requires `USERNAME`, `DEVICE_KEY`, `SRP_A` (and
#'     `SECRET_HASH`).
#' 
#' -   `DEVICE_PASSWORD_VERIFIER` requires everything that
#'     `PASSWORD_VERIFIER` requires, plus `DEVICE_KEY`.
#' 
#' -   `MFA_SETUP` requires `USERNAME`, plus you must use the session value
#'     returned by
#'     [`verify_software_token`][cognitoidentityprovider_verify_software_token]
#'     in the `Session` parameter.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata that contributes to your metrics
#' for
#' [`respond_to_auth_challenge`][cognitoidentityprovider_respond_to_auth_challenge]
#' calls.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the RespondToAuthChallenge API action, Amazon
#' Cognito invokes any functions that are assigned to the following
#' triggers: *post authentication*, *pre token generation*, *define auth
#' challenge*, *create auth challenge*, and *verify auth challenge*. When
#' Amazon Cognito invokes any of these functions, it passes a JSON payload,
#' which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your RespondToAuthChallenge request. In
#' your function code in Lambda, you can process the `clientMetadata` value
#' to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_respond_to_auth_challenge
cognitoidentityprovider_respond_to_auth_challenge <- function(ClientId, ChallengeName, Session = NULL, ChallengeResponses = NULL, AnalyticsMetadata = NULL, UserContextData = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "RespondToAuthChallenge",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$respond_to_auth_challenge_input(ClientId = ClientId, ChallengeName = ChallengeName, Session = Session, ChallengeResponses = ChallengeResponses, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$respond_to_auth_challenge_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$respond_to_auth_challenge <- cognitoidentityprovider_respond_to_auth_challenge

#' Revokes all of the access tokens generated by, and at the same time as,
#' the specified refresh token
#'
#' @description
#' Revokes all of the access tokens generated by, and at the same time as, the specified refresh token. After a token is revoked, you can't use the revoked token to access Amazon Cognito user APIs, or to authorize access to your resource server.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_revoke_token/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_revoke_token/) for full documentation.
#'
#' @param Token &#91;required&#93; The refresh token that you want to revoke.
#' @param ClientId &#91;required&#93; The client ID for the token that you want to revoke.
#' @param ClientSecret The secret for the client ID. This is required only if the client ID has
#' a secret.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_revoke_token
cognitoidentityprovider_revoke_token <- function(Token, ClientId, ClientSecret = NULL) {
  op <- new_operation(
    name = "RevokeToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$revoke_token_input(Token = Token, ClientId = ClientId, ClientSecret = ClientSecret)
  output <- .cognitoidentityprovider$revoke_token_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$revoke_token <- cognitoidentityprovider_revoke_token

#' Configures actions on detected risks
#'
#' @description
#' Configures actions on detected risks. To delete the risk configuration for `UserPoolId` or `ClientId`, pass null values for all four configuration types.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_risk_configuration/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_risk_configuration/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ClientId The app client ID. If `ClientId` is null, then the risk configuration is
#' mapped to `userPoolId`. When the client ID is null, the same risk
#' configuration is applied to all the clients in the userPool.
#' 
#' Otherwise, `ClientId` is mapped to the client. When the client ID isn't
#' null, the user pool configuration is overridden and the risk
#' configuration for the client is used instead.
#' @param CompromisedCredentialsRiskConfiguration The compromised credentials risk configuration.
#' @param AccountTakeoverRiskConfiguration The account takeover risk configuration.
#' @param RiskExceptionConfiguration The configuration to override the risk decision.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_risk_configuration
cognitoidentityprovider_set_risk_configuration <- function(UserPoolId, ClientId = NULL, CompromisedCredentialsRiskConfiguration = NULL, AccountTakeoverRiskConfiguration = NULL, RiskExceptionConfiguration = NULL) {
  op <- new_operation(
    name = "SetRiskConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_risk_configuration_input(UserPoolId = UserPoolId, ClientId = ClientId, CompromisedCredentialsRiskConfiguration = CompromisedCredentialsRiskConfiguration, AccountTakeoverRiskConfiguration = AccountTakeoverRiskConfiguration, RiskExceptionConfiguration = RiskExceptionConfiguration)
  output <- .cognitoidentityprovider$set_risk_configuration_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_risk_configuration <- cognitoidentityprovider_set_risk_configuration

#' Sets the user interface (UI) customization information for a user pool's
#' built-in app UI
#'
#' @description
#' Sets the user interface (UI) customization information for a user pool's built-in app UI.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_ui_customization/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_ui_customization/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param ClientId The client ID for the client app.
#' @param CSS The CSS values in the UI customization.
#' @param ImageFile The uploaded logo image for the UI customization.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_ui_customization
cognitoidentityprovider_set_ui_customization <- function(UserPoolId, ClientId = NULL, CSS = NULL, ImageFile = NULL) {
  op <- new_operation(
    name = "SetUICustomization",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_ui_customization_input(UserPoolId = UserPoolId, ClientId = ClientId, CSS = CSS, ImageFile = ImageFile)
  output <- .cognitoidentityprovider$set_ui_customization_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_ui_customization <- cognitoidentityprovider_set_ui_customization

#' Set the user's multi-factor authentication (MFA) method preference,
#' including which MFA factors are activated and if any are preferred
#'
#' @description
#' Set the user's multi-factor authentication (MFA) method preference, including which MFA factors are activated and if any are preferred. Only one factor can be set as preferred. The preferred MFA factor will be used to authenticate a user if multiple factors are activated. If multiple options are activated and no preference is set, a challenge to choose an MFA option will be returned during sign-in. If an MFA type is activated for a user, the user will be prompted for MFA during all sign-in attempts unless device tracking is turned on and the device has been trusted. If you want MFA to be applied selectively based on the assessed risk level of sign-in attempts, deactivate MFA for users and turn on Adaptive Authentication for the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_mfa_preference/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_mfa_preference/) for full documentation.
#'
#' @param SMSMfaSettings The SMS text message multi-factor authentication (MFA) settings.
#' @param SoftwareTokenMfaSettings The time-based one-time password (TOTP) software token MFA settings.
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose MFA
#' preference you want to set.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_mfa_preference
cognitoidentityprovider_set_user_mfa_preference <- function(SMSMfaSettings = NULL, SoftwareTokenMfaSettings = NULL, AccessToken) {
  op <- new_operation(
    name = "SetUserMFAPreference",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_mfa_preference_input(SMSMfaSettings = SMSMfaSettings, SoftwareTokenMfaSettings = SoftwareTokenMfaSettings, AccessToken = AccessToken)
  output <- .cognitoidentityprovider$set_user_mfa_preference_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_mfa_preference <- cognitoidentityprovider_set_user_mfa_preference

#' Sets the user pool multi-factor authentication (MFA) configuration
#'
#' @description
#' Sets the user pool multi-factor authentication (MFA) configuration.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_pool_mfa_config/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_pool_mfa_config/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param SmsMfaConfiguration The SMS text message MFA configuration.
#' @param SoftwareTokenMfaConfiguration The software token MFA configuration.
#' @param MfaConfiguration The MFA configuration. If you set the MfaConfiguration value to ‘ON’,
#' only users who have set up an MFA factor can sign in. To learn more, see
#' [Adding Multi-Factor Authentication (MFA) to a user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-mfa.html).
#' Valid values include:
#' 
#' -   `OFF` MFA won't be used for any users.
#' 
#' -   `ON` MFA is required for all users to sign in.
#' 
#' -   `OPTIONAL` MFA will be required only for individual users who have
#'     an MFA factor activated.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_pool_mfa_config
cognitoidentityprovider_set_user_pool_mfa_config <- function(UserPoolId, SmsMfaConfiguration = NULL, SoftwareTokenMfaConfiguration = NULL, MfaConfiguration = NULL) {
  op <- new_operation(
    name = "SetUserPoolMfaConfig",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_pool_mfa_config_input(UserPoolId = UserPoolId, SmsMfaConfiguration = SmsMfaConfiguration, SoftwareTokenMfaConfiguration = SoftwareTokenMfaConfiguration, MfaConfiguration = MfaConfiguration)
  output <- .cognitoidentityprovider$set_user_pool_mfa_config_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_pool_mfa_config <- cognitoidentityprovider_set_user_pool_mfa_config

#' This action is no longer supported
#'
#' @description
#' *This action is no longer supported.* You can use it to configure only SMS MFA. You can't use it to configure time-based one-time password (TOTP) software token MFA. To configure either type of MFA, use [`set_user_mfa_preference`][cognitoidentityprovider_set_user_mfa_preference] instead.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_settings/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_set_user_settings/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose user
#' settings you want to configure.
#' @param MFAOptions &#91;required&#93; You can use this parameter only to set an SMS configuration that uses
#' SMS for delivery.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_set_user_settings
cognitoidentityprovider_set_user_settings <- function(AccessToken, MFAOptions) {
  op <- new_operation(
    name = "SetUserSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$set_user_settings_input(AccessToken = AccessToken, MFAOptions = MFAOptions)
  output <- .cognitoidentityprovider$set_user_settings_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$set_user_settings <- cognitoidentityprovider_set_user_settings

#' Registers the user in the specified user pool and creates a user name,
#' password, and user attributes
#'
#' @description
#' Registers the user in the specified user pool and creates a user name, password, and user attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_sign_up/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_sign_up/) for full documentation.
#'
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param SecretHash A keyed-hash message authentication code (HMAC) calculated using the
#' secret key of a user pool client and username plus the client ID in the
#' message.
#' @param Username &#91;required&#93; The user name of the user you want to register.
#' @param Password &#91;required&#93; The password of the user you want to register.
#' @param UserAttributes An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' @param ValidationData The validation data in the request to register a user.
#' @param AnalyticsMetadata The Amazon Pinpoint analytics metadata that contributes to your metrics
#' for [`sign_up`][cognitoidentityprovider_sign_up] calls.
#' @param UserContextData Contextual data about your user session, such as the device fingerprint,
#' IP address, or location. Amazon Cognito advanced security evaluates the
#' risk of an authentication event based on the context that your app
#' generates and passes to Amazon Cognito when it makes API requests.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action triggers.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the SignUp API action, Amazon Cognito invokes any
#' functions that are assigned to the following triggers: *pre sign-up*,
#' *custom message*, and *post confirmation*. When Amazon Cognito invokes
#' any of these functions, it passes a JSON payload, which the function
#' receives as input. This payload contains a `clientMetadata` attribute,
#' which provides the data that you assigned to the ClientMetadata
#' parameter in your SignUp request. In your function code in Lambda, you
#' can process the `clientMetadata` value to enhance your workflow for your
#' specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_sign_up
cognitoidentityprovider_sign_up <- function(ClientId, SecretHash = NULL, Username, Password, UserAttributes = NULL, ValidationData = NULL, AnalyticsMetadata = NULL, UserContextData = NULL, ClientMetadata = NULL) {
  op <- new_operation(
    name = "SignUp",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$sign_up_input(ClientId = ClientId, SecretHash = SecretHash, Username = Username, Password = Password, UserAttributes = UserAttributes, ValidationData = ValidationData, AnalyticsMetadata = AnalyticsMetadata, UserContextData = UserContextData, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$sign_up_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$sign_up <- cognitoidentityprovider_sign_up

#' Starts the user import
#'
#' @description
#' Starts the user import.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_start_user_import_job/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_start_user_import_job/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_start_user_import_job
cognitoidentityprovider_start_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "StartUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$start_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$start_user_import_job_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$start_user_import_job <- cognitoidentityprovider_start_user_import_job

#' Stops the user import job
#'
#' @description
#' Stops the user import job.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_stop_user_import_job/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_stop_user_import_job/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool that the users are being imported
#' into.
#' @param JobId &#91;required&#93; The job ID for the user import job.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_stop_user_import_job
cognitoidentityprovider_stop_user_import_job <- function(UserPoolId, JobId) {
  op <- new_operation(
    name = "StopUserImportJob",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$stop_user_import_job_input(UserPoolId = UserPoolId, JobId = JobId)
  output <- .cognitoidentityprovider$stop_user_import_job_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$stop_user_import_job <- cognitoidentityprovider_stop_user_import_job

#' Assigns a set of tags to an Amazon Cognito user pool
#'
#' @description
#' Assigns a set of tags to an Amazon Cognito user pool. A tag is a label that you can use to categorize and manage user pools in different ways, such as by purpose, owner, environment, or other criteria.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_tag_resource/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool to assign the tags to.
#' @param Tags &#91;required&#93; The tags to assign to the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_tag_resource
cognitoidentityprovider_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .cognitoidentityprovider$tag_resource_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$tag_resource <- cognitoidentityprovider_tag_resource

#' Removes the specified tags from an Amazon Cognito user pool
#'
#' @description
#' Removes the specified tags from an Amazon Cognito user pool. You can use this action up to 5 times per second, per account.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_untag_resource/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the user pool that the tags are
#' assigned to.
#' @param TagKeys &#91;required&#93; The keys of the tags to remove from the user pool.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_untag_resource
cognitoidentityprovider_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .cognitoidentityprovider$untag_resource_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$untag_resource <- cognitoidentityprovider_untag_resource

#' Provides the feedback for an authentication event, whether it was from a
#' valid user or not
#'
#' @description
#' Provides the feedback for an authentication event, whether it was from a valid user or not. This feedback is used for improving the risk evaluation decision for the user pool as part of Amazon Cognito advanced security.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_auth_event_feedback/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_auth_event_feedback/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param Username &#91;required&#93; The user pool username.
#' @param EventId &#91;required&#93; The event ID.
#' @param FeedbackToken &#91;required&#93; The feedback token.
#' @param FeedbackValue &#91;required&#93; The authentication event feedback value.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_auth_event_feedback
cognitoidentityprovider_update_auth_event_feedback <- function(UserPoolId, Username, EventId, FeedbackToken, FeedbackValue) {
  op <- new_operation(
    name = "UpdateAuthEventFeedback",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_auth_event_feedback_input(UserPoolId = UserPoolId, Username = Username, EventId = EventId, FeedbackToken = FeedbackToken, FeedbackValue = FeedbackValue)
  output <- .cognitoidentityprovider$update_auth_event_feedback_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_auth_event_feedback <- cognitoidentityprovider_update_auth_event_feedback

#' Updates the device status
#'
#' @description
#' Updates the device status.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_device_status/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_device_status/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose device
#' status you want to update.
#' @param DeviceKey &#91;required&#93; The device key.
#' @param DeviceRememberedStatus The status of whether a device is remembered.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_device_status
cognitoidentityprovider_update_device_status <- function(AccessToken, DeviceKey, DeviceRememberedStatus = NULL) {
  op <- new_operation(
    name = "UpdateDeviceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_device_status_input(AccessToken = AccessToken, DeviceKey = DeviceKey, DeviceRememberedStatus = DeviceRememberedStatus)
  output <- .cognitoidentityprovider$update_device_status_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_device_status <- cognitoidentityprovider_update_device_status

#' Updates the specified group with the specified attributes
#'
#' @description
#' Updates the specified group with the specified attributes.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_group/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Description A string containing the new description of the group.
#' @param RoleArn The new role Amazon Resource Name (ARN) for the group. This is used for
#' setting the `cognito:roles` and `cognito:preferred_role` claims in the
#' token.
#' @param Precedence The new precedence value for the group. For more information about this
#' parameter, see [`create_group`][cognitoidentityprovider_create_group].
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_group
cognitoidentityprovider_update_group <- function(GroupName, UserPoolId, Description = NULL, RoleArn = NULL, Precedence = NULL) {
  op <- new_operation(
    name = "UpdateGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_group_input(GroupName = GroupName, UserPoolId = UserPoolId, Description = Description, RoleArn = RoleArn, Precedence = Precedence)
  output <- .cognitoidentityprovider$update_group_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_group <- cognitoidentityprovider_update_group

#' Updates IdP information for a user pool
#'
#' @description
#' Updates IdP information for a user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_identity_provider/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_identity_provider/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID.
#' @param ProviderName &#91;required&#93; The IdP name.
#' @param ProviderDetails The IdP details to be updated, such as `MetadataURL` and `MetadataFile`.
#' @param AttributeMapping The IdP attribute mapping to be changed.
#' @param IdpIdentifiers A list of IdP identifiers.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_identity_provider
cognitoidentityprovider_update_identity_provider <- function(UserPoolId, ProviderName, ProviderDetails = NULL, AttributeMapping = NULL, IdpIdentifiers = NULL) {
  op <- new_operation(
    name = "UpdateIdentityProvider",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_identity_provider_input(UserPoolId = UserPoolId, ProviderName = ProviderName, ProviderDetails = ProviderDetails, AttributeMapping = AttributeMapping, IdpIdentifiers = IdpIdentifiers)
  output <- .cognitoidentityprovider$update_identity_provider_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_identity_provider <- cognitoidentityprovider_update_identity_provider

#' Updates the name and scopes of resource server
#'
#' @description
#' Updates the name and scopes of resource server. All other fields are read-only.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_resource_server/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_resource_server/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool.
#' @param Identifier &#91;required&#93; The identifier for the resource server.
#' @param Name &#91;required&#93; The name of the resource server.
#' @param Scopes The scope values to be set for the resource server.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_resource_server
cognitoidentityprovider_update_resource_server <- function(UserPoolId, Identifier, Name, Scopes = NULL) {
  op <- new_operation(
    name = "UpdateResourceServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_resource_server_input(UserPoolId = UserPoolId, Identifier = Identifier, Name = Name, Scopes = Scopes)
  output <- .cognitoidentityprovider$update_resource_server_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_resource_server <- cognitoidentityprovider_update_resource_server

#' Allows a user to update a specific attribute (one at a time)
#'
#' @description
#' Allows a user to update a specific attribute (one at a time).
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_attributes/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_attributes/) for full documentation.
#'
#' @param UserAttributes &#91;required&#93; An array of name-value pairs representing user attributes.
#' 
#' For custom attributes, you must prepend the `custom:` prefix to the
#' attribute name.
#' 
#' If you have set an attribute to require verification before Amazon
#' Cognito updates its value, this request doesn’t immediately update the
#' value of that attribute. After your user receives and responds to a
#' verification message to verify the new value, Amazon Cognito updates the
#' attribute value. Your user can sign in and receive messages with the
#' original attribute value until they verify the new value.
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose user
#' attributes you want to update.
#' @param ClientMetadata A map of custom key-value pairs that you can provide as input for any
#' custom workflows that this action initiates.
#' 
#' You create custom workflows by assigning Lambda functions to user pool
#' triggers. When you use the UpdateUserAttributes API action, Amazon
#' Cognito invokes the function that is assigned to the *custom message*
#' trigger. When Amazon Cognito invokes this function, it passes a JSON
#' payload, which the function receives as input. This payload contains a
#' `clientMetadata` attribute, which provides the data that you assigned to
#' the ClientMetadata parameter in your UpdateUserAttributes request. In
#' your function code in Lambda, you can process the `clientMetadata` value
#' to enhance your workflow for your specific needs.
#' 
#' For more information, see [Customizing user pool Workflows with Lambda
#' Triggers](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-identity-pools-working-with-aws-lambda-triggers.html)
#' in the *Amazon Cognito Developer Guide*.
#' 
#' When you use the ClientMetadata parameter, remember that Amazon Cognito
#' won't do the following:
#' 
#' -   Store the ClientMetadata value. This data is available only to
#'     Lambda triggers that are assigned to a user pool to support custom
#'     workflows. If your user pool configuration doesn't include triggers,
#'     the ClientMetadata parameter serves no purpose.
#' 
#' -   Validate the ClientMetadata value.
#' 
#' -   Encrypt the ClientMetadata value. Don't use Amazon Cognito to
#'     provide sensitive information.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_attributes
cognitoidentityprovider_update_user_attributes <- function(UserAttributes, AccessToken, ClientMetadata = NULL) {
  op <- new_operation(
    name = "UpdateUserAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_attributes_input(UserAttributes = UserAttributes, AccessToken = AccessToken, ClientMetadata = ClientMetadata)
  output <- .cognitoidentityprovider$update_user_attributes_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_attributes <- cognitoidentityprovider_update_user_attributes

#' Updates the specified user pool with the specified attributes
#'
#' @description
#' Updates the specified user pool with the specified attributes. You can get a list of the current user pool settings using [`describe_user_pool`][cognitoidentityprovider_describe_user_pool]. If you don't provide a value for an attribute, it will be set to the default value.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool you want to update.
#' @param Policies A container with the policies you want to update in a user pool.
#' @param DeletionProtection When active, `DeletionProtection` prevents accidental deletion of your
#' user pool. Before you can delete a user pool that you have protected
#' against deletion, you must deactivate this feature.
#' 
#' When you try to delete a protected user pool in a
#' [`delete_user_pool`][cognitoidentityprovider_delete_user_pool] API
#' request, Amazon Cognito returns an `InvalidParameterException` error. To
#' delete a protected user pool, send a new
#' [`delete_user_pool`][cognitoidentityprovider_delete_user_pool] request
#' after you deactivate deletion protection in an
#' [`update_user_pool`][cognitoidentityprovider_update_user_pool] API
#' request.
#' @param LambdaConfig The Lambda configuration information from the request to update the user
#' pool.
#' @param AutoVerifiedAttributes The attributes that are automatically verified when Amazon Cognito
#' requests to update user pools.
#' @param SmsVerificationMessage This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param EmailVerificationMessage This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param EmailVerificationSubject This parameter is no longer used. See
#' [VerificationMessageTemplateType](https://docs.aws.amazon.com/cognito-user-identity-pools/latest/APIReference/API_VerificationMessageTemplateType.html).
#' @param VerificationMessageTemplate The template for verification messages.
#' @param SmsAuthenticationMessage The contents of the SMS authentication message.
#' @param UserAttributeUpdateSettings The settings for updates to user attributes. These settings include the
#' property `AttributesRequireVerificationBeforeUpdate`, a user-pool
#' setting that tells Amazon Cognito how to handle changes to the value of
#' your users' email address and phone number attributes. For more
#' information, see [Verifying updates to email addresses and phone
#' numbers](https://docs.aws.amazon.com/cognito/latest/developerguide/user-pool-settings-email-phone-verification.html#user-pool-settings-verifications-verify-attribute-updates).
#' @param MfaConfiguration Possible values include:
#' 
#' -   `OFF` - MFA tokens aren't required and can't be specified during
#'     user registration.
#' 
#' -   `ON` - MFA tokens are required for all user registrations. You can
#'     only specify ON when you're initially creating a user pool. You can
#'     use the
#'     [`set_user_pool_mfa_config`][cognitoidentityprovider_set_user_pool_mfa_config]
#'     API operation to turn MFA "ON" for existing user pools.
#' 
#' -   `OPTIONAL` - Users have the option when registering to create an MFA
#'     token.
#' @param DeviceConfiguration The device-remembering configuration for a user pool. A null value
#' indicates that you have deactivated device remembering in your user
#' pool.
#' 
#' When you provide a value for any `DeviceConfiguration` field, you
#' activate the Amazon Cognito device-remembering feature.
#' @param EmailConfiguration The email configuration of your user pool. The email configuration type
#' sets your preferred sending method, Amazon Web Services Region, and
#' sender for email invitation and verification messages from your user
#' pool.
#' @param SmsConfiguration The SMS configuration with the settings that your Amazon Cognito user
#' pool must use to send an SMS message from your Amazon Web Services
#' account through Amazon Simple Notification Service. To send SMS messages
#' with Amazon SNS in the Amazon Web Services Region that you want, the
#' Amazon Cognito user pool uses an Identity and Access Management (IAM)
#' role in your Amazon Web Services account.
#' @param UserPoolTags The tag keys and values to assign to the user pool. A tag is a label
#' that you can use to categorize and manage user pools in different ways,
#' such as by purpose, owner, environment, or other criteria.
#' @param AdminCreateUserConfig The configuration for
#' [`admin_create_user`][cognitoidentityprovider_admin_create_user]
#' requests.
#' @param UserPoolAddOns Enables advanced security risk detection. Set the key
#' `AdvancedSecurityMode` to the value "AUDIT".
#' @param AccountRecoverySetting The available verified method a user can use to recover their password
#' when they call
#' [`forgot_password`][cognitoidentityprovider_forgot_password]. You can
#' use this setting to define a preferred method when a user has more than
#' one method available. With this setting, SMS doesn't qualify for a valid
#' password recovery mechanism if the user also has SMS multi-factor
#' authentication (MFA) activated. In the absence of this setting, Amazon
#' Cognito uses the legacy behavior to determine the recovery method where
#' SMS is preferred through email.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool
cognitoidentityprovider_update_user_pool <- function(UserPoolId, Policies = NULL, DeletionProtection = NULL, LambdaConfig = NULL, AutoVerifiedAttributes = NULL, SmsVerificationMessage = NULL, EmailVerificationMessage = NULL, EmailVerificationSubject = NULL, VerificationMessageTemplate = NULL, SmsAuthenticationMessage = NULL, UserAttributeUpdateSettings = NULL, MfaConfiguration = NULL, DeviceConfiguration = NULL, EmailConfiguration = NULL, SmsConfiguration = NULL, UserPoolTags = NULL, AdminCreateUserConfig = NULL, UserPoolAddOns = NULL, AccountRecoverySetting = NULL) {
  op <- new_operation(
    name = "UpdateUserPool",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_input(UserPoolId = UserPoolId, Policies = Policies, DeletionProtection = DeletionProtection, LambdaConfig = LambdaConfig, AutoVerifiedAttributes = AutoVerifiedAttributes, SmsVerificationMessage = SmsVerificationMessage, EmailVerificationMessage = EmailVerificationMessage, EmailVerificationSubject = EmailVerificationSubject, VerificationMessageTemplate = VerificationMessageTemplate, SmsAuthenticationMessage = SmsAuthenticationMessage, UserAttributeUpdateSettings = UserAttributeUpdateSettings, MfaConfiguration = MfaConfiguration, DeviceConfiguration = DeviceConfiguration, EmailConfiguration = EmailConfiguration, SmsConfiguration = SmsConfiguration, UserPoolTags = UserPoolTags, AdminCreateUserConfig = AdminCreateUserConfig, UserPoolAddOns = UserPoolAddOns, AccountRecoverySetting = AccountRecoverySetting)
  output <- .cognitoidentityprovider$update_user_pool_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool <- cognitoidentityprovider_update_user_pool

#' Updates the specified user pool app client with the specified attributes
#'
#' @description
#' Updates the specified user pool app client with the specified attributes. You can get a list of the current user pool app client settings using [`describe_user_pool_client`][cognitoidentityprovider_describe_user_pool_client].
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool_client/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool_client/) for full documentation.
#'
#' @param UserPoolId &#91;required&#93; The user pool ID for the user pool where you want to update the user
#' pool client.
#' @param ClientId &#91;required&#93; The ID of the client associated with the user pool.
#' @param ClientName The client name from the update user pool client request.
#' @param RefreshTokenValidity The refresh token time limit. After this limit expires, your user can't
#' use their refresh token. To specify the time unit for
#' `RefreshTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set
#' a `TokenValidityUnits` value in your API request.
#' 
#' For example, when you set `RefreshTokenValidity` as `10` and
#' `TokenValidityUnits` as `days`, your user can refresh their session and
#' retrieve new access and ID tokens for 10 days.
#' 
#' The default time unit for `RefreshTokenValidity` in an API request is
#' days. You can't set `RefreshTokenValidity` to 0. If you do, Amazon
#' Cognito overrides the value with the default value of 30 days. *Valid
#' range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your refresh tokens are valid for 30 days.
#' @param AccessTokenValidity The access token time limit. After this limit expires, your user can't
#' use their access token. To specify the time unit for
#' `AccessTokenValidity` as `seconds`, `minutes`, `hours`, or `days`, set a
#' `TokenValidityUnits` value in your API request.
#' 
#' For example, when you set `AccessTokenValidity` to `10` and
#' `TokenValidityUnits` to `hours`, your user can authorize access with
#' their access token for 10 hours.
#' 
#' The default time unit for `AccessTokenValidity` in an API request is
#' hours. *Valid range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your access tokens are valid for one hour.
#' @param IdTokenValidity The ID token time limit. After this limit expires, your user can't use
#' their ID token. To specify the time unit for `IdTokenValidity` as
#' `seconds`, `minutes`, `hours`, or `days`, set a `TokenValidityUnits`
#' value in your API request.
#' 
#' For example, when you set `IdTokenValidity` as `10` and
#' `TokenValidityUnits` as `hours`, your user can authenticate their
#' session with their ID token for 10 hours.
#' 
#' The default time unit for `AccessTokenValidity` in an API request is
#' hours. *Valid range* is displayed below in seconds.
#' 
#' If you don't specify otherwise in the configuration of your app client,
#' your ID tokens are valid for one hour.
#' @param TokenValidityUnits The units in which the validity times are represented. The default unit
#' for RefreshToken is days, and the default for ID and access tokens is
#' hours.
#' @param ReadAttributes The read-only attributes of the user pool.
#' @param WriteAttributes The writeable attributes of the user pool.
#' @param ExplicitAuthFlows The authentication flows that you want your user pool client to support.
#' For each app client in your user pool, you can sign in your users with
#' any combination of one or more flows, including with a user name and
#' Secure Remote Password (SRP), a user name and password, or a custom
#' authentication process that you define with Lambda functions.
#' 
#' If you don't specify a value for `ExplicitAuthFlows`, your user client
#' supports `ALLOW_REFRESH_TOKEN_AUTH`, `ALLOW_USER_SRP_AUTH`, and
#' `ALLOW_CUSTOM_AUTH`.
#' 
#' Valid values include:
#' 
#' -   `ALLOW_ADMIN_USER_PASSWORD_AUTH`: Enable admin based user password
#'     authentication flow `ADMIN_USER_PASSWORD_AUTH`. This setting
#'     replaces the `ADMIN_NO_SRP_AUTH` setting. With this authentication
#'     flow, your app passes a user name and password to Amazon Cognito in
#'     the request, instead of using the Secure Remote Password (SRP)
#'     protocol to securely transmit the password.
#' 
#' -   `ALLOW_CUSTOM_AUTH`: Enable Lambda trigger based authentication.
#' 
#' -   `ALLOW_USER_PASSWORD_AUTH`: Enable user password-based
#'     authentication. In this flow, Amazon Cognito receives the password
#'     in the request instead of using the SRP protocol to verify
#'     passwords.
#' 
#' -   `ALLOW_USER_SRP_AUTH`: Enable SRP-based authentication.
#' 
#' -   `ALLOW_REFRESH_TOKEN_AUTH`: Enable authflow to refresh tokens.
#' 
#' In some environments, you will see the values `ADMIN_NO_SRP_AUTH`,
#' `CUSTOM_AUTH_FLOW_ONLY`, or `USER_PASSWORD_AUTH`. You can't assign these
#' legacy `ExplicitAuthFlows` values to user pool clients at the same time
#' as values that begin with `ALLOW_`, like `ALLOW_USER_SRP_AUTH`.
#' @param SupportedIdentityProviders A list of provider names for the IdPs that this client supports. The
#' following are supported: `COGNITO`, `Facebook`, `Google`,
#' `SignInWithApple`, `LoginWithAmazon`, and the names of your own SAML and
#' OIDC providers.
#' @param CallbackURLs A list of allowed redirect (callback) URLs for the IdPs.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for http://localhost for
#' testing purposes only.
#' 
#' App callback URLs such as `myapp://example` are also supported.
#' @param LogoutURLs A list of allowed logout URLs for the IdPs.
#' @param DefaultRedirectURI The default redirect URI. Must be in the `CallbackURLs` list.
#' 
#' A redirect URI must:
#' 
#' -   Be an absolute URI.
#' 
#' -   Be registered with the authorization server.
#' 
#' -   Not include a fragment component.
#' 
#' See [OAuth 2.0 - Redirection
#' Endpoint](https://datatracker.ietf.org/doc/html/rfc6749#section-3.1.2).
#' 
#' Amazon Cognito requires HTTPS over HTTP except for `http://localhost`
#' for testing purposes only.
#' 
#' App callback URLs such as `myapp://example` are also supported.
#' @param AllowedOAuthFlows The allowed OAuth flows.
#' 
#' **code**
#' 
#' Use a code grant flow, which provides an authorization code as the
#' response. This code can be exchanged for access tokens with the
#' `/oauth2/token` endpoint.
#' 
#' **implicit**
#' 
#' Issue the access token (and, optionally, ID token, based on scopes)
#' directly to your user.
#' 
#' **client_credentials**
#' 
#' Issue the access token from the `/oauth2/token` endpoint directly to a
#' non-person user using a combination of the client ID and client secret.
#' @param AllowedOAuthScopes The allowed OAuth scopes. Possible values provided by OAuth are `phone`,
#' `email`, `openid`, and `profile`. Possible values provided by Amazon Web
#' Services are `aws.cognito.signin.user.admin`. Custom scopes created in
#' Resource Servers are also supported.
#' @param AllowedOAuthFlowsUserPoolClient Set to true if the client is allowed to follow the OAuth protocol when
#' interacting with Amazon Cognito user pools.
#' @param AnalyticsConfiguration The Amazon Pinpoint analytics configuration necessary to collect metrics
#' for this user pool.
#' 
#' In Amazon Web Services Regions where Amazon Pinpoint isn't available,
#' user pools only support sending events to Amazon Pinpoint projects in
#' us-east-1. In Regions where Amazon Pinpoint is available, user pools
#' support sending events to Amazon Pinpoint projects within that same
#' Region.
#' @param PreventUserExistenceErrors Errors and responses that you want Amazon Cognito APIs to return during
#' authentication, account confirmation, and password recovery when the
#' user doesn't exist in the user pool. When set to `ENABLED` and the user
#' doesn't exist, authentication returns an error indicating either the
#' username or password was incorrect. Account confirmation and password
#' recovery return a response indicating a code was sent to a simulated
#' destination. When set to `LEGACY`, those APIs return a
#' `UserNotFoundException` exception if the user doesn't exist in the user
#' pool.
#' 
#' Valid values include:
#' 
#' -   `ENABLED` - This prevents user existence-related errors.
#' 
#' -   `LEGACY` - This represents the early behavior of Amazon Cognito
#'     where user existence related errors aren't prevented.
#' @param EnableTokenRevocation Activates or deactivates token revocation. For more information about
#' revoking tokens, see
#' [`revoke_token`][cognitoidentityprovider_revoke_token].
#' @param EnablePropagateAdditionalUserContextData Activates the propagation of additional user context data. For more
#' information about propagation of user context data, see [Adding advanced
#' security to a user
#' pool](https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pool-settings-advanced-security.html).
#' If you don’t include this parameter, you can't send device fingerprint
#' information, including source IP address, to Amazon Cognito advanced
#' security. You can only activate
#' `EnablePropagateAdditionalUserContextData` in an app client that has a
#' client secret.
#' @param AuthSessionValidity Amazon Cognito creates a session token for each API request in an
#' authentication flow. `AuthSessionValidity` is the duration, in minutes,
#' of that session token. Your user pool native user must respond to each
#' authentication challenge before the session expires.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool_client
cognitoidentityprovider_update_user_pool_client <- function(UserPoolId, ClientId, ClientName = NULL, RefreshTokenValidity = NULL, AccessTokenValidity = NULL, IdTokenValidity = NULL, TokenValidityUnits = NULL, ReadAttributes = NULL, WriteAttributes = NULL, ExplicitAuthFlows = NULL, SupportedIdentityProviders = NULL, CallbackURLs = NULL, LogoutURLs = NULL, DefaultRedirectURI = NULL, AllowedOAuthFlows = NULL, AllowedOAuthScopes = NULL, AllowedOAuthFlowsUserPoolClient = NULL, AnalyticsConfiguration = NULL, PreventUserExistenceErrors = NULL, EnableTokenRevocation = NULL, EnablePropagateAdditionalUserContextData = NULL, AuthSessionValidity = NULL) {
  op <- new_operation(
    name = "UpdateUserPoolClient",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_client_input(UserPoolId = UserPoolId, ClientId = ClientId, ClientName = ClientName, RefreshTokenValidity = RefreshTokenValidity, AccessTokenValidity = AccessTokenValidity, IdTokenValidity = IdTokenValidity, TokenValidityUnits = TokenValidityUnits, ReadAttributes = ReadAttributes, WriteAttributes = WriteAttributes, ExplicitAuthFlows = ExplicitAuthFlows, SupportedIdentityProviders = SupportedIdentityProviders, CallbackURLs = CallbackURLs, LogoutURLs = LogoutURLs, DefaultRedirectURI = DefaultRedirectURI, AllowedOAuthFlows = AllowedOAuthFlows, AllowedOAuthScopes = AllowedOAuthScopes, AllowedOAuthFlowsUserPoolClient = AllowedOAuthFlowsUserPoolClient, AnalyticsConfiguration = AnalyticsConfiguration, PreventUserExistenceErrors = PreventUserExistenceErrors, EnableTokenRevocation = EnableTokenRevocation, EnablePropagateAdditionalUserContextData = EnablePropagateAdditionalUserContextData, AuthSessionValidity = AuthSessionValidity)
  output <- .cognitoidentityprovider$update_user_pool_client_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool_client <- cognitoidentityprovider_update_user_pool_client

#' Updates the Secure Sockets Layer (SSL) certificate for the custom domain
#' for your user pool
#'
#' @description
#' Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool_domain/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_update_user_pool_domain/) for full documentation.
#'
#' @param Domain &#91;required&#93; The domain name for the custom domain that hosts the sign-up and sign-in
#' pages for your application. One example might be `auth.example.com`.
#' 
#' This string can include only lowercase letters, numbers, and hyphens.
#' Don't use a hyphen for the first or last character. Use periods to
#' separate subdomain names.
#' @param UserPoolId &#91;required&#93; The ID of the user pool that is associated with the custom domain whose
#' certificate you're updating.
#' @param CustomDomainConfig &#91;required&#93; The configuration for a custom domain that hosts the sign-up and sign-in
#' pages for your application. Use this object to specify an SSL
#' certificate that is managed by ACM.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_update_user_pool_domain
cognitoidentityprovider_update_user_pool_domain <- function(Domain, UserPoolId, CustomDomainConfig) {
  op <- new_operation(
    name = "UpdateUserPoolDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$update_user_pool_domain_input(Domain = Domain, UserPoolId = UserPoolId, CustomDomainConfig = CustomDomainConfig)
  output <- .cognitoidentityprovider$update_user_pool_domain_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$update_user_pool_domain <- cognitoidentityprovider_update_user_pool_domain

#' Use this API to register a user's entered time-based one-time password
#' (TOTP) code and mark the user's software token MFA status as "verified"
#' if successful
#'
#' @description
#' Use this API to register a user's entered time-based one-time password (TOTP) code and mark the user's software token MFA status as "verified" if successful. The request takes an access token or a session string, but not both.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_verify_software_token/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_verify_software_token/) for full documentation.
#'
#' @param AccessToken A valid access token that Amazon Cognito issued to the user whose
#' software token you want to verify.
#' @param Session The session that should be passed both ways in challenge-response calls
#' to the service.
#' @param UserCode &#91;required&#93; The one- time password computed using the secret code returned by
#' [`associate_software_token`][cognitoidentityprovider_associate_software_token].
#' @param FriendlyDeviceName The friendly device name.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_verify_software_token
cognitoidentityprovider_verify_software_token <- function(AccessToken = NULL, Session = NULL, UserCode, FriendlyDeviceName = NULL) {
  op <- new_operation(
    name = "VerifySoftwareToken",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$verify_software_token_input(AccessToken = AccessToken, Session = Session, UserCode = UserCode, FriendlyDeviceName = FriendlyDeviceName)
  output <- .cognitoidentityprovider$verify_software_token_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$verify_software_token <- cognitoidentityprovider_verify_software_token

#' Verifies the specified user attributes in the user pool
#'
#' @description
#' Verifies the specified user attributes in the user pool.
#'
#' See [https://www.paws-r-sdk.com/docs/cognitoidentityprovider_verify_user_attribute/](https://www.paws-r-sdk.com/docs/cognitoidentityprovider_verify_user_attribute/) for full documentation.
#'
#' @param AccessToken &#91;required&#93; A valid access token that Amazon Cognito issued to the user whose user
#' attributes you want to verify.
#' @param AttributeName &#91;required&#93; The attribute name in the request to verify user attributes.
#' @param Code &#91;required&#93; The verification code in the request to verify user attributes.
#'
#' @keywords internal
#'
#' @rdname cognitoidentityprovider_verify_user_attribute
cognitoidentityprovider_verify_user_attribute <- function(AccessToken, AttributeName, Code) {
  op <- new_operation(
    name = "VerifyUserAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .cognitoidentityprovider$verify_user_attribute_input(AccessToken = AccessToken, AttributeName = AttributeName, Code = Code)
  output <- .cognitoidentityprovider$verify_user_attribute_output()
  config <- get_config()
  svc <- .cognitoidentityprovider$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cognitoidentityprovider$operations$verify_user_attribute <- cognitoidentityprovider_verify_user_attribute
