% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_get_key_policy}
\alias{kms_get_key_policy}
\title{Gets a key policy attached to the specified KMS key}
\usage{
kms_get_key_policy(KeyId, PolicyName)
}
\arguments{
\item{KeyId}{[required] Gets the key policy for the specified KMS key.

Specify the key ID or key ARN of the KMS key.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a KMS key, use
\code{\link[=kms_list_keys]{list_keys}} or \code{\link[=kms_describe_key]{describe_key}}.}

\item{PolicyName}{[required] Specifies the name of the key policy. The only valid name is \code{default}.
To get the names of key policies, use
\code{\link[=kms_list_key_policies]{list_key_policies}}.}
}
\description{
Gets a key policy attached to the specified KMS key.

See \url{https://paws-r.github.io/docs/kms/get_key_policy.html} for full documentation.
}
\keyword{internal}
