% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_create_conditional_forwarder}
\alias{directoryservice_create_conditional_forwarder}
\title{Creates a conditional forwarder associated with your Amazon Web Services
directory}
\usage{
directoryservice_create_conditional_forwarder(
  DirectoryId,
  RemoteDomainName,
  DnsIpAddrs
)
}
\arguments{
\item{DirectoryId}{[required] The directory ID of the Amazon Web Services directory for which you are
creating the conditional forwarder.}

\item{RemoteDomainName}{[required] The fully qualified domain name (FQDN) of the remote domain with which
you will set up a trust relationship.}

\item{DnsIpAddrs}{[required] The IP addresses of the remote DNS server associated with
RemoteDomainName.}
}
\description{
Creates a conditional forwarder associated with your Amazon Web Services directory. Conditional forwarders are required in order to set up a trust relationship with another domain. The conditional forwarder points to the trusted domain.

See \url{https://paws-r.github.io/docs/directoryservice/create_conditional_forwarder.html} for full documentation.
}
\keyword{internal}
