% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_update_user_pool_domain}
\alias{cognitoidentityprovider_update_user_pool_domain}
\title{Updates the Secure Sockets Layer (SSL) certificate for the custom domain
for your user pool}
\usage{
cognitoidentityprovider_update_user_pool_domain(
  Domain,
  UserPoolId,
  CustomDomainConfig
)
}
\arguments{
\item{Domain}{[required] The domain name for the custom domain that hosts the sign-up and sign-in
pages for your application. One example might be \code{auth.example.com}.

This string can include only lowercase letters, numbers, and hyphens.
Don't use a hyphen for the first or last character. Use periods to
separate subdomain names.}

\item{UserPoolId}{[required] The ID of the user pool that is associated with the custom domain whose
certificate you're updating.}

\item{CustomDomainConfig}{[required] The configuration for a custom domain that hosts the sign-up and sign-in
pages for your application. Use this object to specify an SSL
certificate that is managed by ACM.}
}
\description{
Updates the Secure Sockets Layer (SSL) certificate for the custom domain for your user pool.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/update_user_pool_domain.html} for full documentation.
}
\keyword{internal}
