% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_delete_geo_match_set}
\alias{wafregional_delete_geo_match_set}
\title{Permanently deletes a GeoMatchSet}
\usage{
wafregional_delete_geo_match_set(GeoMatchSetId, ChangeToken)
}
\arguments{
\item{GeoMatchSetId}{[required] The \code{GeoMatchSetID} of the GeoMatchSet that you want to delete.
\code{GeoMatchSetId} is returned by CreateGeoMatchSet and by
ListGeoMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Permanently deletes a GeoMatchSet. You can't delete a \code{GeoMatchSet} if
it's still used in any \code{Rules} or if it still includes any countries.
}
\details{
If you just want to remove a \code{GeoMatchSet} from a \code{Rule}, use
UpdateRule.

To permanently delete a \code{GeoMatchSet} from AWS WAF, perform the
following steps:
\enumerate{
\item Update the \code{GeoMatchSet} to remove any countries. For more
information, see UpdateGeoMatchSet.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of a \code{DeleteGeoMatchSet} request.
\item Submit a \code{DeleteGeoMatchSet} request.
}
}
\section{Request syntax}{
\preformatted{svc$delete_geo_match_set(
  GeoMatchSetId = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
