% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_service.R
\name{ram}
\alias{ram}
\title{AWS Resource Access Manager}
\usage{
ram(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Use AWS Resource Access Manager to share AWS resources between AWS
accounts. To share a resource, you create a resource share, associate
the resource with the resource share, and specify the principals that
can access the resource. The following principals are supported:
\itemize{
\item The ID of an AWS account
\item The Amazon Resource Name (ARN) of an OU from AWS Organizations
\item The Amazon Resource Name (ARN) of an organization from AWS
Organizations
}

If you specify an AWS account that doesn't exist in the same
organization as the account that owns the resource share, the owner of
the specified account receives an invitation to accept the resource
share. After the owner accepts the invitation, they can access the
resources in the resource share. An administrator of the specified
account can use IAM policies to restrict access resources in the
resource share.
}
\section{Service syntax}{
\preformatted{svc <- ram(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=ram_accept_resource_share_invitation]{accept_resource_share_invitation} \tab Accepts an invitation to a resource share from another AWS account \cr
\link[=ram_associate_resource_share]{associate_resource_share} \tab Associates the specified resource share with the specified principals and resources \cr
\link[=ram_create_resource_share]{create_resource_share} \tab Creates a resource share \cr
\link[=ram_delete_resource_share]{delete_resource_share} \tab Deletes the specified resource share \cr
\link[=ram_disassociate_resource_share]{disassociate_resource_share} \tab Disassociates the specified principals or resources from the specified resource share\cr
\link[=ram_enable_sharing_with_aws_organization]{enable_sharing_with_aws_organization} \tab Enables resource sharing within your organization \cr
\link[=ram_get_resource_policies]{get_resource_policies} \tab Gets the policies for the specifies resources \cr
\link[=ram_get_resource_share_associations]{get_resource_share_associations} \tab Gets the associations for the specified resource share \cr
\link[=ram_get_resource_share_invitations]{get_resource_share_invitations} \tab Gets the specified invitations for resource sharing \cr
\link[=ram_get_resource_shares]{get_resource_shares} \tab Gets the specified resource shares or all of your resource shares \cr
\link[=ram_list_principals]{list_principals} \tab Lists the principals with access to the specified resource \cr
\link[=ram_list_resources]{list_resources} \tab Lists the resources that the specified principal can access \cr
\link[=ram_reject_resource_share_invitation]{reject_resource_share_invitation} \tab Rejects an invitation to a resource share from another AWS account \cr
\link[=ram_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource share \cr
\link[=ram_untag_resource]{untag_resource} \tab Removes the specified tags from the specified resource share \cr
\link[=ram_update_resource_share]{update_resource_share} \tab Updates the specified resource share
}
}

\examples{
\donttest{svc <- ram()
svc$accept_resource_share_invitation(
  Foo = 123
)}

}
