% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_create_identity_provider}
\alias{cognitoidentityprovider_create_identity_provider}
\title{Creates an identity provider for a user pool}
\usage{
cognitoidentityprovider_create_identity_provider(UserPoolId,
  ProviderName, ProviderType, ProviderDetails, AttributeMapping,
  IdpIdentifiers)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID.}

\item{ProviderName}{[required] The identity provider name.}

\item{ProviderType}{[required] The identity provider type.}

\item{ProviderDetails}{[required] The identity provider details, such as \code{MetadataURL} and \code{MetadataFile}.}

\item{AttributeMapping}{A mapping of identity provider attributes to standard and custom user
pool attributes.}

\item{IdpIdentifiers}{A list of identity provider identifiers.}
}
\description{
Creates an identity provider for a user pool.
}
\section{Request syntax}{
\preformatted{svc$create_identity_provider(
  UserPoolId = "string",
  ProviderName = "string",
  ProviderType = "SAML"|"Facebook"|"Google"|"LoginWithAmazon"|"OIDC",
  ProviderDetails = list(
    "string"
  ),
  AttributeMapping = list(
    "string"
  ),
  IdpIdentifiers = list(
    "string"
  )
)
}
}

\keyword{internal}
