% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_create_certificate_authority_audit_report}
\alias{acmpca_create_certificate_authority_audit_report}
\title{Creates an audit report that lists every time that your CA private key
is used}
\usage{
acmpca_create_certificate_authority_audit_report(
  CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) of the CA to be audited. This is of the
form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{S3BucketName}{[required] The name of the S3 bucket that will contain the audit report.}

\item{AuditReportResponseFormat}{[required] The format in which to create the report. This can be either \strong{JSON} or
\strong{CSV}.}
}
\description{
Creates an audit report that lists every time that your CA private key
is used. The report is saved in the Amazon S3 bucket that you specify on
input. The IssueCertificate and RevokeCertificate actions use the
private key.
}
\section{Request syntax}{
\preformatted{svc$create_certificate_authority_audit_report(
  CertificateAuthorityArn = "string",
  S3BucketName = "string",
  AuditReportResponseFormat = "JSON"|"CSV"
)
}
}

\keyword{internal}
