% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_generate_service_last_accessed_details}
\alias{iam_generate_service_last_accessed_details}
\title{Generates a report that includes details about when an IAM resource
(user, group, role, or policy) was last used in an attempt to access AWS
services}
\usage{
iam_generate_service_last_accessed_details(Arn, Granularity)
}
\arguments{
\item{Arn}{[required] The ARN of the IAM resource (user, group, role, or managed policy) used
to generate information about when the resource was last used in an
attempt to access an AWS service.}

\item{Granularity}{The level of detail that you want to generate. You can specify whether
you want to generate information about the last attempt to access
services or actions. If you specify service-level granularity, this
operation generates only service data. If you specify action-level
granularity, it generates service and action data. If you don't include
this optional parameter, the operation generates service data.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobId = "string"
)
}
}
\description{
Generates a report that includes details about when an IAM resource
(user, group, role, or policy) was last used in an attempt to access AWS
services. Recent activity usually appears within four hours. IAM reports
activity for the last 365 days, or less if your Region began supporting
this feature within the last year. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html#access-advisor_tracking-period}{Regions Where Data Is Tracked}.

The service last accessed data includes all attempts to access an AWS
API, not just the successful ones. This includes all attempts that were
made using the AWS Management Console, the AWS API through any of the
SDKs, or any of the command line tools. An unexpected entry in the
service last accessed data does not mean that your account has been
compromised, because the request might have been denied. Refer to your
CloudTrail logs as the authoritative source for information about all
API calls and whether they were successful or denied access. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/cloudtrail-integration.html}{Logging IAM Events with CloudTrail}
in the \emph{IAM User Guide}.

The
\code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}}
operation returns a \code{JobId}. Use this parameter in the following
operations to retrieve the following details from your report:
\itemize{
\item \code{\link[=iam_get_service_last_accessed_details]{get_service_last_accessed_details}}
– Use this operation for users, groups, roles, or policies to list
every AWS service that the resource could access using permissions
policies. For each service, the response includes information about
the most recent access attempt.

The \code{JobId} returned by \code{GenerateServiceLastAccessedDetail} must be
used by the same role within a session, or by the same user when
used to call \code{GetServiceLastAccessedDetail}.
\item \code{\link[=iam_get_service_last_accessed_details_with_entities]{get_service_last_accessed_details_with_entities}}
– Use this operation for groups and policies to list information
about the associated entities (users or roles) that attempted to
access a specific AWS service.
}

To check the status of the
\code{\link[=iam_generate_service_last_accessed_details]{generate_service_last_accessed_details}}
request, use the \code{JobId} parameter in the same operations and test the
\code{JobStatus} response parameter.

For additional information about the permissions policies that allow an
identity (user, group, or role) to access specific services, use the
\code{\link[=iam_list_policies_granting_service_access]{list_policies_granting_service_access}}
operation.

Service last accessed data does not use other policy types when
determining whether a resource could access a service. These other
policy types include resource-based policies, access control lists, AWS
Organizations policies, IAM permissions boundaries, and AWS STS assume
role policies. It only applies permissions policy logic. For more about
the evaluation of policy types, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_evaluation-logic.html#policy-eval-basics}{Evaluating Policies}
in the \emph{IAM User Guide}.

For more information about service and action last accessed data, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies_access-advisor.html}{Reducing Permissions Using Service Last Accessed Data}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$generate_service_last_accessed_details(
  Arn = "string",
  Granularity = "SERVICE_LEVEL"|"ACTION_LEVEL"
)
}
}

\examples{
\dontrun{
# The following operation generates a report for the policy:
# ExamplePolicy1
svc$generate_service_last_accessed_details(
  Arn = "arn:aws:iam::123456789012:policy/ExamplePolicy1"
)
}

}
\keyword{internal}
